/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms003NetworkBuilder;

public class Nms003Test
extends LinkdTestBuilder {
    Nms003NetworkBuilder builder = new Nms003NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms003/switch1-walk.txt"), @JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms003/switch2-walk.txt"), @JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms003/switch3-walk.txt")})
    public void testNetwork003Links() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.save((Object)this.builder.getSwitch2());
        this.m_nodeDao.save((Object)this.builder.getSwitch3());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseBridgeDiscovery(true);
        example1.setUseOspfDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setUseCdpDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveStpNodeTable(false);
        example1.setUseIsisDiscovery(false);
        example1.setUseWifiDiscovery(false);
        OnmsNode switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1");
        OnmsNode switch2 = this.m_nodeDao.findByForeignId("linkd", "Switch2");
        OnmsNode switch3 = this.m_nodeDao.findByForeignId("linkd", "Switch3");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch3.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)2L, (long)this.m_dataLinkInterfaceDao.countAll());
        List datalinkinterfaces = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(datalinkinterfaces);
        for (DataLinkInterface datalinkinterface : datalinkinterfaces) {
            Integer linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(switch1, switch2, 5001, 5001, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)datalinkinterface.getProtocol());
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(switch2, switch3, 5002, 5001, datalinkinterface);
                Assert.assertEquals((Object)DataLinkInterface.DiscoveryProtocol.bridge, (Object)datalinkinterface.getProtocol());
                continue;
            }
            this.checkLink(switch1, switch1, -1, -1, datalinkinterface);
        }
    }
}

