/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.topology.LinkableNode;
import org.opennms.netmgt.nb.Nms0001NetworkBuilder;

public class Nms0001Test
extends LinkdTestBuilder {
    Nms0001NetworkBuilder builder = new Nms0001NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt"), @JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt"), @JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsIsLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getFroh());
        this.m_nodeDao.save((Object)this.builder.getOedipus());
        this.m_nodeDao.save((Object)this.builder.getSiegFrie());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseBridgeDiscovery(false);
        example1.setUseIpRouteDiscovery(false);
        example1.setEnableVlanDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseLldpDiscovery(false);
        example1.setSaveStpInterfaceTable(false);
        example1.setSaveRouteTable(false);
        example1.setSaveStpNodeTable(false);
        OnmsNode froh = this.m_nodeDao.findByForeignId("linkd", "froh");
        OnmsNode oedipus = this.m_nodeDao.findByForeignId("linkd", "oedipus");
        OnmsNode siegfrie = this.m_nodeDao.findByForeignId("linkd", "siegfrie");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(froh.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(oedipus.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(siegfrie.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(froh.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(oedipus.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(siegfrie.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_dataLinkInterfaceDao.countAll());
        Collection nodes = this.m_linkd.getLinkableNodesOnPackage("example1");
        Assert.assertEquals((long)3L, (long)nodes.size());
        block5: for (LinkableNode node : nodes) {
            Assert.assertEquals((long)2L, (long)node.getIsisInterfaces().size());
            switch (node.getNodeId()) {
                case 1: {
                    Assert.assertEquals((Object)"000110088500", (Object)node.getIsisSysId());
                    continue block5;
                }
                case 2: {
                    Assert.assertEquals((Object)"000110255062", (Object)node.getIsisSysId());
                    continue block5;
                }
                case 3: {
                    Assert.assertEquals((Object)"000110255054", (Object)node.getIsisSysId());
                    continue block5;
                }
            }
            Assert.assertEquals((long)-1L, (long)node.getNodeId());
        }
        Assert.assertTrue((boolean)this.m_linkd.runSingleLinkDiscovery("example1"));
        Assert.assertEquals((long)3L, (long)this.m_dataLinkInterfaceDao.countAll());
        List datalinkinterfaces = this.m_dataLinkInterfaceDao.findAll();
        int start = this.getStartPoint(datalinkinterfaces);
        for (DataLinkInterface datalinkinterface : datalinkinterfaces) {
            Integer linkid = datalinkinterface.getId();
            if (linkid == start) {
                this.checkLink(froh, oedipus, 599, 578, datalinkinterface);
                continue;
            }
            if (linkid == start + 1) {
                this.checkLink(froh, siegfrie, 600, 552, datalinkinterface);
                continue;
            }
            if (linkid == start + 2) {
                this.checkLink(oedipus, siegfrie, 575, 533, datalinkinterface);
                continue;
            }
            this.checkLink(froh, froh, -1, -1, datalinkinterface);
        }
        DataLinkInterface iface = (DataLinkInterface)this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(froh.getId(), Integer.valueOf(599)).iterator().next();
        iface.setNodeParentId(oedipus.getId());
        iface.setParentIfIndex(Integer.valueOf(578));
        iface.setStatus(OnmsArpInterface.StatusType.ACTIVE);
        iface.setLastPollTime(new Date());
        this.m_dataLinkInterfaceDao.saveOrUpdate((Object)iface);
        Assert.assertEquals((long)3L, (long)this.m_dataLinkInterfaceDao.countAll());
    }
}

