/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.Properties;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.LinkdConfigFactory;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.LinkdTestHelper;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-linkd.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.provisiond.enableDiscovery=false"})
@JUnitTemporaryDatabase
public abstract class LinkdTestBuilder
extends LinkdTestHelper {
    private boolean firstTest = true;
    @Autowired
    protected Linkd m_linkd;
    @Autowired
    protected LinkdConfig m_linkdConfig;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        if (this.firstTest) {
            this.setUpLogging();
        } else {
            this.setUpLinkdConfiguration();
        }
        this.firstTest = false;
    }

    public void setUpLogging() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.hibernate.SQL", "WARN");
        p.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
        p.setProperty("log4j.logger.org.springframework", "WARN");
        p.setProperty("log4j.logger.com.mchange.v2.resourcepool", "WARN");
        MockLogAppender.setupLogging((Properties)p);
    }

    public void setUpLinkdConfiguration() throws Exception {
        ClassPathResource config = new ClassPathResource("etc/linkd-configuration.xml");
        this.m_linkdConfig = new LinkdConfigFactory(config.getInputStream());
        this.m_linkd.setLinkdConfig(this.m_linkdConfig);
    }

    @After
    public void tearDown() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
    }
}

