/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.linkd.HibernateEventWriter;
import org.opennms.netmgt.linkd.LinkdTestBuilder;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.netmgt.model.topology.AtInterface;
import org.opennms.netmgt.model.topology.LinkableNode;
import org.opennms.netmgt.nb.Nms101NetworkBuilder;
import org.opennms.netmgt.nb.Nms7467NetworkBuilder;
import org.springframework.transaction.annotation.Transactional;

public class LinkdTest
extends LinkdTestBuilder {
    Nms7467NetworkBuilder builder = new Nms7467NetworkBuilder();
    Nms101NetworkBuilder builder1 = new Nms101NetworkBuilder();

    @Test
    @Transactional
    public void testDefaultConfiguration() throws Exception {
        this.m_nodeDao.save((Object)this.builder1.getExampleCom());
        this.m_nodeDao.save((Object)this.builder1.getLaptop());
        this.m_nodeDao.save((Object)this.builder1.getCisco7200a());
        this.m_nodeDao.save((Object)this.builder1.getCisco7200b());
        this.m_nodeDao.save((Object)this.builder1.getCisco3700());
        this.m_nodeDao.save((Object)this.builder1.getCisco2691());
        this.m_nodeDao.save((Object)this.builder1.getCisco1700());
        this.m_nodeDao.save((Object)this.builder1.getCisco3600());
        this.m_nodeDao.flush();
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useOspfDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useIpRouteDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useCdpDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useIsIsDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveRouteTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveStpNodeTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveStpInterfaceTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.isVlanDiscoveryEnabled());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.isAutoDiscoveryEnabled());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.forceIpRouteDiscoveryOnEthernet());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.hasClassName(".1.3.6.1.4.1.2636.1.1.1.1.9"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.9.13.3.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.10.27.4.1.2.4"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.10.27.4.1.2.2"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.10.27.4.1.2.11"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.16.4.3.5"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ThreeComVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.16.4.3.6"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.8.43"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.43.1.8.61"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.RapidCityVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.45.3.61.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.RapidCityVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.45.3.35.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.RapidCityVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.45.3.53.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IntelVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.343.5.1.5"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.1"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.3"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.7"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.8"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.11"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.6"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.Dot1qStaticVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.11.2.3.7.11.50"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.1.300"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.1.122"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.1.616"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.5.42"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.9.5.59"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ExtremeNetworkVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.1916.2.11"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ExtremeNetworkVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.1916.2.14"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.ExtremeNetworkVlanTable", (Object)this.m_linkdConfig.getVlanClassName(".1.3.6.1.4.1.1916.2.63"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpCidrRouteTable", (Object)this.m_linkdConfig.getDefaultIpRouteClassName());
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)this.m_linkdConfig.getIpRouteClassName(".1.3.6.1.4.1.3224.1.51"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)this.m_linkdConfig.getIpRouteClassName(".1.3.6.1.4.1.9.1.569"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)this.m_linkdConfig.getIpRouteClassName(".1.3.6.1.4.1.9.5.42"));
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)this.m_linkdConfig.getIpRouteClassName(".1.3.6.1.4.1.8072.3.2.255"));
        OnmsNode laptop = this.m_nodeDao.findByForeignId("linkd", "laptop");
        OnmsNode cisco3600 = this.m_nodeDao.findByForeignId("linkd", "cisco3600");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(laptop.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3600.getId().intValue()));
        SnmpCollection snmpCollLaptop = this.m_linkd.getSnmpCollection(laptop.getId().intValue(), laptop.getPrimaryInterface().getIpAddress(), laptop.getSysObjectId(), "example1");
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectBridge());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectStp());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectCdp());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectIpRoute());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectOspf());
        Assert.assertEquals((Object)true, (Object)snmpCollLaptop.getCollectLldp());
        Assert.assertEquals((Object)false, (Object)snmpCollLaptop.collectVlanTable());
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpRouteTable", (Object)snmpCollLaptop.getIpRouteClass());
        Assert.assertEquals((Object)"example1", (Object)snmpCollLaptop.getPackageName());
        Assert.assertEquals((Object)true, (Object)this.m_linkd.saveRouteTable("example1"));
        Assert.assertEquals((Object)true, (Object)this.m_linkd.saveStpNodeTable("example1"));
        Assert.assertEquals((Object)true, (Object)this.m_linkd.saveStpInterfaceTable("example1"));
        SnmpCollection snmpCollcisco3600 = this.m_linkd.getSnmpCollection(cisco3600.getId().intValue(), cisco3600.getPrimaryInterface().getIpAddress(), cisco3600.getSysObjectId(), "example1");
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectBridge());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectStp());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectCdp());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectIpRoute());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectOspf());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.getCollectLldp());
        Assert.assertEquals((Object)true, (Object)snmpCollcisco3600.collectVlanTable());
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.CiscoVlanTable", (Object)snmpCollcisco3600.getVlanClass());
        Assert.assertEquals((Object)"org.opennms.netmgt.linkd.snmp.IpCidrRouteTable", (Object)snmpCollcisco3600.getIpRouteClass());
        Assert.assertEquals((Object)"example1", (Object)snmpCollcisco3600.getPackageName());
        Package example1 = this.m_linkdConfig.getPackage("example1");
        Assert.assertEquals((Object)false, (Object)example1.getForceIpRouteDiscoveryOnEthernet());
        Enumeration pkgs = this.m_linkdConfig.enumeratePackage();
        example1 = (Package)pkgs.nextElement();
        Assert.assertEquals((Object)"example1", (Object)example1.getName());
        Assert.assertEquals((Object)false, (Object)pkgs.hasMoreElements());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.7", port=161, resource="classpath:linkd/nms7467/192.0.2.7-walk.txt")})
    public void testCiscoWsC2948Collection() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        example1.setForceIpRouteDiscoveryOnEthernet(true);
        OnmsNode ciscosw = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscosw.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscosw.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)2L, (long)this.m_ipRouteInterfaceDao.countAll());
        Assert.assertEquals((long)5L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"192.0.2.7")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((long)1L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((Object)"0002baaacc00", (Object)linkNode.getBridgeIdentifier(Integer.valueOf(1)));
        Assert.assertEquals((long)50L, (long)((List)linkNode.getStpInterfaces().get(1)).size());
        Assert.assertEquals((String)"No cdp interface because no other node is there", (long)0L, (long)linkNode.getCdpInterfaces().size());
        for (OnmsStpInterface stpiface : (List)linkNode.getStpInterfaces().get(1)) {
            Assert.assertTrue((String)"should have a valid ifindex", (stpiface.getIfIndex() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"should have a valid bridgeport", (stpiface.getBridgePort() > 0 ? 1 : 0) != 0);
        }
        List atInterfaces = this.m_linkd.getAtInterfaces(packageName, "0002baaacffe");
        Assert.assertNotNull((Object)atInterfaces);
        Assert.assertEquals((long)1L, (long)atInterfaces.size());
        AtInterface at = (AtInterface)atInterfaces.get(0);
        Assert.assertEquals((Object)"192.0.2.7", (Object)at.getIpAddress().getHostAddress());
        Assert.assertEquals((long)3L, (long)at.getIfIndex().intValue());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)ciscosw.getId()));
        Assert.assertEquals((long)2L, (long)this.m_ipRouteInterfaceDao.findMatching(criteria).size());
        Assert.assertEquals((long)0L, (long)this.m_atInterfaceDao.findAll().size());
        Assert.assertEquals((long)5L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)1L, (long)this.m_stpNodeDao.countAll());
        OnmsStpNode stpnode = this.m_stpNodeDao.findByNodeAndVlan(ciscosw.getId(), Integer.valueOf(1));
        Assert.assertTrue((boolean)"0002baaacc00".equals(stpnode.getBaseBridgeAddress()));
        Assert.assertEquals((long)50L, (long)stpnode.getBaseNumPorts().intValue());
        Assert.assertEquals((Object)OnmsStpNode.BridgeBaseType.TRANSPARENT_ONLY, (Object)stpnode.getBaseType());
        Assert.assertEquals((Object)OnmsStpNode.StpProtocolSpecification.IEEE8021D, (Object)stpnode.getStpProtocolSpecification());
        Assert.assertEquals((long)50L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.1", port=161, resource="classpath:linkd/nms7467/192.0.2.1-walk.txt")})
    public void testCiscoC870Collection() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getCiscoC870());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscorouter.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"192.0.2.1")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((long)1L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((Object)"00000c83d9a8", (Object)linkNode.getBridgeIdentifier(Integer.valueOf(1)));
        Assert.assertEquals((long)1L, (long)((List)linkNode.getStpInterfaces().get(1)).size());
        Assert.assertEquals((String)"No cdp interface because no other node is there", (long)0L, (long)linkNode.getCdpInterfaces().size());
        for (OnmsStpInterface stpiface : (List)linkNode.getStpInterfaces().get(1)) {
            Assert.assertTrue((String)"should have a valid ifindex", (stpiface.getIfIndex() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"should have a valid bridgeport", (stpiface.getBridgePort() > 0 ? 1 : 0) != 0);
        }
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage(packageName);
        Assert.assertEquals((long)2L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces(packageName, "001f6cd034e7");
        Assert.assertNotNull((Object)ats);
        Assert.assertEquals((long)3L, (long)ats.size());
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("192.0.2.1")) {
                Assert.assertEquals((long)12L, (long)at.getIfIndex().intValue());
                continue;
            }
            if (at.getIpAddress().getHostAddress().equals("198.51.100.1")) {
                Assert.assertEquals((long)13L, (long)at.getIfIndex().intValue());
                continue;
            }
            if (at.getIpAddress().getHostAddress().equals("10.255.255.2")) {
                Assert.assertEquals((long)12L, (long)at.getIfIndex().intValue());
                continue;
            }
            Assert.assertTrue((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"), (boolean)false);
        }
        ats = this.m_linkd.getAtInterfaces(packageName, "00000c03b09e");
        Assert.assertEquals((long)1L, (long)ats.size());
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("65.41.39.146")) {
                Assert.assertEquals((long)14L, (long)at.getIfIndex().intValue());
                continue;
            }
            Assert.assertTrue((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"), (boolean)false);
        }
        Assert.assertEquals((long)4L, (long)this.m_atInterfaceDao.countAll());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)ciscorouter.getId()));
        List iproutes = this.m_ipRouteInterfaceDao.findMatching(criteria);
        for (OnmsIpRouteInterface iproute : iproutes) {
            System.out.println(iproute.getRouteDest() + "/" + iproute.getRouteMask() + "/" + iproute.getRouteNextHop() + "/" + iproute.getRouteIfIndex());
        }
        Assert.assertEquals((long)7L, (long)iproutes.size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)1L, (long)this.m_stpNodeDao.countAll());
        OnmsStpNode stpnode = this.m_stpNodeDao.findByNodeAndVlan(ciscorouter.getId(), Integer.valueOf(1));
        Assert.assertTrue((boolean)"00000c83d9a8".equals(stpnode.getBaseBridgeAddress()));
        Assert.assertEquals((long)1L, (long)stpnode.getBaseNumPorts().intValue());
        Assert.assertEquals((Object)OnmsStpNode.BridgeBaseType.SRT, (Object)stpnode.getBaseType());
        Assert.assertEquals((Object)OnmsStpNode.StpProtocolSpecification.IEEE8021D, (Object)stpnode.getStpProtocolSpecification());
        Assert.assertEquals((long)1L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.8", port=161, resource="classpath:linkd/nms7467/192.0.2.8-walk.txt")})
    public void testNetGearSw108Collection() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getNetGearSw108());
        this.m_nodeDao.flush();
        OnmsNode ngsw108 = this.m_nodeDao.findByForeignId("linkd", "ng108switch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ngsw108.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ngsw108.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"192.0.2.8")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((long)1L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((Object)"00223ff00b7b", (Object)linkNode.getBridgeIdentifier(Integer.valueOf(1)));
        Assert.assertEquals((long)8L, (long)((List)linkNode.getStpInterfaces().get(1)).size());
        Assert.assertEquals((String)"cdp not supported", (long)0L, (long)linkNode.getCdpInterfaces().size());
        for (OnmsStpInterface stpiface : (List)linkNode.getStpInterfaces().get(1)) {
            Assert.assertTrue((String)"should have a valid ifindex", (stpiface.getIfIndex() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"should have a valid bridgeport", (stpiface.getBridgePort() > 0 ? 1 : 0) != 0);
        }
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage(packageName);
        Assert.assertNotNull((Object)macAddresses);
        Assert.assertEquals((long)1L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces(packageName, "00223ff00b7b");
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("192.0.2.8")) {
                Assert.assertTrue((at.getIfIndex() == -1 ? 1 : 0) != 0);
                continue;
            }
            Assert.fail((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"));
        }
        Assert.assertEquals((long)1L, (long)this.m_atInterfaceDao.findAll().size());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)ngsw108.getId()));
        List iproutes = this.m_ipRouteInterfaceDao.findMatching(criteria);
        for (OnmsIpRouteInterface iproute : iproutes) {
            System.out.println(iproute.getRouteDest() + "/" + iproute.getRouteMask() + "/" + iproute.getRouteNextHop() + "/" + iproute.getRouteIfIndex());
        }
        Assert.assertEquals((long)0L, (long)iproutes.size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)1L, (long)this.m_stpNodeDao.countAll());
        OnmsStpNode stpnode = this.m_stpNodeDao.findByNodeAndVlan(ngsw108.getId(), Integer.valueOf(1));
        Assert.assertTrue((boolean)"00223ff00b7b".equals(stpnode.getBaseBridgeAddress()));
        Assert.assertEquals((long)8L, (long)stpnode.getBaseNumPorts().intValue());
        Assert.assertEquals((Object)OnmsStpNode.BridgeBaseType.TRANSPARENT_ONLY, (Object)stpnode.getBaseType());
        Assert.assertEquals((Object)OnmsStpNode.StpProtocolSpecification.IEEE8021D, (Object)stpnode.getStpProtocolSpecification());
        Assert.assertEquals((long)8L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.14", port=161, resource="classpath:linkd/nms7467/192.0.2.14-walk.txt")})
    public void testLinuxUbuntuCollection() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getLinuxUbuntu());
        this.m_nodeDao.flush();
        OnmsNode linux = this.m_nodeDao.findByForeignId("linkd", "linuxubuntu");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(linux.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(linux.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"192.0.2.14")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((Object)false, (Object)linkNode.isBridgeNode());
        Assert.assertEquals((long)0L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((String)"cdp not supported", (long)0L, (long)linkNode.getCdpInterfaces().size());
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage(packageName);
        Assert.assertNotNull((Object)macAddresses);
        Assert.assertEquals((long)1L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces(packageName, "406186e28b53");
        Assert.assertEquals((String)"should have saved 1 ip to mac", (long)1L, (long)ats.size());
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("192.0.2.14")) {
                Assert.assertTrue((at.getIfIndex() == 4 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"), (boolean)false);
        }
        Assert.assertEquals((long)0L, (long)this.m_atInterfaceDao.findAll().size());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)linux.getId()));
        List iproutes = this.m_ipRouteInterfaceDao.findMatching(criteria);
        for (OnmsIpRouteInterface iproute : iproutes) {
            System.out.println(iproute.getRouteDest() + "/" + iproute.getRouteMask() + "/" + iproute.getRouteNextHop() + "/" + iproute.getRouteIfIndex());
        }
        Assert.assertEquals((long)4L, (long)iproutes.size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)0L, (long)this.m_stpNodeDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.28", port=161, resource="classpath:linkd/nms7467/192.0.2.28-walk.txt")})
    public void testDarwin108Collection() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getDarwin108());
        this.m_nodeDao.flush();
        Package example1 = this.m_linkdConfig.getPackage("example1");
        example1.setUseLldpDiscovery(false);
        example1.setUseOspfDiscovery(false);
        example1.setUseIsisDiscovery(false);
        this.m_linkdConfig.update();
        OnmsNode mac = this.m_nodeDao.findByForeignId("linkd", "mac");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(mac.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(mac.getId().intValue()));
        Assert.assertEquals((long)1L, (long)this.m_linkd.getLinkableNodesOnPackage("example1").size());
        LinkableNode linkNode = (LinkableNode)this.m_linkd.getLinkableNodesOnPackage("example1").iterator().next();
        Assert.assertTrue((linkNode != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)linkNode.getRouteInterfaces().size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.countAll());
        String packageName = this.m_linkdConfig.getFirstPackageMatch(InetAddressUtils.addr((String)"192.0.2.28")).getName();
        Assert.assertEquals((Object)"example1", (Object)packageName);
        Assert.assertEquals((Object)false, (Object)linkNode.isBridgeNode());
        Assert.assertEquals((long)0L, (long)linkNode.getBridgeIdentifiers().size());
        Assert.assertEquals((String)"cdp not supported", (long)0L, (long)linkNode.getCdpInterfaces().size());
        Set macAddresses = this.m_linkd.getMacAddressesOnPackage(packageName);
        Assert.assertNotNull((Object)macAddresses);
        Assert.assertEquals((long)1L, (long)macAddresses.size());
        List ats = this.m_linkd.getAtInterfaces(packageName, "0026b0ed8fb8");
        Assert.assertNotNull((Object)ats);
        Assert.assertEquals((String)"should have saved 1 ip to mac", (long)1L, (long)ats.size());
        for (AtInterface at : ats) {
            if (at.getIpAddress().getHostAddress().equals("192.0.2.28")) {
                Assert.assertTrue((at.getIfIndex() == 4 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)("ip: " + at.getIpAddress().getHostAddress() + "does not match any known ip address"), (boolean)false);
        }
        Assert.assertEquals((long)0L, (long)this.m_atInterfaceDao.findAll().size());
        Criteria criteria = new Criteria(OnmsIpRouteInterface.class);
        criteria.setAliases(Arrays.asList(new Alias("node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)mac.getId()));
        List iproutes = this.m_ipRouteInterfaceDao.findMatching(criteria);
        for (OnmsIpRouteInterface iproute : iproutes) {
            System.out.println(iproute.getRouteDest() + "/" + iproute.getRouteMask() + "/" + iproute.getRouteNextHop() + "/" + iproute.getRouteIfIndex());
        }
        Assert.assertEquals((long)20L, (long)iproutes.size());
        Assert.assertEquals((long)0L, (long)this.m_vlanDao.findAll().size());
        Assert.assertEquals((long)0L, (long)this.m_stpNodeDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_stpInterfaceDao.findAll().size());
    }

    @Test
    public void testWorkStation() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getNodeWithoutSnmp("workstation", "192.0.2.101"));
        this.m_nodeDao.flush();
        OnmsNode workstation = this.m_nodeDao.findByForeignId("linkd", "workstation");
        Assert.assertTrue((!this.m_linkd.scheduleNodeCollection(workstation.getId().intValue()) ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultConfiguration2() throws MarshalException, ValidationException, IOException {
        Assert.assertEquals((long)5L, (long)this.m_linkdConfig.getThreads());
        Assert.assertEquals((long)3600000L, (long)this.m_linkdConfig.getInitialSleepTime());
        Assert.assertEquals((long)18000000L, (long)this.m_linkdConfig.getSnmpPollInterval());
        Assert.assertEquals((long)1800000L, (long)this.m_linkdConfig.getDiscoveryLinkInterval());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.isAutoDiscoveryEnabled());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.isVlanDiscoveryEnabled());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useCdpDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useIpRouteDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useOspfDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.useIsIsDiscovery());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveRouteTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveStpNodeTable());
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.saveStpInterfaceTable());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.forceIpRouteDiscoveryOnEthernet());
        Enumeration iter = this.m_linkdConfig.enumeratePackage();
        Package example1 = (Package)iter.nextElement();
        Assert.assertEquals((Object)false, (Object)iter.hasMoreElements());
        Assert.assertEquals((Object)"example1", (Object)example1.getName());
        Assert.assertEquals((Object)false, (Object)example1.hasAutoDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasDiscovery_link_interval());
        Assert.assertEquals((Object)false, (Object)example1.hasEnableVlanDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasForceIpRouteDiscoveryOnEthernet());
        Assert.assertEquals((Object)false, (Object)example1.hasSaveRouteTable());
        Assert.assertEquals((Object)false, (Object)example1.hasSaveStpInterfaceTable());
        Assert.assertEquals((Object)false, (Object)example1.hasSaveStpNodeTable());
        Assert.assertEquals((Object)false, (Object)example1.hasSnmp_poll_interval());
        Assert.assertEquals((Object)false, (Object)example1.hasUseBridgeDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasUseCdpDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasUseIpRouteDiscovery());
        Assert.assertEquals((Object)false, (Object)example1.hasUseIsisDiscovery());
        Assert.assertEquals((Object)false, (Object)this.m_linkdConfig.isInterfaceInPackage(InetAddressUtils.addr((String)"192.0.2.1"), example1));
        this.m_nodeDao.save((Object)this.builder.getCiscoC870());
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.flush();
        this.m_linkdConfig.update();
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.isInterfaceInPackage(InetAddressUtils.addr((String)"192.0.2.1"), example1));
        Assert.assertEquals((Object)true, (Object)this.m_linkdConfig.isInterfaceInPackage(InetAddressUtils.addr((String)"192.0.2.7"), example1));
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        OnmsNode ciscows = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscorouter.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscows.getId().intValue()));
        LinkableNode lciscorouter = this.m_linkd.removeNode("example1", InetAddressUtils.addr((String)"192.0.2.1"));
        Assert.assertNotNull((Object)lciscorouter);
        Assert.assertEquals((long)ciscorouter.getId().intValue(), (long)lciscorouter.getNodeId());
        Assert.assertEquals((long)1L, (long)this.m_linkd.getActivePackages().size());
    }

    @Test
    public void testGetNodeidFromIp() throws UnknownHostException, SQLException {
        this.m_nodeDao.save((Object)this.builder.getCiscoC870());
        this.m_nodeDao.flush();
        HibernateEventWriter db = (HibernateEventWriter)this.m_linkd.getQueryManager();
        OnmsNode node = (OnmsNode)db.getNodeidFromIp(InetAddressUtils.addr((String)"192.0.2.1")).get(0);
        Assert.assertEquals((Object)this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com").getId(), (Object)node.getId());
    }

    @Test
    @Transactional
    public void testGetIfIndexByName() throws SQLException {
        this.m_nodeDao.save((Object)this.builder.getCiscoC870());
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.flush();
        OnmsNode ciscorouter = this.m_nodeDao.findByForeignId("linkd", "mrmakay.internal.opennms.com");
        Assert.assertEquals((Object)"FastEthernet2", (Object)ciscorouter.getSnmpInterfaceWithIfIndex(3).getIfDescr());
        OnmsNode ciscosw = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertEquals((Object)"2/44", (Object)ciscosw.getSnmpInterfaceWithIfIndex(52).getIfName());
        HibernateEventWriter db = (HibernateEventWriter)this.m_linkd.getQueryManager();
        Assert.assertEquals((long)3L, (long)db.getIfIndexByName(ciscorouter.getId().intValue(), "FastEthernet2"));
        Assert.assertEquals((long)52L, (long)db.getIfIndexByName(ciscosw.getId().intValue(), "2/44"));
    }
}

