/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.snmp.CdpCacheTable;
import org.opennms.netmgt.linkd.snmp.CdpCacheTableEntry;
import org.opennms.netmgt.linkd.snmp.CdpInterfaceTable;
import org.opennms.netmgt.linkd.snmp.CdpInterfaceTableEntry;
import org.opennms.netmgt.linkd.snmp.CiscoVlanTable;
import org.opennms.netmgt.linkd.snmp.CiscoVlanTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dBaseGroup;
import org.opennms.netmgt.linkd.snmp.IsIsSystemObjectGroup;
import org.opennms.netmgt.linkd.snmp.IsisCircTable;
import org.opennms.netmgt.linkd.snmp.IsisCircTableEntry;
import org.opennms.netmgt.linkd.snmp.IsisISAdjTable;
import org.opennms.netmgt.linkd.snmp.IsisISAdjTableEntry;
import org.opennms.netmgt.linkd.snmp.LldpLocTable;
import org.opennms.netmgt.linkd.snmp.LldpLocTableEntry;
import org.opennms.netmgt.linkd.snmp.LldpLocalGroup;
import org.opennms.netmgt.linkd.snmp.LldpRemTable;
import org.opennms.netmgt.linkd.snmp.LldpRemTableEntry;
import org.opennms.netmgt.linkd.snmp.MtxrWlRtabTable;
import org.opennms.netmgt.linkd.snmp.MtxrWlRtabTableEntry;
import org.opennms.netmgt.linkd.snmp.OspfGeneralGroup;
import org.opennms.netmgt.linkd.snmp.OspfIfTable;
import org.opennms.netmgt.linkd.snmp.OspfIfTableEntry;
import org.opennms.netmgt.linkd.snmp.OspfNbrTable;
import org.opennms.netmgt.linkd.snmp.OspfNbrTableEntry;
import org.opennms.netmgt.linkd.snmp.QBridgeDot1dTpFdbTable;
import org.opennms.netmgt.linkd.snmp.QBridgeDot1dTpFdbTableEntry;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.topology.OspfNbrInterface;
import org.opennms.netmgt.nb.Nms10205bNetworkBuilder;
import org.opennms.netmgt.nb.NmsNetworkBuilder;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpStore;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml"})
@JUnitConfigurationEnvironment
public class LinkdSnmpTest
extends NmsNetworkBuilder
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.opennms.mock.snmp", "WARN");
        p.setProperty("log4j.logger.org.opennms.core.test.snmp", "WARN");
        p.setProperty("log4j.logger.org.opennms.netmgt", "WARN");
        p.setProperty("log4j.logger.org.springframework", "WARN");
        p.setProperty("log4j.logger.com.mchange.v2.resourcepool", "WARN");
        MockLogAppender.setupLogging((Properties)p);
    }

    @Test
    public void testDiscoveryOspfGetSubNetAddress() throws Exception {
        DiscoveryLink discovery = new DiscoveryLink();
        OspfNbrInterface ospfinterface = new OspfNbrInterface(InetAddressUtils.addr((String)"192.168.9.1"));
        ospfinterface.setOspfNbrIpAddr(InetAddressUtils.addr((String)"192.168.15.45"));
        ospfinterface.setOspfNbrNetMask(InetAddressUtils.addr((String)"255.255.255.0"));
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.15.0"), (Object)discovery.getSubnetAddress(ospfinterface));
        ospfinterface.setOspfNbrNetMask(InetAddressUtils.addr((String)"255.255.0.0"));
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.0.0"), (Object)discovery.getSubnetAddress(ospfinterface));
        ospfinterface.setOspfNbrNetMask(InetAddressUtils.addr((String)"255.255.255.252"));
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.15.44"), (Object)discovery.getSubnetAddress(ospfinterface));
        ospfinterface.setOspfNbrNetMask(InetAddressUtils.addr((String)"255.255.255.240"));
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.15.32"), (Object)discovery.getSubnetAddress(ospfinterface));
    }

    @Test
    public void testBridgePortFromDesignatedBridgePort() {
        Assert.assertEquals((long)5826L, (long)(0x1FFF & Integer.parseInt("96c2", 16)));
        Assert.assertEquals((long)5781L, (long)(0x1FFF & Integer.parseInt("9695", 16)));
        Assert.assertEquals((long)4230L, (long)(0x1FFF & Integer.parseInt("9086", 16)));
        Assert.assertEquals((long)110L, (long)(0x1FFF & Integer.parseInt("806e", 16)));
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt"), @JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt"), @JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsisSysObjGroupCollection() throws Exception {
        String name = "isisSystemObjectGroup";
        IsIsSystemObjectGroup m_isisSystemObjectGroup = new IsIsSystemObjectGroup(InetAddressUtils.addr((String)"192.168.239.51"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_isisSystemObjectGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.51"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)m_isisSystemObjectGroup.getIsisSysAdminState());
        Assert.assertEquals((Object)"000110088500", (Object)m_isisSystemObjectGroup.getIsisSysId());
        m_isisSystemObjectGroup = new IsIsSystemObjectGroup(InetAddressUtils.addr((String)"192.168.239.62"));
        tracker = new CollectionTracker[]{m_isisSystemObjectGroup};
        snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.62"));
        walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)m_isisSystemObjectGroup.getIsisSysAdminState());
        Assert.assertEquals((Object)"000110255062", (Object)m_isisSystemObjectGroup.getIsisSysId());
        m_isisSystemObjectGroup = new IsIsSystemObjectGroup(InetAddressUtils.addr((String)"192.168.239.54"));
        tracker = new CollectionTracker[]{m_isisSystemObjectGroup};
        snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.54"));
        walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)m_isisSystemObjectGroup.getIsisSysAdminState());
        Assert.assertEquals((Object)"000110255054", (Object)m_isisSystemObjectGroup.getIsisSysId());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt"), @JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt"), @JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")})
    public void testIsisISAdjTableCollection() throws Exception {
        String name = "isisISAdjTable";
        IsisISAdjTable m_isisISAdjTable = new IsisISAdjTable(InetAddressUtils.addr((String)"192.168.239.51"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_isisISAdjTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.51"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection isisISAdjTableEntryCollection = m_isisISAdjTable.getEntries();
        Assert.assertEquals((long)2L, (long)isisISAdjTableEntryCollection.size());
        Iterator iter = isisISAdjTableEntryCollection.iterator();
        IsisISAdjTableEntry entry1 = (IsisISAdjTableEntry)iter.next();
        Assert.assertEquals((long)599L, (long)entry1.getIsisCircIndex().intValue());
        Assert.assertEquals((long)1L, (long)entry1.getIsisISAdjIndex().intValue());
        Assert.assertEquals((Object)IsIsLink.IsisISAdjState.up, (Object)entry1.getIsIsAdjStatus());
        Assert.assertEquals((Object)"001f12accbf1", (Object)entry1.getIsIsAdjNeighSnpaAddress());
        Assert.assertEquals((Object)IsIsLink.IsisISAdjNeighSysType.l1_IntermediateSystem, (Object)entry1.getIsisISAdjNeighSysType());
        Assert.assertEquals((Object)"000110255062", (Object)entry1.getIsIsAdjNeighSysId());
        Assert.assertEquals((long)0L, (long)entry1.getIsisAdjNbrExtendedCircID().intValue());
        IsisISAdjTableEntry entry2 = (IsisISAdjTableEntry)iter.next();
        Assert.assertEquals((long)600L, (long)entry2.getIsisCircIndex().intValue());
        Assert.assertEquals((long)1L, (long)entry2.getIsisISAdjIndex().intValue());
        Assert.assertEquals((Object)IsIsLink.IsisISAdjState.up, (Object)entry2.getIsIsAdjStatus());
        Assert.assertEquals((Object)"001f12acc3f2", (Object)entry2.getIsIsAdjNeighSnpaAddress());
        Assert.assertEquals((Object)IsIsLink.IsisISAdjNeighSysType.l1_IntermediateSystem, (Object)entry2.getIsisISAdjNeighSysType());
        Assert.assertEquals((Object)"000110255054", (Object)entry2.getIsIsAdjNeighSysId());
        Assert.assertEquals((long)0L, (long)entry2.getIsisAdjNbrExtendedCircID().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.239.51", port=161, resource="classpath:linkd/nms0001/froh-192.168.239.51-walk.txt"), @JUnitSnmpAgent(host="192.168.239.62", port=161, resource="classpath:linkd/nms0001/oedipus-192.168.239.62-walk.txt"), @JUnitSnmpAgent(host="192.168.239.54", port=161, resource="classpath:linkd/nms0001/siegfrie-192.168.239.54-walk.txt")}, forceMockStrategy=true)
    public void testIsisCircTableCollection() throws Exception {
        String name = "isisCircTable";
        IsisCircTable m_isisCircTable = new IsisCircTable(InetAddressUtils.addr((String)"192.168.239.51"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_isisCircTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.239.51"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection isisCircTableEntryCollection = m_isisCircTable.getEntries();
        Assert.assertEquals((long)3L, (long)isisCircTableEntryCollection.size());
        Iterator iter = isisCircTableEntryCollection.iterator();
        IsisCircTableEntry entry1 = (IsisCircTableEntry)iter.next();
        Assert.assertEquals((long)16L, (long)entry1.getIsisCircIndex().intValue());
        Assert.assertEquals((long)16L, (long)entry1.getIsisCircIfIndex().intValue());
        IsisCircTableEntry entry2 = (IsisCircTableEntry)iter.next();
        Assert.assertEquals((long)599L, (long)entry2.getIsisCircIndex().intValue());
        Assert.assertEquals((long)599L, (long)entry2.getIsisCircIfIndex().intValue());
        IsisCircTableEntry entry3 = (IsisCircTableEntry)iter.next();
        Assert.assertEquals((long)600L, (long)entry3.getIsisCircIndex().intValue());
        Assert.assertEquals((long)600L, (long)entry3.getIsisCircIfIndex().intValue());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.5", port=161, resource="classpath:linkd/nms10205b/Mumbai_10.205.56.5.txt")})
    public void testMumbayOspfGeneralGroupCollection() throws Exception {
        String name = "ospfGeneralGroup";
        OspfGeneralGroup m_ospfGeneralGroup = new OspfGeneralGroup(InetAddressUtils.addr((String)"10.205.56.5"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_ospfGeneralGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.205.56.5"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)MUMBAI_OSPF_ID, (Object)m_ospfGeneralGroup.getOspfRouterId());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.23", port=161, resource="classpath:linkd/nms10205b/SRX-100_10.205.56.23.txt")})
    public void testSrx100OspfGeneralGroupCollection() throws Exception {
        String name = "ospfGeneralGroup";
        OspfGeneralGroup m_ospfGeneralGroup = new OspfGeneralGroup(InetAddressUtils.addr((String)"10.205.56.23"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_ospfGeneralGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.205.56.23"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((Object)SRX_100_OSPF_ID, (Object)m_ospfGeneralGroup.getOspfRouterId());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.5", port=161, resource="classpath:linkd/nms10205b/Mumbai_10.205.56.5.txt")})
    public void testMumbayOspfIfTableCollection() throws Exception {
        Nms10205bNetworkBuilder builder = new Nms10205bNetworkBuilder();
        builder.getMumbai();
        String name = "ospfIfTable";
        OspfIfTable m_ospfIfTable = new OspfIfTable(InetAddressUtils.addr((String)"10.205.56.5"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_ospfIfTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.205.56.5"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Collection ospfifTableCollection = m_ospfIfTable.getEntries();
        Assert.assertEquals((long)6L, (long)ospfifTableCollection.size());
        for (OspfIfTableEntry entry : ospfifTableCollection) {
            Assert.assertEquals((long)0L, (long)entry.getOspfAddressLessIf().intValue());
            InetAddress ospfIpAddress = entry.getOspfIpAddress();
            Assert.assertEquals((Object)true, (Object)MUMBAI_IP_IF_MAP.containsKey(ospfIpAddress));
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.23", port=161, resource="classpath:linkd/nms10205b/SRX-100_10.205.56.23.txt")})
    public void testSrx100OspfIfTableCollection() throws Exception {
        String name = "ospfIfTable";
        OspfIfTable m_ospfIfTable = new OspfIfTable(InetAddressUtils.addr((String)"10.205.56.23"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_ospfIfTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.205.56.23"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Collection ospfifTableCollection = m_ospfIfTable.getEntries();
        Assert.assertEquals((long)0L, (long)ospfifTableCollection.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.5", port=161, resource="classpath:linkd/nms10205b/Mumbai_10.205.56.5.txt")})
    public void testMumbayOspfNbrTableCollection() throws Exception {
        Nms10205bNetworkBuilder builder = new Nms10205bNetworkBuilder();
        builder.getMumbai();
        String name = "ospfNbrTable";
        OspfNbrTable m_ospfNbrTable = new OspfNbrTable(InetAddressUtils.addr((String)"10.205.56.5"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_ospfNbrTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.205.56.5"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Collection ospfNbrTableCollection = m_ospfNbrTable.getEntries();
        Assert.assertEquals((long)4L, (long)ospfNbrTableCollection.size());
        for (OspfNbrTableEntry entry : ospfNbrTableCollection) {
            Assert.assertEquals((long)0L, (long)entry.getOspfNbrAddressLessIndex().intValue());
            Assert.assertEquals((Object)OspfNbrTableEntry.OSPF_NBR_STATE_FULL, (Object)entry.getOspfNbrState());
            this.checkrow(entry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.23", port=161, resource="classpath:linkd/nms10205b/SRX-100_10.205.56.23.txt")})
    public void testSrx100OspfNbrTableCollection() throws Exception {
        String name = "ospfNbrTable";
        OspfNbrTable m_ospfNbrTable = new OspfNbrTable(InetAddressUtils.addr((String)"10.205.56.23"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_ospfNbrTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.205.56.23"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Collection ospfNbrTableCollection = m_ospfNbrTable.getEntries();
        Assert.assertEquals((long)0L, (long)ospfNbrTableCollection.size());
    }

    private void checkrow(OspfNbrTableEntry entry) {
        InetAddress ip = entry.getOspfNbrIpAddress();
        if (ip.getHostAddress().equals("192.168.5.10")) {
            Assert.assertEquals((Object)DELHI_OSPF_ID, (Object)entry.getOspfNbrRouterId());
            Assert.assertEquals((Object)true, (Object)DELHI_IP_IF_MAP.containsKey(ip));
        } else if (ip.getHostAddress().equals("192.168.5.14")) {
            Assert.assertEquals((Object)BANGALORE_OSPF_ID, (Object)entry.getOspfNbrRouterId());
            Assert.assertEquals((Object)true, (Object)BANGALORE_IP_IF_MAP.containsKey(ip));
        } else if (ip.getHostAddress().equals("192.168.5.18")) {
            Assert.assertEquals((Object)BAGMANE_OSPF_ID, (Object)entry.getOspfNbrRouterId());
            Assert.assertEquals((Object)true, (Object)BAGMANE_IP_IF_MAP.containsKey(ip));
        } else if (ip.getHostAddress().equals("192.168.5.22")) {
            Assert.assertEquals((Object)MYSORE_OSPF_ID, (Object)entry.getOspfNbrRouterId());
            Assert.assertEquals((Object)true, (Object)MYSORE_IP_IF_MAP.containsKey(ip));
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.42", port=161, resource="classpath:linkd/nms10205b/J6350-42_10.205.56.42.txt")})
    public void testLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.205.56.42"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.205.56.42"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"2c6bf55dc100", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"J6350-2", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.42", port=161, resource="classpath:linkd/nms10205b/J6350-42_10.205.56.42.txt")})
    public void testLldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"10.205.56.42"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.205.56.42"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)0L, (long)lldpTableEntryCollection.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.205.56.42", port=161, resource="classpath:linkd/nms10205b/J6350-42_10.205.56.42.txt")})
    public void testLldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"10.205.56.42"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.205.56.42"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)4L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry entry : lldpTableEntryCollection) {
            Assert.assertEquals((long)7L, (long)entry.getLldpLocPortIdSubtype().intValue());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.0.1", port=161, resource="classpath:linkd/nms102/mikrotik-192.168.0.1-walk.txt")})
    public void testMtxrWlRtabTableCollection() throws Exception {
        String name = "mtxrWlRtabTable";
        MtxrWlRtabTable m_mtxrWlRtabTable = new MtxrWlRtabTable(InetAddressUtils.addr((String)"192.168.0.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_mtxrWlRtabTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.0.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Collection m_m_mtxrWlRtabTableEntryCollection = m_mtxrWlRtabTable.getEntries();
        Assert.assertEquals((long)4L, (long)m_m_mtxrWlRtabTableEntryCollection.size());
        int i = 0;
        for (MtxrWlRtabTableEntry entry : m_m_mtxrWlRtabTableEntryCollection) {
            Assert.assertEquals((long)2L, (long)entry.getMtxrWlRtabIface().intValue());
            switch (i) {
                case 0: {
                    Assert.assertEquals((Object)"0015999f07ef", (Object)entry.getMtxrWlRtabAddr());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"001b63cda9fd", (Object)entry.getMtxrWlRtabAddr());
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"60334b0817a8", (Object)entry.getMtxrWlRtabAddr());
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)"f0728c99994d", (Object)entry.getMtxrWlRtabAddr());
                    break;
                }
                default: {
                    Assert.assertEquals((Object)true, (Object)false);
                }
            }
            ++i;
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt")})
    public void testPenroseLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.16"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.16"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"80711f8fafc0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"penrose-mx480", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt")})
    public void testDelawareLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.17"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.17"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"0022830957c0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"delaware", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.42", port=161, resource="classpath:linkd/nms1055/phoenix-mx80_10.155.69.42.txt")})
    public void testPhoenixLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.42"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.42"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"80711fc414c0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"phoenix-mx80", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.43", port=161, resource="classpath:linkd/nms1055/Austin_10.155.69.43.txt")})
    public void testAustinLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.43"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.43"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"80711fc413c0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Austin", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.12", port=161, resource="classpath:linkd/nms1055/sanjose-mx240_10.155.69.12.txt")})
    public void testSanjoseLlldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.12"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.12"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"002283d857c0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"sanjose-mx240", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.107", port=161, resource="classpath:linkd/nms1055/Riovista-ce_10.155.69.107.txt")})
    public void testRiovistaLldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"10.155.69.107"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.107"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"001f12373dc0", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Riovista-ce", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.16", port=161, resource="classpath:linkd/nms1055/penrose-mx480_10.155.69.16.txt")})
    public void testPenroseDot1dBaseCollection() throws Exception {
        String name = "dot1dbase";
        Dot1dBaseGroup m_lLldpLocalGroup = new Dot1dBaseGroup(InetAddressUtils.addr((String)"10.155.69.16"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.16"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Assert.assertEquals((Object)"80711f8fafd0", (Object)m_lLldpLocalGroup.getBridgeAddress());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt")})
    public void testDelawareLldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpRemTable = new LldpLocTable(InetAddressUtils.addr((String)"10.155.69.17"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.17"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)5L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkRowNms1055(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.155.69.17", port=161, resource="classpath:linkd/nms1055/delaware_10.155.69.17.txt")})
    public void testDelawareLldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"10.155.69.17"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.155.69.17"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)4L, (long)lldpTableEntryCollection.size());
        for (LldpRemTableEntry lldpRemTableEntry : lldpTableEntryCollection) {
            this.checkRowNms1055(lldpRemTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt")})
    public void testSwitch2CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.10.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)6L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testSwitch3CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.10.3"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.3"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt")})
    public void testSwitch4CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.50.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt")})
    public void testSwitch5CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.10.4"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.4"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.100.245", port=161, resource="classpath:linkd/nms17216/router1-walk.txt")})
    public void testRouter1CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"192.168.100.245"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.100.245"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.100.241", port=161, resource="classpath:linkd/nms17216/router2-walk.txt")})
    public void testRouter2CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"192.168.100.241"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.100.241"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.1", port=161, resource="classpath:linkd/nms17216/router3-walk.txt")})
    public void testRouter3CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"172.16.50.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.10.10.1", port=161, resource="classpath:linkd/nms17216/router4-walk.txt")})
    public void testRouter4CdpCacheTableCollection() throws Exception {
        String name = "cdpCacheTable";
        CdpCacheTable m_cdpCacheTable = new CdpCacheTable(InetAddressUtils.addr((String)"10.10.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpCacheTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"10.10.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)m_cdpCacheTable.size());
        for (CdpCacheTableEntry cdpCacheTableEntry : m_cdpCacheTable) {
            this.printCdpRow(cdpCacheTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwicth1CiscoVlanTableCollection() throws Exception {
        String name = "vlanTable";
        CiscoVlanTable m_vlan = new CiscoVlanTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_vlan};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (SnmpStore store : m_vlan) {
            CiscoVlanTableEntry ent = (CiscoVlanTableEntry)store;
            System.out.println("VLAN-----Start");
            System.out.println("vlan index: " + ent.getVlanIndex());
            System.out.println("vlan name: " + ent.getVlanName());
            System.out.println("vlan type: " + ent.getVlanType());
            System.out.println("vlan status: " + ent.getVlanStatus());
            System.out.println("VLAN-----End");
        }
        Assert.assertEquals((long)10L, (long)m_vlan.size());
        Assert.assertEquals((long)6L, (long)m_vlan.getVlansForSnmpCollection().size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1CdpInterfaceTableCollection() throws Exception {
        String name = "cdpInterfaceTable";
        CdpInterfaceTable m_cdpinterface = new CdpInterfaceTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_cdpinterface};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (SnmpStore store : m_cdpinterface) {
            CdpInterfaceTableEntry ent = (CdpInterfaceTableEntry)store;
            System.out.println("-----Cdp Interface----");
            System.out.println("cdpInterfaceIfIndex: " + ent.getCdpInterfaceIfIndex());
            System.out.println("cdpInterfaceIfName: " + ent.getCdpInterfaceName());
            System.out.println("");
        }
        Assert.assertEquals((long)28L, (long)m_cdpinterface.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"0016c8bd4d80", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch1", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt")})
    public void testSwitch2LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.10.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"0016c894aa80", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch2", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testSwitch3LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.10.3"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.3"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"f4ea67ebdc00", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch3", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt")})
    public void testSwitch4LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.50.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"a4187504e400", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch4", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt")})
    public void testSwitch5LldpLocalBaseCollection() throws Exception {
        String name = "lldpLocGroup";
        LldpLocalGroup m_lLldpLocalGroup = new LldpLocalGroup(InetAddressUtils.addr((String)"172.16.10.4"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lLldpLocalGroup};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.4"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)m_lLldpLocalGroup.getLldpLocChassisidSubType().intValue());
        Assert.assertEquals((Object)"f4ea67f82980", (Object)m_lLldpLocalGroup.getLldpLocChassisid());
        Assert.assertEquals((Object)"Switch5", (Object)m_lLldpLocalGroup.getLldpLocSysname());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)4L, (long)lldpTableEntryCollection.size());
        for (LldpRemTableEntry lldpRemTableEntry : lldpTableEntryCollection) {
            this.checkSwitch1Row(lldpRemTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt")})
    public void testSwitch2LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.10.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)6L, (long)lldpTableEntryCollection.size());
        for (LldpRemTableEntry lldpRemTableEntry : lldpTableEntryCollection) {
            this.checkSwitch2Row(lldpRemTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testSwitch3LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.10.3"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.3"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)2L, (long)lldpTableEntryCollection.size());
        for (LldpRemTableEntry lldpRemTableEntry : lldpTableEntryCollection) {
            this.checkSwitch3Row(lldpRemTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt")})
    public void testSwitch4LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.50.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)0L, (long)lldpTableEntryCollection.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt")})
    public void testSwitch5LldpRemTableCollection() throws Exception {
        String name = "lldpRemTable";
        LldpRemTable m_lldpRemTable = new LldpRemTable(InetAddressUtils.addr((String)"172.16.10.4"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpRemTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.4"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpRemTable.getEntries();
        Assert.assertEquals((long)0L, (long)lldpTableEntryCollection.size());
    }

    private void checkSwitch1Row(LldpRemTableEntry lldpRemTableEntry) {
        Integer lldpRemLocalPortNum = lldpRemTableEntry.getLldpRemLocalPortNum();
        String lldpRemSysname = lldpRemTableEntry.getLldpRemSysname();
        String lldpRemChassiid = lldpRemTableEntry.getLldpRemChassiid();
        Integer lldpRemChassisidSubtype = lldpRemTableEntry.getLldpRemChassisidSubtype();
        String lldpRemPortid = lldpRemTableEntry.getLldpRemPortid();
        Integer lldpRemPortidSubtype = lldpRemTableEntry.getLldpRemPortidSubtype();
        this.printLldpRemRow(lldpRemLocalPortNum, lldpRemSysname, lldpRemChassiid, lldpRemChassisidSubtype, lldpRemPortid, lldpRemPortidSubtype);
        Assert.assertEquals((long)4L, (long)lldpRemChassisidSubtype.intValue());
        Assert.assertEquals((long)5L, (long)lldpRemPortidSubtype.intValue());
        if (lldpRemLocalPortNum == 9) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/1", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 10) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/2", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 11) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/3", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 12) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/4", (Object)lldpRemPortid);
        } else {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    private void checkSwitch2Row(LldpRemTableEntry lldpRemTableEntry) {
        Integer lldpRemLocalPortNum = lldpRemTableEntry.getLldpRemLocalPortNum();
        String lldpRemSysname = lldpRemTableEntry.getLldpRemSysname();
        String lldpRemChassiid = lldpRemTableEntry.getLldpRemChassiid();
        Integer lldpRemChassisidSubtype = lldpRemTableEntry.getLldpRemChassisidSubtype();
        String lldpRemPortid = lldpRemTableEntry.getLldpRemPortid();
        Integer lldpRemPortidSubtype = lldpRemTableEntry.getLldpRemPortidSubtype();
        this.printLldpRemRow(lldpRemLocalPortNum, lldpRemSysname, lldpRemChassiid, lldpRemChassisidSubtype, lldpRemPortid, lldpRemPortidSubtype);
        Assert.assertEquals((long)4L, (long)lldpRemChassisidSubtype.intValue());
        Assert.assertEquals((long)5L, (long)lldpRemPortidSubtype.intValue());
        if (lldpRemLocalPortNum == 1) {
            Assert.assertEquals((Object)"Switch1", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c8bd4d80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/9", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 2) {
            Assert.assertEquals((Object)"Switch1", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c8bd4d80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/10", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 3) {
            Assert.assertEquals((Object)"Switch1", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c8bd4d80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/11", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 4) {
            Assert.assertEquals((Object)"Switch1", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c8bd4d80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/12", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 19) {
            Assert.assertEquals((Object)"Switch3", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"f4ea67ebdc00", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Fa0/19", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 20) {
            Assert.assertEquals((Object)"Switch3", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"f4ea67ebdc00", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Fa0/20", (Object)lldpRemPortid);
        } else {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    private void checkSwitch3Row(LldpRemTableEntry lldpRemTableEntry) {
        Integer lldpRemLocalPortNum = lldpRemTableEntry.getLldpRemLocalPortNum();
        String lldpRemSysname = lldpRemTableEntry.getLldpRemSysname();
        String lldpRemChassiid = lldpRemTableEntry.getLldpRemChassiid();
        Integer lldpRemChassisidSubtype = lldpRemTableEntry.getLldpRemChassisidSubtype();
        String lldpRemPortid = lldpRemTableEntry.getLldpRemPortid();
        Integer lldpRemPortidSubtype = lldpRemTableEntry.getLldpRemPortidSubtype();
        this.printLldpRemRow(lldpRemLocalPortNum, lldpRemSysname, lldpRemChassiid, lldpRemChassisidSubtype, lldpRemPortid, lldpRemPortidSubtype);
        Assert.assertEquals((long)4L, (long)lldpRemChassisidSubtype.intValue());
        Assert.assertEquals((long)5L, (long)lldpRemPortidSubtype.intValue());
        if (lldpRemLocalPortNum == 19) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/19", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 20) {
            Assert.assertEquals((Object)"Switch2", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"0016c894aa80", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"Gi0/20", (Object)lldpRemPortid);
        } else {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt")})
    public void testSwitch1LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.10.1"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.1"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)30L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch1Row(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt")})
    public void testSwitch2LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.10.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)27L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch2Row(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt")})
    public void testSwitch3LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.10.3"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.3"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)28L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch3Row(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt")})
    public void testSwitch4LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.50.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.50.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)27L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch4Row(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt")})
    public void testSwitch5LldpLocTableCollection() throws Exception {
        String name = "lldpLocTable";
        LldpLocTable m_lldpLocTable = new LldpLocTable(InetAddressUtils.addr((String)"172.16.10.4"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{m_lldpLocTable};
        SnmpAgentConfig snmpAgent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"172.16.10.4"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)snmpAgent, (String)name, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
        }
        Collection lldpTableEntryCollection = m_lldpLocTable.getEntries();
        Assert.assertEquals((long)27L, (long)lldpTableEntryCollection.size());
        for (LldpLocTableEntry lldpLocTableEntry : lldpTableEntryCollection) {
            this.checkSwitch5Row(lldpLocTableEntry);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4930/dlink_DES-3026.properties")})
    public void testDot1qTpFdbTableWalk() throws Exception {
        String trackerName = "dot1qTpFdbTable";
        QBridgeDot1dTpFdbTable dot1qTpFdbTable = new QBridgeDot1dTpFdbTable(InetAddressUtils.addr((String)"10.1.1.2"));
        CollectionTracker[] tracker = new CollectionTracker[]{};
        tracker = new CollectionTracker[]{dot1qTpFdbTable};
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName("10.1.1.2"));
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)config, (String)trackerName, (CollectionTracker[])tracker);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                Assert.assertEquals((Object)false, (Object)true);
            } else if (walker.failed()) {
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)false, (Object)true);
            return;
        }
        Collection entries = dot1qTpFdbTable.getEntries();
        Assert.assertEquals((long)61L, (long)entries.size());
        for (QBridgeDot1dTpFdbTableEntry link : entries) {
            System.out.println(link.getQBridgeDot1dTpFdbAddress());
            System.out.println(link.getQBridgeDot1dTpFdbPort());
            System.out.println(link.getQBridgeDot1dTpFdbStatus());
        }
    }

    private void checkSwitch1Row(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)5L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum >= 1 && lldpLocPortNum <= 28) {
            Assert.assertEquals((Object)("Gi0/" + lldpLocPortNum), (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 64) {
            Assert.assertEquals((Object)"Po1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 448) {
            Assert.assertEquals((Object)"St1", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    private void checkSwitch2Row(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)5L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum >= 1 && lldpLocPortNum <= 24) {
            Assert.assertEquals((Object)("Gi0/" + lldpLocPortNum), (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 64) {
            Assert.assertEquals((Object)"Po1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 72) {
            Assert.assertEquals((Object)"Po2", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 112) {
            Assert.assertEquals((Object)"St1", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    private void checkSwitch3Row(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)5L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum >= 1 && lldpLocPortNum <= 24) {
            Assert.assertEquals((Object)("Fa0/" + lldpLocPortNum), (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 25) {
            Assert.assertEquals((Object)"Gi0/1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 26) {
            Assert.assertEquals((Object)"Gi0/2", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 56) {
            Assert.assertEquals((Object)"Po1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 104) {
            Assert.assertEquals((Object)"St1", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    private void checkSwitch4Row(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)5L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum >= 1 && lldpLocPortNum <= 24) {
            Assert.assertEquals((Object)("Fa0/" + lldpLocPortNum), (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 25) {
            Assert.assertEquals((Object)"Gi0/1", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 26) {
            Assert.assertEquals((Object)"Gi0/2", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 104) {
            Assert.assertEquals((Object)"St1", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    private void checkSwitch5Row(LldpLocTableEntry lldpLocTableEntry) {
        this.checkSwitch4Row(lldpLocTableEntry);
    }

    private void checkRowNms1055(LldpRemTableEntry lldpRemTableEntry) {
        Integer lldpRemLocalPortNum = lldpRemTableEntry.getLldpRemLocalPortNum();
        String lldpRemSysname = lldpRemTableEntry.getLldpRemSysname();
        String lldpRemChassiid = lldpRemTableEntry.getLldpRemChassiid();
        Integer lldpRemChassisidSubtype = lldpRemTableEntry.getLldpRemChassisidSubtype();
        String lldpRemPortid = lldpRemTableEntry.getLldpRemPortid();
        Integer lldpRemPortidSubtype = lldpRemTableEntry.getLldpRemPortidSubtype();
        this.printLldpRemRow(lldpRemLocalPortNum, lldpRemSysname, lldpRemChassiid, lldpRemChassisidSubtype, lldpRemPortid, lldpRemPortidSubtype);
        Assert.assertEquals((long)4L, (long)lldpRemChassisidSubtype.intValue());
        Assert.assertEquals((long)7L, (long)lldpRemPortidSubtype.intValue());
        if (lldpRemLocalPortNum == 574) {
            Assert.assertEquals((Object)"penrose-mx480", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"80711f8fafc0", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"510", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 522) {
            Assert.assertEquals((Object)"penrose-mx480", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"80711f8fafc0", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"525", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 575) {
            Assert.assertEquals((Object)"Austin", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"80711fc413c0", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"509", (Object)lldpRemPortid);
        } else if (lldpRemLocalPortNum == 540) {
            Assert.assertEquals((Object)"Riovista-ce", (Object)lldpRemSysname);
            Assert.assertEquals((Object)"001f12373dc0", (Object)lldpRemChassiid);
            Assert.assertEquals((Object)"503", (Object)lldpRemPortid);
        } else {
            Assert.assertEquals((Object)false, (Object)true);
        }
    }

    private void checkRowNms1055(LldpLocTableEntry lldpLocTableEntry) {
        Integer lldpLocPortNum = lldpLocTableEntry.getLldpLocPortNum();
        String lldpLocPortid = lldpLocTableEntry.getLldpLocPortid();
        Integer lldpLocPortidSubtype = lldpLocTableEntry.getLldpLocPortIdSubtype();
        this.printLldpLocRow(lldpLocPortNum, lldpLocPortidSubtype, lldpLocPortid);
        Assert.assertEquals((long)7L, (long)lldpLocPortidSubtype.intValue());
        if (lldpLocPortNum == 521) {
            Assert.assertEquals((Object)"521", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 522) {
            Assert.assertEquals((Object)"522", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 574) {
            Assert.assertEquals((Object)"574", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 575) {
            Assert.assertEquals((Object)"575", (Object)lldpLocPortid);
        } else if (lldpLocPortNum == 540) {
            Assert.assertEquals((Object)"540", (Object)lldpLocPortid);
        } else {
            Assert.assertEquals((Object)true, (Object)false);
        }
    }

    protected void printCdpRow(CdpCacheTableEntry cdpCacheTableEntry) {
        System.err.println("-----------------------------------------------------------");
        System.err.println("getCdpCacheIfIndex: " + cdpCacheTableEntry.getCdpCacheIfIndex());
        System.err.println("getCdpCacheDeviceIndex: " + cdpCacheTableEntry.getCdpCacheDeviceIndex());
        System.err.println("getCdpCacheAddressType: " + cdpCacheTableEntry.getCdpCacheAddressType());
        System.err.println("getCdpCacheAddress: " + cdpCacheTableEntry.getCdpCacheAddress());
        if (cdpCacheTableEntry.getCdpCacheIpv4Address() != null) {
            System.err.println("getCdpCacheIpv4Address: " + cdpCacheTableEntry.getCdpCacheIpv4Address().getHostName());
        }
        System.err.println("getCdpCacheVersion: " + cdpCacheTableEntry.getCdpCacheVersion());
        System.err.println("getCdpCacheDeviceId: " + cdpCacheTableEntry.getCdpCacheDeviceId());
        System.err.println("getCdpCacheDevicePort: " + cdpCacheTableEntry.getCdpCacheDevicePort());
        System.err.println("-----------------------------------------------------------");
        System.err.println("");
    }

    protected void printLldpRemRow(Integer lldpRemLocalPortNum, String lldpRemSysname, String lldpRemChassiid, Integer lldpRemChassisidSubtype, String lldpRemPortid, Integer lldpRemPortidSubtype) {
        System.err.println("-----------------------------------------------------------");
        System.err.println("getLldpRemLocalPortNum: " + lldpRemLocalPortNum);
        System.err.println("getLldpRemSysname: " + lldpRemSysname);
        System.err.println("getLldpRemChassiid: " + lldpRemChassiid);
        System.err.println("getLldpRemChassisidSubtype: " + lldpRemChassisidSubtype);
        System.err.println("getLldpRemPortid: " + lldpRemPortid);
        System.err.println("getLldpRemPortidSubtype: " + lldpRemPortidSubtype);
        System.err.println("-----------------------------------------------------------");
        System.err.println("");
    }

    protected void printLldpLocRow(Integer lldpLocPortNum, Integer lldpLocPortidSubtype, String lldpLocPortid) {
        System.err.println("-----------------------------------------------------------");
        System.err.println("getLldpLocPortNum: " + lldpLocPortNum);
        System.err.println("getLldpLocPortid: " + lldpLocPortid);
        System.err.println("getLldpRemPortidSubtype: " + lldpLocPortidSubtype);
        System.err.println("-----------------------------------------------------------");
        System.err.println("");
    }
}

