/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.processor;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.eventd.EventExpander;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class EventExpanderTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private EventConfDao m_eventConfDao = (EventConfDao)this.m_mocks.createMock(EventConfDao.class);

    protected void runTest() throws Throwable {
        super.runTest();
        this.m_mocks.verifyAll();
    }

    public void testAfterPropertiesSetWithNoEventConfDao() {
        this.m_mocks.replayAll();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property eventConfDao must be set"));
        EventExpander expander = new EventExpander();
        try {
            expander.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSet() {
        this.m_mocks.replayAll();
        EventExpander expander = new EventExpander();
        expander.setEventConfDao(this.m_eventConfDao);
        expander.afterPropertiesSet();
    }

    public void testExpandEventWithNoDaoMatches() {
        String uei = "uei.opennms.org/internal/capsd/snmpConflictsWithDb";
        EventBuilder builder = new EventBuilder(uei, "something");
        EventExpander expander = new EventExpander();
        expander.setEventConfDao(this.m_eventConfDao);
        expander.afterPropertiesSet();
        Event event = builder.getEvent();
        EventExpanderTest.assertNull((String)"event description should be null before expandEvent is called", (Object)event.getDescr());
        EasyMock.expect((Object)this.m_eventConfDao.findByEvent(event)).andReturn(null);
        EasyMock.expect((Object)this.m_eventConfDao.findByUei("uei.opennms.org/default/event")).andReturn(null);
        this.m_mocks.replayAll();
        expander.expandEvent(event);
        EventExpanderTest.assertEquals((String)"event UEI", (String)uei, (String)event.getUei());
    }
}

