/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.sql.SQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.eventd.EventUtilDaoImpl;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-eventDaemon.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
@Transactional
public class EventUtilHibernateTest {
    @Autowired
    private EventUtilDaoImpl eventUtilDaoImpl;
    @Autowired
    private DatabasePopulator m_populator;
    private static boolean m_populated = false;

    @Before
    public void setUp() throws Exception {
        this.m_populator.populateDatabase();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetNodeLabel() throws SQLException {
        String label = this.eventUtilDaoImpl.getNodeLabel((long)this.m_populator.getNode3().getId().intValue());
        Assert.assertEquals((Object)"node3", (Object)label);
        label = this.eventUtilDaoImpl.getNodeLabel((long)this.m_populator.getNode1().getId().intValue());
        Assert.assertEquals((Object)"node1", (Object)label);
        label = this.eventUtilDaoImpl.getNodeLabel((long)this.m_populator.getNode2().getId().intValue());
        Assert.assertEquals((Object)"node2", (Object)label);
    }

    @Test
    public void testGetIfAlias() throws SQLException {
        String alias = this.eventUtilDaoImpl.getIfAlias((long)this.m_populator.getNode1().getId().intValue(), "192.168.1.1");
        Assert.assertEquals((Object)"Initial ifAlias value", (Object)alias);
    }

    @Test
    public void testGetAssetFieldValue() throws SQLException {
        String asset = this.eventUtilDaoImpl.getAssetFieldValue("parm", (long)this.m_populator.getNode3().getId().intValue());
        Assert.assertEquals((Object)"node3", (Object)asset);
        asset = this.eventUtilDaoImpl.getAssetFieldValue("parm", (long)this.m_populator.getNode1().getId().intValue());
        Assert.assertEquals((Object)"node1", (Object)asset);
        asset = this.eventUtilDaoImpl.getAssetFieldValue("parm", (long)this.m_populator.getNode2().getId().intValue());
        Assert.assertEquals((Object)"node2", (Object)asset);
    }
}

