/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.EnLinkdTestBuilder;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.nb.Nms7563NetworkBuilder;
import org.opennms.netmgt.nb.NmsNetworkBuilder;

public class Nms7563EnTest
extends EnLinkdTestBuilder {
    Nms7563NetworkBuilder builder = new Nms7563NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.88.240", port=161, resource="classpath:linkd/nms7563/cisco01-walk.txt")})
    public void testCisco01Links() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getCisco01());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(false);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertTrue((boolean)this.m_linkdConfig.useCdpDiscovery());
        OnmsNode cisco01 = this.m_nodeDao.findByForeignId("linkd", "cisco01");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco01.getId().intValue()));
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getLldpElement());
            Nms7563EnTest.printLldpElement(node.getLldpElement());
            Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_MACADDRESS, (Object)node.getLldpElement().getLldpChassisIdSubType());
            Assert.assertEquals((Object)"aca016bf0200", (Object)node.getLldpElement().getLldpChassisId());
            Assert.assertEquals((Object)"cisco01", (Object)node.getLldpElement().getLldpSysname());
            Assert.assertNotNull((Object)node.getCdpElement());
            Nms7563EnTest.printCdpElement(node.getCdpElement());
            Assert.assertEquals((Object)OspfElement.TruthValue.TRUE, (Object)node.getCdpElement().getCdpGlobalRun());
            Assert.assertEquals((Object)"cisco01", (Object)node.getCdpElement().getCdpGlobalDeviceId());
        }
        Assert.assertEquals((long)1L, (long)this.m_lldpLinkDao.countAll());
        for (LldpLink link : this.m_lldpLinkDao.findAll()) {
            Assert.assertNotNull((Object)link);
            Nms7563EnTest.printLldpLink(link);
            Assert.assertEquals((long)8L, (long)link.getLldpLocalPortNum().intValue());
            Assert.assertNull((Object)link.getLldpPortIfindex());
            Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME, (Object)link.getLldpPortIdSubType());
            Assert.assertEquals((Object)"Fa0/8", (Object)link.getLldpPortId());
            Assert.assertEquals((Object)"FastEthernet0/8", (Object)link.getLldpPortDescr());
            Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_MACADDRESS, (Object)link.getLldpRemChassisIdSubType());
            Assert.assertEquals((Object)"001db3c50960", (Object)link.getLldpRemChassisId());
            Assert.assertEquals((Object)"ProCurve Switch 2510B-24", (Object)link.getLldpRemSysname());
            Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL, (Object)link.getLldpRemPortIdSubType());
            Assert.assertEquals((Object)"24", (Object)link.getLldpRemPortId());
            Assert.assertEquals((Object)"24", (Object)link.getLldpRemPortDescr());
        }
        Assert.assertEquals((long)0L, (long)this.m_cdpLinkDao.countAll());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.88.1", port=161, resource="classpath:linkd/nms7563/homeserver-walk.txt")})
    public void testHomeServerLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getHomeServer());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(false);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        OnmsNode homeserver = this.m_nodeDao.findByForeignId("linkd", "homeserver");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(homeserver.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(homeserver.getId().intValue()));
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getLldpElement());
            Nms7563EnTest.printLldpElement(node.getLldpElement());
            Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_MACADDRESS, (Object)node.getLldpElement().getLldpChassisIdSubType());
            Assert.assertEquals((Object)"001ff207994f", (Object)node.getLldpElement().getLldpChassisId());
            Assert.assertEquals((Object)"server.home.schwartzkopff.org", (Object)node.getLldpElement().getLldpSysname());
        }
        Assert.assertEquals((long)1L, (long)this.m_lldpLinkDao.countAll());
        for (LldpLink link : this.m_lldpLinkDao.findAll()) {
            Assert.assertNotNull((Object)link);
            Nms7563EnTest.printLldpLink(link);
            Assert.assertEquals((long)2L, (long)link.getLldpLocalPortNum().intValue());
            Assert.assertNull((Object)link.getLldpPortIfindex());
            Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_MACADDRESS, (Object)link.getLldpPortIdSubType());
            Assert.assertEquals((Object)NmsNetworkBuilder.HOMESERVER_IF_MAC_MAP.get(2), (Object)link.getLldpPortId());
            Assert.assertEquals((Object)"eth0", (Object)link.getLldpPortDescr());
            Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_MACADDRESS, (Object)link.getLldpRemChassisIdSubType());
            Assert.assertEquals((Object)"001db3c50960", (Object)link.getLldpRemChassisId());
            Assert.assertEquals((Object)"ProCurve Switch 2510B-24", (Object)link.getLldpRemSysname());
            Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL, (Object)link.getLldpRemPortIdSubType());
            Assert.assertEquals((Object)"7", (Object)link.getLldpRemPortId());
            Assert.assertEquals((Object)"7", (Object)link.getLldpRemPortDescr());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.168.88.241", port=161, resource="classpath:linkd/nms7563/switch02-walk.txt")})
    public void testSwitch02Links() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getSwitch02());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(false);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useCdpDiscovery());
        OnmsNode switch02 = this.m_nodeDao.findByForeignId("linkd", "switch02");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch02.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch02.getId().intValue()));
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getCdpElement());
            Nms7563EnTest.printCdpElement(node.getCdpElement());
            Assert.assertEquals((Object)OspfElement.TruthValue.TRUE, (Object)node.getCdpElement().getCdpGlobalRun());
            Assert.assertEquals((Object)"ProCurve Switch 2510B-24(001db3-c50960)", (Object)node.getCdpElement().getCdpGlobalDeviceId());
        }
        Assert.assertEquals((long)3L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_cdpLinkDao.findLinksForTopology().size());
        for (CdpLink link : this.m_cdpLinkDao.findAll()) {
            Nms7563EnTest.printCdpLink(link);
            if (link.getCdpCacheIfIndex() == 7 && link.getCdpCacheDeviceIndex() == 1) {
                Assert.assertNull((Object)link.getCdpInterfaceName());
                Assert.assertEquals((Object)CdpLink.CiscoNetworkProtocolType.ip, (Object)link.getCdpCacheAddressType());
                Assert.assertEquals((Object)"192.168.87.16", (Object)link.getCdpCacheAddress());
                Assert.assertEquals((Object)"001ff207994f", (Object)link.getCdpCacheDeviceId());
                Assert.assertEquals((Object)"Debian GNU/Linux 7 (wheezy) Linux 3.2.0-4-amd64 #1 SMP Debian 3.2.65-1+deb7u2 x86_64", (Object)link.getCdpCacheVersion());
                Assert.assertEquals((Object)"Debian GNU/Linux 7 (wheezy) Linux 3.2.0-4-amd64 #1 SMP Debian 3.2.65-1+deb7u2 x86_64", (Object)link.getCdpCacheDevicePlatform());
                Assert.assertEquals((Object)NmsNetworkBuilder.HOMESERVER_IF_MAC_MAP.get(2), (Object)link.getCdpCacheDevicePort());
                continue;
            }
            if (link.getCdpCacheIfIndex() == 24 && link.getCdpCacheDeviceIndex() == 1) {
                Assert.assertNull((Object)link.getCdpInterfaceName());
                Assert.assertEquals((Object)CdpLink.CiscoNetworkProtocolType.ip, (Object)link.getCdpCacheAddressType());
                Assert.assertEquals((Object)"192.168.88.240", (Object)link.getCdpCacheAddress());
                Assert.assertEquals((Object)"cisco01", (Object)link.getCdpCacheDeviceId());
                Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(2)SE4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyrighcisco WS-C2960-8TC-L", (Object)link.getCdpCacheVersion());
                Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(2)SE4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyrighcisco WS-C2960-8TC-L", (Object)link.getCdpCacheDevicePlatform());
                Assert.assertEquals((Object)NmsNetworkBuilder.CISCO01_IF_IFDESCR_MAP.get(10008), (Object)link.getCdpCacheDevicePort());
                continue;
            }
            if (link.getCdpCacheIfIndex() == 24 && link.getCdpCacheDeviceIndex() == 2) {
                Assert.assertNull((Object)link.getCdpInterfaceName());
                Assert.assertEquals((Object)CdpLink.CiscoNetworkProtocolType.ip, (Object)link.getCdpCacheAddressType());
                Assert.assertEquals((Object)"192.168.88.240", (Object)link.getCdpCacheAddress());
                Assert.assertEquals((Object)"aca016bf0200", (Object)link.getCdpCacheDeviceId());
                Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(2)SE4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2013 by Cisco Systems, Inc.  Compiled Wed 26-Jun-13 02:49 by prod_rel_team", (Object)link.getCdpCacheVersion());
                Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 15.0(2)SE4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2013 by Cisco Systems, Inc.  Compiled Wed 26-Jun-13 02:49 by prod_rel_team", (Object)link.getCdpCacheDevicePlatform());
                Assert.assertEquals((Object)NmsNetworkBuilder.CISCO01_IF_IFNAME_MAP.get(10008), (Object)link.getCdpCacheDevicePort());
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
    }
}

