/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdTestBuilder;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms4930NetworkBuilder;

public class Nms4930EnTest
extends EnLinkdTestBuilder {
    Nms4930NetworkBuilder builder = new Nms4930NetworkBuilder();
    String[] macsonbbport = new String[]{"001e58a6aed7", "00265abd0b08", "1caff72905d8", "1caff702cffd", "00e0d8107c0c", "001562cae2cf", "001cf0d18441", "001e58a31b47"};

    @Before
    public void setUpNetwork4930() throws Exception {
        this.builder.setNodeDao(this.m_nodeDao);
        this.builder.setIpNetToMediaDao(this.m_ipNetToMediaDao);
        this.builder.buildNetwork4930();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930Network() throws Exception {
        this.builder.addMacNodeWithSnmpInterface("001e58a6aed7", "10.100.1.7", 101);
        this.builder.addMacNode("000ffeb10e26", "10.100.2.6");
        Assert.assertEquals((long)4L, (long)this.m_nodeDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_ipNetToMediaDao.countAll());
        IpNetToMedia at0 = (IpNetToMedia)this.m_ipNetToMediaDao.findByPhysAddress("001e58a6aed7").get(0);
        Assert.assertNotNull((Object)at0);
        Assert.assertEquals((Object)"10.100.1.7", (Object)at0.getNetAddress().getHostAddress());
        IpNetToMedia at1 = (IpNetToMedia)this.m_ipNetToMediaDao.findByPhysAddress("000ffeb10e26").get(0);
        Assert.assertNotNull((Object)at1);
        Assert.assertEquals((Object)"10.100.2.6", (Object)at1.getNetAddress().getHostAddress());
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        OnmsNode dlink2 = this.m_nodeDao.findByForeignId("linkd", "dlink2");
        OnmsNode nodebetweendlink1dlink2 = this.m_nodeDao.findByForeignId("linkd", "10.100.1.7");
        OnmsNode nodeonlink1dport6 = this.m_nodeDao.findByForeignId("linkd", "10.100.2.6");
        Assert.assertNotNull((Object)nodebetweendlink1dlink2);
        Assert.assertNotNull((Object)nodeonlink1dport6);
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(true);
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(false);
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink2.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)58L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes().size());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes().size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink2.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)659L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes().size());
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes().size());
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            Assert.assertNotNull((Object)link.getNode());
            Assert.assertNotNull((Object)link.getBridgePort());
            Assert.assertNotNull((Object)link.getBridgePortIfIndex());
            Assert.assertNotNull((Object)link.getMacAddress());
        }
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes()) {
            Assert.assertNotNull((Object)link.getSrcNodeId());
            Assert.assertNotNull((Object)link.getBridgePort());
            Assert.assertNotNull((Object)link.getBridgePortIfIndex());
            Assert.assertNotNull((Object)link.getTargetNodeId());
            Assert.assertNotNull((Object)link.getMacAddr());
            Assert.assertNotNull((Object)link.getTargetPortIfName());
            if (link.getSrcNodeId().intValue() == dlink1.getId().intValue()) {
                if (link.getBridgePort() == 6) {
                    Assert.assertEquals((long)link.getBridgePortIfIndex().intValue(), (long)6L);
                    Assert.assertEquals((long)link.getTargetNodeId().intValue(), (long)nodeonlink1dport6.getId().intValue());
                    Assert.assertEquals((Object)link.getMacAddr(), (Object)"000ffeb10e26");
                    Assert.assertEquals((Object)link.getTargetPortIfName(), (Object)"10.100.2.6");
                    Assert.assertEquals((Object)link.getTargetIfIndex(), null);
                    continue;
                }
                if (link.getBridgePort() == 24) {
                    Assert.assertEquals((long)link.getBridgePortIfIndex().intValue(), (long)24L);
                    Assert.assertEquals((long)link.getTargetNodeId().intValue(), (long)nodebetweendlink1dlink2.getId().intValue());
                    Assert.assertEquals((Object)link.getMacAddr(), (Object)"001e58a6aed7");
                    Assert.assertEquals((Object)link.getTargetPortIfName(), (Object)"10.100.1.7");
                    Assert.assertEquals((long)link.getTargetIfIndex().intValue(), (long)101L);
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getSrcNodeId().intValue() == dlink2.getId().intValue()) {
                Assert.assertEquals((long)link.getBridgePortIfIndex().intValue(), (long)10L);
                Assert.assertEquals((long)link.getTargetNodeId().intValue(), (long)nodebetweendlink1dlink2.getId().intValue());
                Assert.assertEquals((Object)link.getMacAddr(), (Object)"001e58a6aed7");
                Assert.assertEquals((Object)link.getTargetPortIfName(), (Object)"10.100.1.7");
                Assert.assertEquals((long)link.getTargetIfIndex().intValue(), (long)101L);
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes()) {
            Assert.assertNotNull((Object)link.getSrcNodeId());
            Assert.assertNotNull((Object)link.getBridgePort());
            Assert.assertNotNull((Object)link.getBridgePortIfIndex());
            Assert.assertNotNull((Object)link.getTargetNodeId());
            Assert.assertNotNull((Object)link.getMacAddr());
            Assert.assertNotNull((Object)link.getTargetBridgePort());
            Assert.assertNotNull((Object)link.getTargetIfIndex());
            Assert.assertNotNull((Object)link.getTargetId());
            Assert.assertEquals((long)dlink1.getId().intValue(), (long)link.getSrcNodeId().intValue());
            Assert.assertEquals((long)dlink2.getId().intValue(), (long)link.getTargetNodeId().intValue());
            Assert.assertEquals((long)24L, (long)link.getBridgePort().intValue());
            Assert.assertEquals((long)10L, (long)link.getTargetBridgePort().intValue());
        }
        for (String mac : this.macsonbbport) {
            List maclinks = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)2L, (long)maclinks.size());
            Nms4930EnTest.printBackboneBridgeMacLink((BridgeMacLink)maclinks.get(0), (BridgeMacLink)maclinks.get(1));
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930NetworkReverse() throws Exception {
        Assert.assertEquals((long)2L, (long)this.m_nodeDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_ipNetToMediaDao.countAll());
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        OnmsNode dlink2 = this.m_nodeDao.findByForeignId("linkd", "dlink2");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(true);
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(false);
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink2.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)977L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes().size());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes().size());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)659L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes().size());
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes().size());
        for (String mac : this.macsonbbport) {
            List maclinks = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)2L, (long)maclinks.size());
            for (BridgeMacLink maclink : maclinks) {
                Nms4930EnTest.printBridgeMacLink(maclink);
            }
        }
        BridgeMacLink mac1 = this.m_bridgeMacLinkDao.getByNodeIdBridgePortMac(dlink1.getId(), Integer.valueOf(1), "64168dfa8d49");
        Assert.assertNotNull((Object)mac1);
        Assert.assertNotNull((Object)mac1.getBridgePortIfIndex());
        Assert.assertEquals((long)1L, (long)mac1.getBridgePortIfIndex().intValue());
    }
}

