/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnLinkdTestBuilder;
import org.opennms.netmgt.model.topology.LinkableSnmpNode;
import org.opennms.netmgt.nb.Nms10205bNetworkBuilder;
import org.opennms.netmgt.nb.Nms17216NetworkBuilder;

public class EnLinkdTest
extends EnLinkdTestBuilder {
    Nms10205bNetworkBuilder builder10205a = new Nms10205bNetworkBuilder();
    Nms17216NetworkBuilder builder = new Nms17216NetworkBuilder();

    @Test
    public void testGetSnmpNodeList() throws Exception {
        this.m_nodeDao.save((Object)this.builder10205a.getMumbai());
        this.m_nodeDao.save((Object)this.builder10205a.getDelhi());
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.flush();
        int mumbai = this.m_nodeDao.findByForeignId("linkd", "Mumbai").getId();
        int delhi = this.m_nodeDao.findByForeignId("linkd", "Delhi").getId();
        int switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1").getId();
        List linkablenodes = this.m_linkd.getQueryManager().getSnmpNodeList();
        Assert.assertNotNull((Object)linkablenodes);
        Assert.assertEquals((long)3L, (long)linkablenodes.size());
        for (LinkableSnmpNode linkablenode : linkablenodes) {
            if (linkablenode.getNodeId() == mumbai) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.5"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.9", (Object)linkablenode.getSysoid());
                continue;
            }
            if (linkablenode.getNodeId() == delhi) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.7"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.29", (Object)linkablenode.getSysoid());
                continue;
            }
            if (linkablenode.getNodeId() == switch1) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"172.16.10.1"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.9.1.614", (Object)linkablenode.getSysoid());
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        LinkableSnmpNode delhilinkablenode = this.m_linkd.getQueryManager().getSnmpNode(delhi);
        Assert.assertNotNull((Object)delhilinkablenode);
        Assert.assertEquals((long)delhi, (long)delhilinkablenode.getNodeId());
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.7"), (Object)delhilinkablenode.getSnmpPrimaryIpAddr());
        Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.29", (Object)delhilinkablenode.getSysoid());
    }
}

