/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.opennms.core.test.MockPlatformTransactionManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.AbstractCollectionSetVisitor;
import org.opennms.netmgt.config.DataCollectionConfigDao;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.transaction.PlatformTransactionManager;

public class SnmpCollectorTestCase
extends OpenNMSTestCase {
    public MockDataCollectionConfig m_config;
    protected SnmpObjId m_sysNameOid;
    protected SnmpObjId m_ifDescr;
    protected SnmpObjId m_ifOutOctets;
    protected SnmpObjId m_invalid;
    protected OnmsNode m_node;
    protected OnmsIpInterface m_iface;
    protected SnmpCollectionAgent m_agent;
    private SnmpWalker m_walker;
    protected SnmpCollectionSet m_collectionSet;
    protected MockSnmpAgent m_mockAgent;
    protected IpInterfaceDao m_ifaceDao;
    protected EasyMockUtils m_easyMockUtils;

    @Override
    public void setVersion(int version) {
        super.setVersion(version);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.setStartEventd(false);
        super.setUp();
        this.m_mockAgent = MockSnmpAgent.createAgentAndRun((URL)new ClassPathResource("org/opennms/netmgt/snmp/snmpTestData1.properties").getURL(), (String)(InetAddressUtils.str((InetAddress)this.myLocalHost()) + "/9161"));
        this.m_config = new MockDataCollectionConfig();
        DataCollectionConfigFactory.setInstance((DataCollectionConfigDao)this.m_config);
        this.m_sysNameOid = SnmpObjId.get((String)".1.3.6.1.2.1.1.5");
        this.m_ifOutOctets = SnmpObjId.get((String)"..1.3.6.1.2.1.2.2.1.16");
        this.m_invalid = SnmpObjId.get((String)".1.5.6.1.2.1.1.5");
        this.m_ifDescr = SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.2");
        this.m_easyMockUtils = new EasyMockUtils();
        this.m_ifaceDao = (IpInterfaceDao)this.m_easyMockUtils.createMock(IpInterfaceDao.class);
        this.createAgent(1, PrimaryType.PRIMARY);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.m_mockAgent.shutDownAndWait();
        super.tearDown();
    }

    protected static void assertMibObjectsPresent(CollectionResource resource, List<MibObject> attrList) {
        Assert.assertNotNull((Object)resource);
        AttributeVerifier attributeVerifier = new AttributeVerifier(attrList);
        resource.visit((CollectionSetVisitor)attributeVerifier);
        Assert.assertEquals((String)"Unexpected number of attributes", (long)attrList.size(), (long)attributeVerifier.attributeCount);
    }

    protected static void assertMibObjectPresent(SnmpAttribute attribute, List<MibObject> attrList) {
        for (MibObject mibObj : attrList) {
            if (!mibObj.getOid().equals(((SnmpAttributeType)attribute.getAttributeType()).getOid())) continue;
            return;
        }
        Assert.fail((String)("Unable to find attribue " + attribute + " in attribute list"));
    }

    protected void addIfNumber() {
        this.addAttribute("ifNumber", ".1.3.6.1.2.1.2.1", "0", "integer");
    }

    protected void addSystemGroup() {
        this.addSysDescr();
        this.addSysOid();
        this.addSysName();
        this.addSysLocation();
    }

    protected void addSysLocation() {
        this.addAttribute("sysLocation", ".1.3.6.1.2.1.1.6", "0", "string");
    }

    protected void addSysName() {
        this.addAttribute("sysName", ".1.3.6.1.2.1.1.5", "0", "string");
    }

    protected void addSysContact() {
        this.addAttribute("sysContact", ".1.3.6.1.2.1.1.4", "0", "string");
    }

    protected void addSysUptime() {
        this.addAttribute("sysUptime", ".1.3.6.1.2.1.1.3", "0", "timeTicks");
    }

    protected void addSysOid() {
        this.addAttribute("sysOid", ".1.3.6.1.2.1.1.2", "0", "string");
    }

    protected void addSysDescr() {
        this.addAttribute("sysDescr", ".1.3.6.1.2.1.1.1", "0", "string");
    }

    protected void addAttribute(String alias, String oid, String inst, String type) {
        this.m_config.addAttributeType(alias, oid, inst, type);
    }

    protected void addIfTable() {
        this.addIfSpeed();
        this.addIfInOctets();
        this.addIfOutOctets();
        this.addIfInErrors();
        this.addIfOutErrors();
        this.addIfInDiscards();
    }

    protected void addIpAddrTable() {
        this.addIpAdEntAddr();
        this.addIpAdEntIfIndex();
        this.addIpAdEntNetMask();
        this.addIpAdEntBcastAddr();
    }

    protected void addInvalid() {
        this.addAttribute("invalid", ".1.5.6.1.2.1.4.20.1.4", "ifIndex", "counter");
    }

    protected void addIpAdEntBcastAddr() {
        this.addAttribute("addIpAdEntBcastAddr", ".1.3.6.1.2.1.4.20.1.4", "ifIndex", "ipAddress");
    }

    protected void addIpAdEntNetMask() {
        this.addAttribute("addIpAdEntNetMask", ".1.3.6.1.2.1.4.20.1.3", "ifIndex", "ipAddress");
    }

    protected void addIpAdEntIfIndex() {
        this.addAttribute("addIpAdEntIfIndex", ".1.3.6.1.2.1.4.20.1.2", "ifIndex", "integer");
    }

    protected void addIpAdEntAddr() {
        this.addAttribute("addIpAdEntAddr", ".1.3.6.1.2.1.4.20.1.1", "ifIndex", "ipAddress");
    }

    protected void addIfInDiscards() {
        this.addAttribute("ifInDiscards", ".1.3.6.1.2.1.2.2.1.13", "ifIndex", "counter");
    }

    protected void addIfOutErrors() {
        this.addAttribute("ifOutErrors", ".1.3.6.1.2.1.2.2.1.20", "ifIndex", "counter");
    }

    protected void addIfInErrors() {
        this.addAttribute("ifInErrors", ".1.3.6.1.2.1.2.2.1.14", "ifIndex", "counter");
    }

    protected void addIfOutOctets() {
        this.addAttribute("ifOutOctets", ".1.3.6.1.2.1.2.2.1.16", "ifIndex", "counter");
    }

    protected void addIfInOctets() {
        this.addAttribute("ifInOctets", ".1.3.6.1.2.1.2.2.1.10", "ifIndex", "counter");
    }

    protected void addIfSpeed() {
        this.addAttribute("ifSpeed", ".1.3.6.1.2.1.2.2.1.5", "ifIndex", "gauge");
    }

    @Override
    public void testDoNothing() {
    }

    public List<MibObject> getAttributeList() {
        return this.m_config.getAttrList();
    }

    protected void createAgent(int ifIndex, PrimaryType ifCollType) {
        this.m_node = new OnmsNode();
        this.m_node.setSysObjectId(".1.2.3.4.5.6.7");
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(this.m_node, ifIndex);
        this.m_iface = new OnmsIpInterface();
        this.m_iface.setId(Integer.valueOf(123));
        this.m_iface.setIpAddress(this.myLocalHost());
        this.m_iface.setIsSnmpPrimary(ifCollType);
        this.m_iface.setSnmpInterface(snmpIface);
        this.m_node.addIpInterface(this.m_iface);
        EasyMock.expect((Object)this.m_ifaceDao.load((Serializable)this.m_iface.getId())).andReturn((Object)this.m_iface).anyTimes();
        this.m_easyMockUtils.replayAll();
        this.m_agent = DefaultCollectionAgent.create((Integer)this.m_iface.getId(), (IpInterfaceDao)this.m_ifaceDao, (PlatformTransactionManager)new MockPlatformTransactionManager());
    }

    protected void initializeAgent() throws CollectionInitializationException {
        ServiceParameters params = new ServiceParameters(new HashMap());
        OnmsSnmpCollection snmpCollection = new OnmsSnmpCollection(this.m_agent, params, (DataCollectionConfigDao)this.m_config);
        this.m_collectionSet = snmpCollection.createCollectionSet(this.m_agent);
        this.m_agent.validateAgent();
    }

    protected SnmpCollectionSet getCollectionSet() {
        return this.m_collectionSet;
    }

    protected void createWalker(CollectionTracker collector) {
        this.m_walker = SnmpUtils.createWalker((SnmpAgentConfig)this.m_agent.getAgentConfig(), (String)this.getClass().getSimpleName(), (CollectionTracker)collector);
        this.m_walker.start();
    }

    protected void waitForSignal() throws InterruptedException {
        this.m_walker.waitFor();
    }

    private static final class AttributeVerifier
    extends AbstractCollectionSetVisitor {
        private final List<MibObject> list;
        public int attributeCount = 0;

        private AttributeVerifier(List<MibObject> list) {
            this.list = list;
        }

        public void visitAttribute(CollectionAttribute attribute) {
            this.visitAttribute((SnmpAttribute)attribute);
        }

        public void visitAttribute(SnmpAttribute attribute) {
            ++this.attributeCount;
            SnmpCollectorTestCase.assertMibObjectPresent(attribute, this.list);
        }
    }
}

