/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.TestContextAware;
import org.opennms.core.test.TestContextAwareExecutionListener;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.snmp.ProxySnmpAgentConfigFactory;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.CollectorTestUtils;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.JUnitCollector;
import org.opennms.netmgt.collectd.JUnitCollectorExecutionListener;
import org.opennms.netmgt.collectd.SnmpCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@TestExecutionListeners(value={TestContextAwareExecutionListener.class, JUnitCollectorExecutionListener.class})
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.rrd.storeByGroup=false"})
@JUnitTemporaryDatabase
@Transactional
public class SnmpCollectorMinMaxValTest
implements TestContextAware,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpCollectorMinMaxValTest.class);
    private static final String TEST_HOST_ADDRESS = "192.0.2.205";
    private static final String TEST_NODE_LABEL = "TestNode";
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;
    private TestContext m_context;
    private CollectionSpecification m_collectionSpecification;
    private CollectionAgent m_collectionAgent;
    private SnmpAgentConfig m_agentConfig;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.opennms.netmgt.snmp.SnmpUtils", "DEBUG");
        MockLogAppender.setupLogging((Properties)p);
        Assert.assertTrue((boolean)(this.m_snmpPeerFactory instanceof ProxySnmpAgentConfigFactory));
        SnmpPeerFactory.setInstance((SnmpPeerFactory)this.m_snmpPeerFactory);
        this.m_agentConfig = this.m_snmpPeerFactory.getAgentConfig(InetAddressUtils.addr((String)TEST_HOST_ADDRESS));
        RrdUtils.setStrategy((RrdStrategy)RrdUtils.getSpecificStrategy((RrdUtils.StrategyName)RrdUtils.StrategyName.basicRrdStrategy));
        OnmsIpInterface iface = null;
        OnmsNode testNode = null;
        List testNodes = this.m_nodeDao.findByLabel(TEST_NODE_LABEL);
        if (testNodes == null || testNodes.size() < 1) {
            NetworkBuilder builder = new NetworkBuilder();
            builder.addNode(TEST_NODE_LABEL).setId(Integer.valueOf(1)).setSysObjectId(".1.3.6.1.4.1.1588.2.1.1.1");
            builder.addSnmpInterface(1).setIfName("lo0").setPhysAddr("00:11:22:33:44");
            builder.addSnmpInterface(2).setIfName("gif0").setPhysAddr("00:11:22:33:45").setIfType(Integer.valueOf(55));
            builder.addSnmpInterface(3).setIfName("stf0").setPhysAddr("00:11:22:33:46").setIfType(Integer.valueOf(57));
            NetworkBuilder.InterfaceBuilder ifBldr = builder.addInterface(TEST_HOST_ADDRESS).setIsSnmpPrimary("P");
            ifBldr.addSnmpInterface(6).setIfName("fw0").setPhysAddr("44:33:22:11:00").setIfType(Integer.valueOf(144)).setCollectionEnabled(true);
            testNode = builder.getCurrentNode();
            Assert.assertNotNull((Object)testNode);
            this.m_nodeDao.save((Object)testNode);
            this.m_nodeDao.flush();
        } else {
            testNode = (OnmsNode)testNodes.iterator().next();
        }
        Set ifaces = testNode.getIpInterfaces();
        Assert.assertEquals((long)1L, (long)ifaces.size());
        iface = (OnmsIpInterface)ifaces.iterator().next();
        LOG.debug("iface = {}", (Object)iface);
        SnmpCollector collector = new SnmpCollector();
        collector.initialize(null);
        this.m_collectionSpecification = CollectorTestUtils.createCollectionSpec("SNMP", (ServiceCollector)collector, "default");
        this.m_collectionAgent = DefaultCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)this.m_ipInterfaceDao, (PlatformTransactionManager)this.m_transactionManager);
    }

    @After
    public void tearDown() throws Exception {
        MockUtil.println((String)"------------ End Test --------------------------");
    }

    @Test
    @JUnitCollector(datacollectionConfig="/org/opennms/netmgt/config/datacollection-minmax-persistTest-config.xml", datacollectionType="snmp", anticipateFiles={"1", "1/fw0"}, anticipateRrds={"1/tcpCurrEstab", "1/fw0/ifInOctets"})
    @JUnitSnmpAgent(host="192.0.2.205", resource="/org/opennms/netmgt/snmp/snmpTestData1.properties")
    public void testPersist() throws Exception {
        File snmpRrdDirectory = (File)this.m_context.getAttribute("rrdDirectory");
        File nodeDir = new File(snmpRrdDirectory, "1");
        File rrdFile = new File(nodeDir, SnmpCollectorMinMaxValTest.rrd("tcpCurrEstab"));
        File ifDir = new File(nodeDir, "fw0");
        File ifRrdFile = new File(ifDir, SnmpCollectorMinMaxValTest.rrd("ifInOctets"));
        int numUpdates = 2;
        boolean stepSizeInSecs = true;
        int stepSizeInMillis = 1000;
        int rangeSizeInMillis = 21000;
        this.m_collectionSpecification.initialize(this.m_collectionAgent);
        CollectorTestUtils.collectNTimes(this.m_collectionSpecification, this.m_collectionAgent, 2);
        Assert.assertEquals((Object)123.0, (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)1000, (int)21000));
        Assert.assertEquals((Object)1234567.0, (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)1000, (int)21000));
        SnmpUtils.set((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.2.1.6.9.0"), (SnmpValue)SnmpUtils.getValueFactory().getInt32(456));
        SnmpUtils.set((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.10.6"), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(7654321L));
        CollectorTestUtils.collectNTimes(this.m_collectionSpecification, this.m_collectionAgent, 2);
        Assert.assertEquals((Object)456.0, (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)1000, (int)21000));
        Assert.assertEquals((Object)1234567.0, (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)1000, (int)21000));
        SnmpUtils.set((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.2.1.6.9.0"), (SnmpValue)SnmpUtils.getValueFactory().getInt32(456));
        SnmpUtils.set((SnmpAgentConfig)this.m_agentConfig, (SnmpObjId)SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.10.6"), (SnmpValue)SnmpUtils.getValueFactory().getCounter32(1234567L));
        CollectorTestUtils.collectNTimes(this.m_collectionSpecification, this.m_collectionAgent, 2);
        Assert.assertEquals((Object)456.0, (Object)RrdUtils.fetchLastValueInRange((String)rrdFile.getAbsolutePath(), (String)"tcpCurrEstab", (int)1000, (int)21000));
        Assert.assertEquals((Object)1234567.0, (Object)RrdUtils.fetchLastValueInRange((String)ifRrdFile.getAbsolutePath(), (String)"ifInOctets", (int)1000, (int)21000));
        this.m_collectionSpecification.release(this.m_collectionAgent);
    }

    private static String rrd(String file) {
        return file + RrdUtils.getExtension();
    }

    public void setTestContext(TestContext context) {
        this.m_context = context;
    }
}

