/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.collectd.JMXCollector;
import org.opennms.netmgt.collectd.JMXDataSource;
import org.opennms.netmgt.collectd.JMXNodeInfo;
import org.opennms.netmgt.collectd.jmxhelper.JmxTest;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.support.SingleResourceCollectionSet;
import org.opennms.netmgt.config.BeanInfo;
import org.opennms.netmgt.config.JMXDataCollectionConfigFactory;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXCollectorTest {
    private static Logger logger = LoggerFactory.getLogger(JMXCollectorTest.class);
    private JMXCollector jmxCollector;
    private MBeanServer platformMBeanServer;
    private CollectionAgent collectionAgent;
    private JMXNodeInfo jmxNodeInfo;
    private JMXDataCollectionConfigFactory jmxConfigFactory;

    @Before
    public void setUp() throws Exception {
        this.jmxNodeInfo = new JMXNodeInfo(0);
        this.jmxCollector = new JMXCollectorImpl();
        this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = new ObjectName("org.opennms.netmgt.collectd.jmxhelper:type=JmxTest");
        JmxTest testMBean = new JmxTest();
        this.platformMBeanServer.registerMBean(testMBean, objectName);
        this.collectionAgent = (CollectionAgent)EasyMock.createMock(CollectionAgent.class);
        EasyMock.expect((Object)this.collectionAgent.getAddress()).andReturn((Object)InetAddress.getLocalHost()).anyTimes();
        EasyMock.expect((Object)this.collectionAgent.getAttribute("org.opennms.netmgt.collectd.JMXCollector.nodeInfo")).andReturn((Object)this.jmxNodeInfo).anyTimes();
        EasyMock.expect((Object)this.collectionAgent.getNodeId()).andReturn((Object)0).anyTimes();
        EasyMock.expect((Object)this.collectionAgent.getStorageDir()).andReturn((Object)new File("")).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.collectionAgent});
        FileInputStream configFileStream = new FileInputStream("src/test/resources/etc/JmxCollectorConfigTest.xml");
        logger.debug("ConfigFileStream check '{}'", (Object)configFileStream.available());
        this.jmxConfigFactory = new JMXDataCollectionConfigFactory((InputStream)configFileStream);
        JMXDataCollectionConfigFactory.setInstance((JMXDataCollectionConfigFactory)this.jmxConfigFactory);
    }

    @After
    public void tearDown() throws Exception {
        this.jmxNodeInfo = null;
        this.jmxCollector.release();
        this.jmxCollector = null;
        this.platformMBeanServer.unregisterMBean(new ObjectName("org.opennms.netmgt.collectd.jmxhelper:type=JmxTest"));
        this.platformMBeanServer = null;
        EasyMock.verify((Object[])new Object[]{this.collectionAgent});
        EasyMock.reset((Object[])new Object[]{this.collectionAgent});
        this.jmxCollector = null;
    }

    @Test
    public void collectTwoBasicValues() {
        String mBeansObjectName = "org.opennms.netmgt.collectd.jmxhelper:type=JmxTest";
        HashMap<String, BeanInfo> mBeans = new HashMap<String, BeanInfo>();
        BeanInfo beanInfo = new BeanInfo();
        beanInfo.setObjectName(mBeansObjectName);
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("X");
        attributes.add("Name");
        beanInfo.setAttributes(attributes);
        mBeans.put("first", beanInfo);
        this.jmxNodeInfo.setMBeans(mBeans);
        HashMap<String, JMXDataSource> dataSourceMap = new HashMap<String, JMXDataSource>();
        dataSourceMap.put(mBeansObjectName + "|X", new JMXDataSource());
        dataSourceMap.put(mBeansObjectName + "|Name", new JMXDataSource());
        this.jmxNodeInfo.setDsMap(dataSourceMap);
        CollectionSet collectionSet = this.jmxCollector.collect(this.collectionAgent, null, null);
        Assert.assertEquals((String)"Collection of two dummy values run successfully", (long)1L, (long)collectionSet.getStatus());
    }

    @Test
    public void collectSingleMbeanWithSingleAttribute() {
        String collectionName = "collectSingleMbeanWithSingleAttribute";
        this.jmxNodeInfo.setMBeans(this.jmxConfigFactory.getMBeanInfo(collectionName));
        this.jmxNodeInfo.setDsMap(this.generateDataSourceMap(this.jmxConfigFactory.getAttributeMap(collectionName, "", "")));
        CollectionSet collectionSet = this.jmxCollector.collect(this.collectionAgent, null, null);
        SingleResourceCollectionSet jmxCollectionSet = (SingleResourceCollectionSet)collectionSet;
        JMXCollector.JMXCollectionResource jmxCollectionResource = (JMXCollector.JMXCollectionResource)jmxCollectionSet.getCollectionResource();
        AttributeGroup group = jmxCollectionResource.getGroup(new AttributeGroupType("java_lang_type_Compilation", "all"));
        Assert.assertEquals((long)1L, (long)group.getAttributes().size());
        this.printDebugAttributeGroup(group);
        Assert.assertEquals((String)("Collection: " + collectionName + " run successfully"), (long)1L, (long)collectionSet.getStatus());
    }

    @Test
    public void collectSingleMbeanWithOneNotAvailableAttribute() {
        String collectionName = "collectSingleMbeanWithOneNotAvailableAttribute";
        this.jmxNodeInfo.setMBeans(this.jmxConfigFactory.getMBeanInfo(collectionName));
        this.jmxNodeInfo.setDsMap(this.generateDataSourceMap(this.jmxConfigFactory.getAttributeMap(collectionName, "", "")));
        CollectionSet collectionSet = this.jmxCollector.collect(this.collectionAgent, null, null);
        SingleResourceCollectionSet jmxCollectionSet = (SingleResourceCollectionSet)collectionSet;
        JMXCollector.JMXCollectionResource jmxCollectionResource = (JMXCollector.JMXCollectionResource)jmxCollectionSet.getCollectionResource();
        AttributeGroup group = jmxCollectionResource.getGroup(new AttributeGroupType("java_lang_type_Compilation", "all"));
        Assert.assertEquals((long)0L, (long)group.getAttributes().size());
        this.printDebugAttributeGroup(group);
        Assert.assertEquals((String)("Collection: " + collectionName + " run successfully"), (long)1L, (long)collectionSet.getStatus());
    }

    @Test
    public void collectSingleMbeanWithOneNotAvailableAttributesAndOneAvailableAttributes() {
        String collectionName = "collectSingleMbeanWithOneNotAvailableAttributesAndOneAvailableAttributes";
        this.jmxNodeInfo.setMBeans(this.jmxConfigFactory.getMBeanInfo(collectionName));
        this.jmxNodeInfo.setDsMap(this.generateDataSourceMap(this.jmxConfigFactory.getAttributeMap(collectionName, "", "")));
        CollectionSet collectionSet = this.jmxCollector.collect(this.collectionAgent, null, null);
        SingleResourceCollectionSet jmxCollectionSet = (SingleResourceCollectionSet)collectionSet;
        JMXCollector.JMXCollectionResource jmxCollectionResource = (JMXCollector.JMXCollectionResource)jmxCollectionSet.getCollectionResource();
        AttributeGroup group = jmxCollectionResource.getGroup(new AttributeGroupType("java_lang_type_Compilation", "all"));
        Assert.assertEquals((long)1L, (long)group.getAttributes().size());
        this.printDebugAttributeGroup(group);
        Assert.assertEquals((String)("Collection: " + collectionName + " run successfully"), (long)1L, (long)collectionSet.getStatus());
    }

    @Test
    public void collectSingleMbeanWithManyNotAvailableAttributesAndManyAvailableAttributes() {
        String collectionName = "collectSingleMbeanWithManyNotAvailableAttributesAndManyAvailableAttributes";
        this.jmxNodeInfo.setMBeans(this.jmxConfigFactory.getMBeanInfo(collectionName));
        this.jmxNodeInfo.setDsMap(this.generateDataSourceMap(this.jmxConfigFactory.getAttributeMap(collectionName, "", "")));
        CollectionSet collectionSet = this.jmxCollector.collect(this.collectionAgent, null, null);
        SingleResourceCollectionSet jmxCollectionSet = (SingleResourceCollectionSet)collectionSet;
        JMXCollector.JMXCollectionResource jmxCollectionResource = (JMXCollector.JMXCollectionResource)jmxCollectionSet.getCollectionResource();
        AttributeGroup group = jmxCollectionResource.getGroup(new AttributeGroupType("java_lang_type_OperatingSystem", "all"));
        Assert.assertEquals((long)8L, (long)group.getAttributes().size());
        this.printDebugAttributeGroup(group);
        Assert.assertEquals((String)("Collection: " + collectionName + " run successfully"), (long)1L, (long)collectionSet.getStatus());
    }

    @Test
    public void collectSingleMbeanWithOneCompAttribWithAllItsCompMembers() {
        String collectionName = "collectSingleMbeanWithOneCompAttribWithAllItsCompMembers";
        this.jmxNodeInfo.setMBeans(this.jmxConfigFactory.getMBeanInfo(collectionName));
        this.jmxNodeInfo.setDsMap(this.generateDataSourceMap(this.jmxConfigFactory.getAttributeMap(collectionName, "", "")));
        CollectionSet collectionSet = this.jmxCollector.collect(this.collectionAgent, null, null);
        SingleResourceCollectionSet jmxCollectionSet = (SingleResourceCollectionSet)collectionSet;
        JMXCollector.JMXCollectionResource jmxCollectionResource = (JMXCollector.JMXCollectionResource)jmxCollectionSet.getCollectionResource();
        AttributeGroup group = jmxCollectionResource.getGroup(new AttributeGroupType("java_lang_type_Memory", "all"));
        Assert.assertEquals((long)4L, (long)group.getAttributes().size());
        this.printDebugAttributeGroup(group);
        Assert.assertEquals((String)("Collection: " + collectionName + " run successfully"), (long)1L, (long)collectionSet.getStatus());
    }

    @Test
    public void collectSingleMbeanWithOneCompAttribWithOneIgnoredCompMembers() {
        String collectionName = "collectSingleMbeanWithOneCompAttribWithOneIgnoredCompMembers";
        this.jmxNodeInfo.setMBeans(this.jmxConfigFactory.getMBeanInfo(collectionName));
        this.jmxNodeInfo.setDsMap(this.generateDataSourceMap(this.jmxConfigFactory.getAttributeMap(collectionName, "", "")));
        CollectionSet collectionSet = this.jmxCollector.collect(this.collectionAgent, null, null);
        SingleResourceCollectionSet jmxCollectionSet = (SingleResourceCollectionSet)collectionSet;
        JMXCollector.JMXCollectionResource jmxCollectionResource = (JMXCollector.JMXCollectionResource)jmxCollectionSet.getCollectionResource();
        AttributeGroup group = jmxCollectionResource.getGroup(new AttributeGroupType("java_lang_type_Memory", "all"));
        Assert.assertEquals((long)3L, (long)group.getAttributes().size());
        this.printDebugAttributeGroup(group);
        Assert.assertEquals((String)("Collection: " + collectionName + " run successfully"), (long)1L, (long)collectionSet.getStatus());
    }

    @Test
    public void collectJvmDefaultComposites() {
        String mBeansObjectName = "java.lang:type=GarbageCollector,name=PS MarkSweep";
        HashMap<String, BeanInfo> mBeans = new HashMap<String, BeanInfo>();
        BeanInfo beanInfo = new BeanInfo();
        beanInfo.setObjectName(mBeansObjectName);
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add("CollectionCount");
        attributes.add("LastGcInfo");
        beanInfo.setAttributes(attributes);
        ArrayList<String> compositeAttributes = new ArrayList<String>();
        compositeAttributes.add("LastGcInfo");
        beanInfo.setCompositeAttributes(compositeAttributes);
        mBeans.put("first", beanInfo);
        this.jmxNodeInfo.setMBeans(mBeans);
        HashMap<String, JMXDataSource> dataSourceMap = new HashMap<String, JMXDataSource>();
        dataSourceMap.put(mBeansObjectName + "|CollectionCount", new JMXDataSource());
        dataSourceMap.put(mBeansObjectName + "|LastGcInfo", new JMXDataSource());
        this.jmxNodeInfo.setDsMap(dataSourceMap);
        CollectionSet collectionSet = this.jmxCollector.collect(this.collectionAgent, null, null);
        Assert.assertEquals((String)"Collection of one Jvm default value run successfully", (long)1L, (long)collectionSet.getStatus());
    }

    private Map<String, JMXDataSource> generateDataSourceMap(Map<String, List<Attrib>> attributeMap) {
        return JMXCollector.buildDataSourceList((String)"foo", attributeMap);
    }

    private void printDebugAttributeGroup(AttributeGroup group) {
        for (CollectionAttribute collectionAttribute : group.getAttributes()) {
            logger.debug("Attribute Type   '{}'", (Object)collectionAttribute.getAttributeType());
            logger.debug("Attribute Name   '{}'", (Object)collectionAttribute.getName());
            logger.debug("Attrubute Number '{}'", (Object)collectionAttribute.getNumericValue());
            logger.debug("Attrubute Value  '{}'", (Object)collectionAttribute.getStringValue());
        }
    }

    public class JMXCollectorImpl
    extends JMXCollector {
        public ConnectionWrapper getMBeanServerConnection(Map<String, Object> map, InetAddress address) {
            return new ConnectionWrapper(){

                public MBeanServerConnection getMBeanServer() {
                    return JMXCollectorTest.this.platformMBeanServer;
                }

                public void close() {
                }
            };
        }
    }
}

