/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.Serializable;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.MockPlatformTransactionManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.DefaultCollectionAgent;
import org.opennms.netmgt.collectd.SnmpCollectionAgent;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.transaction.PlatformTransactionManager;

public class DefaultCollectionAgentTest {
    @Test
    public void verifyThatTheIpAndNodeIdAreCached() {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(11));
        OnmsIpInterface iface = new OnmsIpInterface();
        iface.setId(Integer.valueOf(42));
        iface.setNode(node);
        iface.setIpAddress(InetAddressUtils.ONE_TWENTY_SEVEN);
        IpInterfaceDao ifaceDao = (IpInterfaceDao)EasyMock.createMock(IpInterfaceDao.class);
        EasyMock.expect((Object)ifaceDao.load((Serializable)iface.getId())).andReturn((Object)iface).times(2);
        EasyMock.replay((Object[])new Object[]{ifaceDao});
        MockPlatformTransactionManager transMgr = new MockPlatformTransactionManager();
        SnmpCollectionAgent agent = DefaultCollectionAgent.create((Integer)iface.getId(), (IpInterfaceDao)ifaceDao, (PlatformTransactionManager)transMgr);
        EasyMock.verify((Object[])new Object[]{ifaceDao});
        Assert.assertEquals((Object)iface.getIpAddress(), (Object)agent.getAddress());
        Assert.assertEquals((long)node.getId().intValue(), (long)agent.getNodeId());
    }
}

