/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentSkipListMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.capsd.plugins.HttpPlugin;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
@JUnitConfigurationEnvironment
public class HttpPluginTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    @Ignore(value="This operation is not supported yet, see http://issues.opennms.org/browse/NMS-2963")
    @JUnitHttpServer(port=10342, basicAuth=true)
    public void testHttpBasicAuth() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        Parameter p = new Parameter();
        HttpPlugin plugin = new HttpPlugin();
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("3000");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-302");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("localhost");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/index.html");
        m.put(p.getKey(), p.getValue());
        Assert.assertFalse((boolean)plugin.isProtocolSupported(InetAddressUtils.getLocalHostAddress(), m));
        p.setKey("basic-authentication");
        p.setValue("admin:istrator");
        m.put(p.getKey(), p.getValue());
        Assert.assertTrue((boolean)plugin.isProtocolSupported(InetAddressUtils.getLocalHostAddress(), m));
    }
}

