/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.netmgt.capsd.IfSnmpCollector;
import org.opennms.netmgt.capsd.snmp.IfTable;
import org.opennms.netmgt.capsd.snmp.IfXTable;
import org.opennms.netmgt.capsd.snmp.IpAddrTable;
import org.opennms.netmgt.capsd.snmp.SystemGroup;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.springframework.core.io.ClassPathResource;

public class IfSnmpCollectorTestCase
extends OpenNMSTestCase {
    private static final String HOST_PROPERTY = "mock.snmpHost";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int PORT = 9161;
    private InetAddress m_addr;
    private volatile MockSnmpAgent m_agent;
    private volatile IfSnmpCollector m_ifSnmpc;
    private volatile boolean m_hasRun = false;

    @Override
    @Before
    public void setUp() throws Exception {
        this.setStartEventd(false);
        super.setUp();
        String hostName = System.getProperty(HOST_PROPERTY, DEFAULT_HOST);
        this.m_addr = InetAddressUtils.addr((String)hostName);
        this.m_ifSnmpc = new IfSnmpCollector(this.m_addr);
        this.m_agent = MockSnmpAgent.createAgentAndRun((URL)new ClassPathResource("org/opennms/netmgt/snmp/snmpTestData1.properties").getURL(), (String)(InetAddressUtils.str((InetAddress)this.m_addr) + "/" + 9161));
        this.runCollection();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.m_agent.shutDownAndWait();
        super.tearDown();
    }

    @Test
    public final void testIfSnmpCollector() throws UnknownHostException {
        Assert.assertFalse((String)"collection should not have failed", (boolean)this.m_ifSnmpc.failed());
    }

    @Test
    public void testFailed() throws Exception {
        this.m_agent.shutDownAndWait();
        IfSnmpCollector ifSnmpc = new IfSnmpCollector(this.m_addr);
        ifSnmpc.run();
        Assert.assertTrue((String)"collection should fail", (boolean)ifSnmpc.failed());
        Assert.assertTrue((String)"system group collection should fail", (boolean)ifSnmpc.getSystemGroup().failed());
        Assert.assertTrue((String)"ifTable collection should fail", (boolean)ifSnmpc.getIfTable().failed());
        Assert.assertTrue((String)"ifXTable collection should fail", (boolean)ifSnmpc.getIfXTable().failed());
        Assert.assertTrue((String)"ipAddrTable collection should fail", (boolean)ifSnmpc.getIpAddrTable().failed());
    }

    @Test
    public final void testHasSystemGroup() {
        Assert.assertTrue((String)"should have a system group", (boolean)this.m_ifSnmpc.hasSystemGroup());
    }

    @Test
    public final void testGetSystemGroup() throws UnknownHostException {
        SystemGroup sg = this.m_ifSnmpc.getSystemGroup();
        Assert.assertNotNull((String)"system group should not be null", (Object)sg);
        Assert.assertFalse((String)"system group should not have failed", (boolean)sg.failed());
        Assert.assertEquals((String)"system group name", (Object)"brozow.local", (Object)sg.getSysName());
    }

    @Test
    public final void testHasIfTable() {
        Assert.assertTrue((boolean)this.m_ifSnmpc.hasIfTable());
    }

    @Test
    public final void testGetIfTable() {
        IfTable ifTable = this.m_ifSnmpc.getIfTable();
        Assert.assertNotNull((String)"should have an ifTable", (Object)ifTable);
        Assert.assertFalse((String)"ifTable collection should not have failed", (boolean)ifTable.failed());
        Assert.assertEquals((String)"iftype", (long)24L, (long)ifTable.getIfType(1));
    }

    @Test
    public final void testHasIpAddrTable() {
        Assert.assertTrue((String)"should have an ipAddrTable", (boolean)this.m_ifSnmpc.hasIpAddrTable());
    }

    @Test
    public final void testGetIpAddrTable() throws UnknownHostException {
        IpAddrTable ipAddrTable = this.m_ifSnmpc.getIpAddrTable();
        Assert.assertNotNull((String)"ipAddrTable should not be null", (Object)ipAddrTable);
        Assert.assertFalse((String)"ipAddrTable collection should not hahve failed", (boolean)ipAddrTable.failed());
        Assert.assertEquals((String)"ipAddrTable ifIndex of 127.0.0.1", (long)1L, (long)ipAddrTable.getIfIndex(InetAddressUtils.addr((String)DEFAULT_HOST)));
        List addresses = ipAddrTable.getIpAddresses();
        Assert.assertTrue((String)"ipAddrTable should contain 192.0.2.201", (boolean)addresses.contains(InetAddressUtils.addr((String)"192.0.2.201")));
        Assert.assertTrue((String)"ipAddrTable should contain 127.0.0.1 like any good IP stack should", (boolean)addresses.contains(InetAddressUtils.addr((String)DEFAULT_HOST)));
    }

    @Test
    public final void testHasIfXTable() {
        Assert.assertTrue((String)"should have an ifXTable", (boolean)this.m_ifSnmpc.hasIfXTable());
    }

    @Test
    public final void testGetIfXTable() {
        IfXTable ifXTable = this.m_ifSnmpc.getIfXTable();
        Assert.assertNotNull((String)"ifXTable should not be null", (Object)ifXTable);
        Assert.assertFalse((String)"ifXTable collection should not have failed", (boolean)ifXTable.failed());
    }

    @Test
    public final void testGetCollectorTargetAddress() {
        InetAddress target = this.m_ifSnmpc.getCollectorTargetAddress();
        Assert.assertNotNull((String)"target addresss should not be null", (Object)target);
        Assert.assertEquals((String)"target address", (Object)this.myLocalHost(), (Object)target);
    }

    @Test
    public final void testGetIfAddressAndMask() {
        InetAddress[] addrMask = this.m_ifSnmpc.getIfAddressAndMask(1);
        Assert.assertNotNull((String)"address mask should not be null", (Object)addrMask);
        Assert.assertEquals((String)"localhost address", (Object)DEFAULT_HOST, (Object)InetAddressUtils.str((InetAddress)addrMask[0]));
        Assert.assertEquals((String)"localhost mask... mmm... class A.... yummy", (Object)"255.0.0.0", (Object)InetAddressUtils.str((InetAddress)addrMask[1]));
    }

    @Test
    public final void testGetAdminStatus() {
        int adminStatus = this.m_ifSnmpc.getAdminStatus(1);
        Assert.assertEquals((String)"admin status", (long)1L, (long)adminStatus);
    }

    @Test
    public final void testGetIfType() {
        int ifType = this.m_ifSnmpc.getIfType(1);
        Assert.assertEquals((String)"ifType", (long)24L, (long)ifType);
    }

    @Test
    public final void testGetIfIndex() throws UnknownHostException {
        int ifIndex = this.m_ifSnmpc.getIfIndex(InetAddressUtils.addr((String)"192.0.2.201"));
        Assert.assertEquals((String)"ifIndex", (long)5L, (long)ifIndex);
    }

    @Test
    public final void testGetIfName() {
        String ifName = this.m_ifSnmpc.getIfName(1);
        Assert.assertNotNull((String)"ifName should not be null", (Object)ifName);
        Assert.assertEquals((String)"ifName", (Object)"There's no place like 127.0.0.1", (Object)ifName);
    }

    @Test
    public final void testGetIfSpeed() {
        Long ifSpeed = this.m_ifSnmpc.getInterfaceSpeed(4);
        Assert.assertNotNull((String)"ifSpeed should not be null", (Object)ifSpeed);
        Assert.assertEquals((String)"ifSpeed", (Object)10000000L, (Object)ifSpeed);
    }

    @Test
    public final void testGetIfAlias() {
        String ifAlias = this.m_ifSnmpc.getIfAlias(1);
        Assert.assertNotNull((String)"ifAlias should not be null", (Object)ifAlias);
        Assert.assertEquals((String)"ifAlias", (Object)"We don't need no stinkin' ifAlias!", (Object)ifAlias);
    }

    private void runCollection() {
        if (this.m_hasRun) {
            return;
        }
        this.m_ifSnmpc.run();
        this.m_hasRun = true;
    }

    public static class SNMP4JIfSnmpCollectorTestCase
    extends IfSnmpCollectorTestCase {
        @Override
        public void setUp() throws Exception {
            System.setProperty("org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy");
            super.setUp();
        }
    }

    public static class JoeSnmpIfSnmpCollectorTestCase
    extends IfSnmpCollectorTestCase {
        @Override
        public void setUp() throws Exception {
            System.setProperty("org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.joesnmp.JoeSnmpStrategy");
            super.setUp();
        }
    }
}

