/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.io.IOException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-capsd.xml", "classpath:/META-INF/opennms/capsdTest.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath*:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.provisiond.enableDiscovery=false"})
@JUnitTemporaryDatabase
public class CapsdIntegrationTest
implements TemporaryDatabaseAware<MockDatabase>,
InitializingBean {
    private static final int FOREIGN_NODEID = 77;
    private static final String FOREIGN_NODE_IP_ADDRESS = "192.0.2.201";
    private MockNetwork m_mockNetwork = new MockNetwork();
    @Autowired
    private Capsd m_capsd;
    @Autowired
    private CapsdConfig m_capsdConfig;
    private MockDatabase m_db;

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        Assert.assertEquals((long)2L, (long)this.m_capsdConfig.getConfiguredProtocols().size());
        this.m_mockNetwork.createStandardNetwork();
        this.m_mockNetwork.addNode(77, "ForeignNode");
        this.m_mockNetwork.addInterface(FOREIGN_NODE_IP_ADDRESS);
        this.m_mockNetwork.addInterface("fe80:0000:0000:0000:ffff:eeee:dddd:cccc");
        this.m_mockNetwork.addService("ICMP");
        this.m_mockNetwork.addService("SNMP");
        this.m_db.populate(this.m_mockNetwork);
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.201", resource="classpath:org/opennms/netmgt/capsd/snmpTestData1.properties"), @JUnitSnmpAgent(host="192.0.2.204", resource="classpath:org/opennms/netmgt/capsd/snmpTestData1.properties"), @JUnitSnmpAgent(host="192.0.2.205", resource="classpath:org/opennms/netmgt/capsd/snmpTestData1.properties")})
    @JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
    public final void testRescan() throws Exception {
        Assert.assertEquals((String)"Initally only 2 interfaces", (long)2L, (long)this.m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.rescanInterfaceParent(Integer.valueOf(77));
        Thread.sleep(30000L);
        this.m_capsd.stop();
        Assert.assertEquals((String)"after scanning should be 3 interfaces", (long)3L, (long)this.m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.201", resource="classpath:org/opennms/netmgt/snmp/snmpTestData1.properties"), @JUnitSnmpAgent(host="192.0.2.204", resource="classpath:org/opennms/netmgt/snmp/snmpTestData1.properties"), @JUnitSnmpAgent(host="192.0.2.205", resource="classpath:org/opennms/netmgt/snmp/snmpTestData1.properties")})
    @JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
    public final void testRescanOfForeignNode() throws Exception {
        this.m_db.getJdbcTemplate().update("update node set foreignSource='testSource', foreignId='123' where nodeid = ?", new Object[]{77});
        Assert.assertEquals((String)"Initally only 2 interfaces", (long)2L, (long)this.m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.rescanInterfaceParent(Integer.valueOf(77));
        Thread.sleep(30000L);
        this.m_capsd.stop();
        Assert.assertEquals((String)"after scanning should still be 2 since its foreign", (long)2L, (long)this.m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.201", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="149.134.45.45", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.16.201.2", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.17.1.230", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.1.1", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.1", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.9", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.17", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.25", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.33", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.41", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.49", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.57", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.65", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.31.3.73", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="172.100.10.1", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="203.19.73.1", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties"), @JUnitSnmpAgent(host="203.220.17.53", resource="classpath:org/opennms/netmgt/snmp/stonegate.properties")})
    @JUnitTemporaryDatabase(tempDbClass=MockDatabase.class)
    public final void testStartStop() throws MarshalException, ValidationException, IOException {
        this.m_capsd.start();
        this.m_capsd.scanSuspectInterface(FOREIGN_NODE_IP_ADDRESS);
        this.m_capsd.stop();
    }
}

