/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ServerSocket;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.vmmgr.Controller;
import org.opennms.test.mock.MockLogAppender;

public class ControllerTest {
    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
    }

    @After
    public void runTest() throws Throwable {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testClientTimeout() throws Exception {
        final ServerSocket server = new ServerSocket(0);
        final Controller c = new Controller();
        c.setInvokeUrl("http://127.0.0.1:8181/invoke?objectname=OpenNMS%3AName=Manager".replaceAll(":8181", ":" + server.getLocalPort()));
        c.setHttpRequestReadTimeout(2000);
        Thread clientThread = new Thread(new Runnable(){

            @Override
            public void run() {
                c.invokeOperation("testClientTimeout");
            }
        }, this.getClass().getSimpleName() + "-clientThread");
        final StringBuffer exceptionBuffer = new StringBuffer();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable t) {
                exceptionBuffer.append(t.toString());
            }
        };
        clientThread.setUncaughtExceptionHandler(handler);
        clientThread.start();
        Thread acceptThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    server.accept();
                }
                catch (IOException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        }, this.getClass().getSimpleName() + "-acceptThread");
        acceptThread.setUncaughtExceptionHandler(handler);
        acceptThread.start();
        acceptThread.join(1000L);
        Assert.assertFalse((String)"the accept thread should have stopped because it should have received a connection", (boolean)acceptThread.isAlive());
        clientThread.join(c.getHttpRequestReadTimeout() * 2);
        Assert.assertFalse((String)("the client thread should have stopped within " + c.getHttpRequestReadTimeout() + " because it should have timed out its connection"), (boolean)clientThread.isAlive());
        Assert.assertEquals((String)("exception buffer is non-empty: " + exceptionBuffer.toString()), (long)0L, (long)exceptionBuffer.length());
        Assert.assertEquals((String)"there should be exactly one logged message", (long)1L, (long)MockLogAppender.getEvents().length);
        Assert.assertEquals((String)"the first log message should be an error", (Object)Level.ERROR, (Object)MockLogAppender.getEvents()[0].getLevel());
        MockLogAppender.resetEvents();
    }
}

