/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Test;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.threshd.ExpressionConfigWrapper;

public class ExpressionConfigWrapperTest {
    @Test
    public void testComplexExpression() throws Exception {
        Expression exp = new Expression();
        exp.setExpression("jnxOperatingState == 2.0 || jnxOperatingState == 3.0 || jnxOperatingState == 7.0 ? 1.0 : 0.0");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(exp);
        Assert.assertEquals((int)1, (int)wrapper.getRequiredDatasources().size());
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("jnxOperatingState", 1.0);
        Assert.assertEquals((Object)0.0, (Object)wrapper.evaluate(values));
        values.put("jnxOperatingState", 2.0);
        Assert.assertEquals((Object)1.0, (Object)wrapper.evaluate(values));
        values.put("jnxOperatingState", 3.0);
        Assert.assertEquals((Object)1.0, (Object)wrapper.evaluate(values));
        values.put("jnxOperatingState", 4.0);
        Assert.assertEquals((Object)0.0, (Object)wrapper.evaluate(values));
        values.put("jnxOperatingState", 5.0);
        Assert.assertEquals((Object)0.0, (Object)wrapper.evaluate(values));
        values.put("jnxOperatingState", 6.0);
        Assert.assertEquals((Object)0.0, (Object)wrapper.evaluate(values));
        values.put("jnxOperatingState", 7.0);
        Assert.assertEquals((Object)1.0, (Object)wrapper.evaluate(values));
    }

    @Test
    public void testHandleInvalidDsNames() throws Exception {
        Expression exp = new Expression();
        exp.setExpression("datasources['ns-dskTotal'] - datasources['ns-dskUsed']");
        ExpressionConfigWrapper wrapper = new ExpressionConfigWrapper(exp);
        Assert.assertEquals((int)1, (int)wrapper.getRequiredDatasources().size());
        HashMap<String, Double> values = new HashMap<String, Double>();
        values.put("ns-dskTotal", 100.0);
        values.put("ns-dskUsed", 40.0);
        Assert.assertEquals((Object)60.0, (Object)wrapper.evaluate(values));
    }
}

