/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.apache.log4j.Level;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.resource.Vault;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.config.DataCollectionConfigDao;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.test.mock.MockLogAppender;

public class CollectionResourceWrapperTest {
    Level m_logLevelToCheck;

    @Before
    public void setUp() throws Exception {
        CollectionResourceWrapper.s_cache.clear();
        this.m_logLevelToCheck = Level.WARN;
        MockLogAppender.setupLogging();
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNotGreaterOrEqual((Level)this.m_logLevelToCheck);
    }

    @Test
    public void testGetGaugeValue() throws Exception {
        CollectionAgent agent = this.createCollectionAgent();
        SnmpCollectionResource resource = this.createNodeResource(agent);
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        SnmpAttribute attribute = this.addAttributeToCollectionResource(resource, "myGauge", "gauge", "0", 100L);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        CollectionResourceWrapper wrapper = this.createWrapper(resource, attributes);
        Assert.assertEquals((Object)100.0, (Object)wrapper.getAttributeValue("myGauge"));
        Assert.assertEquals((Object)100.0, (Object)wrapper.getAttributeValue("myGauge"));
        Assert.assertEquals((Object)100.0, (Object)wrapper.getAttributeValue("myGauge"));
        EasyMock.verify((Object[])new Object[]{agent});
    }

    @Test
    public void testGetCounterValue() throws Exception {
        CollectionAgent agent = this.createCollectionAgent();
        SnmpCollectionResource resource = this.createNodeResource(agent);
        String attributeName = "myCounter";
        String attributeId = "node[1]." + attributeName;
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        SnmpAttribute attribute = this.addAttributeToCollectionResource(resource, attributeName, "counter", "0", 1000L);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        Date baseDate = new Date();
        CollectionResourceWrapper wrapper = this.createWrapper(resource, attributes, baseDate);
        Assert.assertFalse((boolean)CollectionResourceWrapper.s_cache.containsKey(attributeId));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)1000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        attribute = this.addAttributeToCollectionResource(resource, attributeName, "counter", "0", 2500L);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 300000L));
        Assert.assertEquals((Object)1000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        attribute = this.addAttributeToCollectionResource(resource, attributeName, "counter", "0", 5500L);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 600000L));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)10.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)5500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)10.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)5500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)10.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)5500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
    }

    @Test
    public void testGetCounterValueWithGap() throws Exception {
        this.m_logLevelToCheck = Level.ERROR;
        CollectionAgent agent = this.createCollectionAgent();
        SnmpCollectionResource resource = this.createNodeResource(agent);
        String attributeName = "myCounter";
        String attributeId = "node[1]." + attributeName;
        HashMap<String, Object> attributes = new HashMap<String, CollectionAttribute>();
        SnmpAttribute attribute = this.addAttributeToCollectionResource(resource, attributeName, "counter", "0", 1000L);
        attributes.put(attribute.getName(), attribute);
        Date baseDate = new Date();
        CollectionResourceWrapper wrapper = this.createWrapper(resource, attributes, baseDate);
        Assert.assertFalse((boolean)CollectionResourceWrapper.s_cache.containsKey(attributeId));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)1000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        attribute = this.addAttributeToCollectionResource(resource, attributeName, "counter", "0", 2500L);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 300000L));
        Assert.assertEquals((Object)1000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)5.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        attributes = new HashMap();
        attribute = this.addAttributeToCollectionResource(resource, "notMyCounter", "counter", "0", 1000L);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 600000L));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertNull((Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        attributes = new HashMap();
        attribute = this.addAttributeToCollectionResource(resource, attributeName, "counter", "0", 7300L);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 900000L));
        Assert.assertEquals((Object)2500.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)8.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)7300.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)8.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)7300.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)8.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)7300.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    @Test
    public void testGetCounterValueWithWrap() throws Exception {
        CollectionAgent agent = this.createCollectionAgent();
        SnmpCollectionResource resource = this.createNodeResource(agent);
        Date baseDate = new Date();
        String attributeName = "myCounter";
        String attributeId = "node[1]." + attributeName;
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        BigInteger initialValue = new BigDecimal(Math.pow(2.0, 32.0) - 20000.0).toBigInteger();
        SnmpAttribute attribute = this.addAttributeToCollectionResource(resource, attributeName, "counter", "0", initialValue);
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        CollectionResourceWrapper wrapper = this.createWrapper(resource, attributes, baseDate);
        Assert.assertFalse((boolean)CollectionResourceWrapper.s_cache.containsKey(attributeId));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)Double.NaN, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)initialValue.doubleValue(), (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        attribute = this.addAttributeToCollectionResource(resource, attributeName, "counter", "0", new BigInteger("40000"));
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        wrapper = this.createWrapper(resource, attributes, new Date(baseDate.getTime() + 300000L));
        Assert.assertEquals((Object)initialValue.doubleValue(), (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)200.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)40000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)200.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)40000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        Assert.assertEquals((Object)200.0, (Object)wrapper.getAttributeValue(attributeName));
        Assert.assertEquals((Object)40000.0, (Object)((CollectionResourceWrapper.CacheEntry)CollectionResourceWrapper.s_cache.get((Object)attributeId)).value);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    @Test
    public void testInterfaceResource() throws Exception {
        String ipAddress = "10.0.0.1";
        String ifName = "eth0";
        int ifIndex = 2;
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "testNode");
        network.addInterface(ipAddress);
        network.setIfAlias(ifName);
        network.addService("ICMP");
        network.addService("SNMP");
        network.addService("HTTP");
        MockDatabase db = new MockDatabase();
        db.populate(network);
        db.update("update snmpinterface set snmpifindex=?, snmpifname=?, snmpifdescr=? where id=?", new Object[]{ifIndex, ifName, ifName, 1});
        DataSourceFactory.setInstance((DataSource)((Object)db));
        Vault.setDataSource((DataSource)((Object)db));
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("testNode");
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(node, ifIndex);
        snmpIface.setIfDescr(ifName);
        snmpIface.setIfName(ifName);
        snmpIface.setIfAlias(ifName);
        snmpIface.setIfSpeed(Long.valueOf(10000000L));
        SnmpIfData ifData = new SnmpIfData(snmpIface);
        CollectionAgent agent = this.createCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig);
        IfResourceType resourceType = new IfResourceType(agent, collection);
        IfInfo resource = new IfInfo((ResourceType)resourceType, agent, ifData);
        SnmpAttribute attribute = this.addAttributeToCollectionResource((SnmpCollectionResource)resource, "ifInOctets", "counter", "ifIndex", 5000L);
        HashMap<String, CollectionAttribute> attributes = new HashMap<String, CollectionAttribute>();
        attributes.put(attribute.getName(), (CollectionAttribute)attribute);
        CollectionResourceWrapper wrapper = this.createWrapper((SnmpCollectionResource)resource, attributes);
        Assert.assertEquals((int)node.getId(), (int)wrapper.getNodeId());
        Assert.assertEquals((String)"127.0.0.1", (String)wrapper.getHostAddress());
        Assert.assertEquals((String)"eth0", (String)wrapper.getIfLabel());
        Assert.assertEquals((String)"if", (String)wrapper.getResourceTypeName());
        Assert.assertEquals((String)"SNMP", (String)wrapper.getServiceName());
        Assert.assertEquals((boolean)true, (boolean)wrapper.isAnInterfaceResource());
        Assert.assertEquals((String)Integer.toString(ifIndex), (String)wrapper.getInstance());
        Assert.assertEquals((String)Integer.toString(ifIndex), (String)wrapper.getIfIndex());
        Assert.assertEquals((String)Integer.toString(ifIndex), (String)wrapper.getIfIndex());
        Assert.assertEquals((String)Integer.toString(ifIndex), (String)wrapper.getIfIndex());
        Assert.assertEquals((String)"eth0", (String)wrapper.getIfInfoValue("snmpifname"));
    }

    private SnmpCollectionResource createNodeResource(CollectionAgent agent) {
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfigDao)dataCollectionConfig);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        return new NodeInfo(resourceType, agent);
    }

    private CollectionResourceWrapper createWrapper(SnmpCollectionResource resource, Map<String, CollectionAttribute> attributes, Date timestamp) {
        CollectionResourceWrapper wrapper = new CollectionResourceWrapper(timestamp, 1, "127.0.0.1", "SNMP", this.getRepository(), (CollectionResource)resource, attributes);
        return wrapper;
    }

    private CollectionResourceWrapper createWrapper(SnmpCollectionResource resource, Map<String, CollectionAttribute> attributes) {
        return this.createWrapper(resource, attributes, new Date());
    }

    private CollectionAgent createCollectionAgent() {
        CollectionAgent agent = (CollectionAgent)EasyMock.createMock(CollectionAgent.class);
        EasyMock.expect((Object)agent.getNodeId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)agent.getHostAddress()).andReturn((Object)"127.0.0.1").anyTimes();
        EasyMock.expect((Object)agent.getSnmpInterfaceInfo((IfResourceType)EasyMock.anyObject())).andReturn(new HashSet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{agent});
        return agent;
    }

    private SnmpAttribute addAttributeToCollectionResource(SnmpCollectionResource resource, String attributeName, String attributeType, String attributeInstance, long value) {
        MibObject object = this.createMibObject(attributeType, attributeName, attributeInstance);
        NumericAttributeType objectType = new NumericAttributeType(resource.getResourceType(), "default", object, new AttributeGroupType("mibGroup", "ignore"));
        SnmpValue snmpValue = attributeType.equals("counter") ? SnmpUtils.getValueFactory().getCounter32(value) : SnmpUtils.getValueFactory().getGauge32(value);
        resource.setAttributeValue((SnmpAttributeType)objectType, snmpValue);
        return new SnmpAttribute((CollectionResource)resource, (SnmpAttributeType)objectType, snmpValue);
    }

    private SnmpAttribute addAttributeToCollectionResource(SnmpCollectionResource resource, String attributeName, String attributeType, String attributeInstance, BigInteger value) {
        MibObject object = this.createMibObject(attributeType, attributeName, attributeInstance);
        NumericAttributeType objectType = new NumericAttributeType(resource.getResourceType(), "default", object, new AttributeGroupType("mibGroup", "ignore"));
        SnmpValue snmpValue = SnmpUtils.getValueFactory().getCounter64(value);
        resource.setAttributeValue((SnmpAttributeType)objectType, snmpValue);
        return new SnmpAttribute((CollectionResource)resource, (SnmpAttributeType)objectType, snmpValue);
    }

    private MibObject createMibObject(String type, String alias, String instance) {
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias(alias);
        mibObject.setType(type);
        mibObject.setInstance(instance);
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        return mibObject;
    }

    private RrdRepository getRepository() {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File("/tmp"));
        return repo;
    }
}

