/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols;

import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import junit.framework.TestCase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.protocols.ssh.Ssh;

public class SshTest
extends TestCase {
    InetAddress good;
    private static final InetAddress bad = InetAddressUtils.UNPINGABLE_ADDRESS;
    private static final String GOOD_HOST = "www.opennms.org";
    private static final int PORT = 22;
    private static final int TIMEOUT = 2000;
    private TimeoutTracker tt;
    Ssh ssh;

    public void setUp() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("retries", "0");
        parameters.put("port", "22");
        parameters.put("timeout", Integer.toString(2000));
        this.tt = new TimeoutTracker(parameters, 0, 2000);
        this.ssh = new Ssh();
        this.ssh.setPort(22);
        this.ssh.setTimeout(2000);
        this.good = InetAddressUtils.addr((String)GOOD_HOST);
    }

    public void testSshGood() throws Exception {
        this.ssh.setAddress(this.good);
        SshTest.assertTrue((boolean)this.ssh.poll(this.tt).isAvailable());
    }

    public void testSshBad() throws Exception {
        Date start = new Date();
        this.ssh.setAddress(bad);
        SshTest.assertFalse((boolean)this.ssh.poll(this.tt).isAvailable());
        Date end = new Date();
        SshTest.assertTrue((end.getTime() - start.getTime() < 2500L ? 1 : 0) != 0);
    }
}

