/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.poller.remote.DefaultTimeAdjustment;

public class DefaultTimeAdjustmentTest {
    private static final long m_jitter = 2L;

    @Test
    public void testNoTimeDifference() {
        DefaultTimeAdjustment timeAdjustment = new DefaultTimeAdjustment();
        long time = System.currentTimeMillis();
        long adjusted = timeAdjustment.adjustTimeToMasterTime(time);
        this.assertEqualsWithin(time, adjusted, 2L);
    }

    @Test
    public void testServerTimeMatches() {
        DefaultTimeAdjustment timeAdjustment = new DefaultTimeAdjustment();
        timeAdjustment.setMasterTime(System.currentTimeMillis());
        long time = System.currentTimeMillis();
        long adjusted = timeAdjustment.adjustTimeToMasterTime(time);
        this.assertEqualsWithin(time, adjusted, 2L);
    }

    @Test
    public void testServerBehind() {
        DefaultTimeAdjustment timeAdjustment = new DefaultTimeAdjustment();
        timeAdjustment.setMasterTime(System.currentTimeMillis() - 60000L);
        long time = System.currentTimeMillis();
        long adjusted = timeAdjustment.adjustTimeToMasterTime(time);
        this.assertEqualsWithin(time - 60000L, adjusted, 2L);
    }

    @Test
    public void testServerAhead() {
        DefaultTimeAdjustment timeAdjustment = new DefaultTimeAdjustment();
        timeAdjustment.setMasterTime(System.currentTimeMillis() + 60000L);
        long time = System.currentTimeMillis();
        long adjusted = timeAdjustment.adjustTimeToMasterTime(time);
        this.assertEqualsWithin(time + 60000L, adjusted, 2L);
    }

    @Test
    public void testAssertEqualsWithin() {
        this.assertEqualsWithin(5L, 7L, 2L);
        this.assertEqualsWithin(7L, 5L, 2L);
        try {
            this.assertEqualsWithin(5L, 8L, 2L);
        }
        catch (AssertionError e) {
            Assert.assertTrue((e != null ? 1 : 0) != 0);
        }
        try {
            this.assertEqualsWithin(8L, 5L, 2L);
        }
        catch (AssertionError e) {
            Assert.assertTrue((e != null ? 1 : 0) != 0);
        }
    }

    private void assertEqualsWithin(long a, long b, long distance) {
        boolean fail = false;
        if (a + distance < b) {
            fail = true;
        } else if (b + distance < a) {
            fail = true;
        }
        if (fail) {
            Assert.fail((String)String.format("%d and %d were not within %d of each other", a, b, distance));
        }
    }
}

