/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.mock.snmp.MockSnmpValue;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.MockLogAppender;

public class SnmpMonitorStrategyTest {
    private SnmpMonitorStrategy monitor = new SnmpMonitorStrategy(){

        public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
            throw new UnsupportedOperationException("method not implemented; go away, punk!");
        }
    };

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testMeetsCriteriaWithNullResult() {
        SnmpValue result = null;
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, null, null));
    }

    @Test
    public void testMeetsCriteriaWithSnmpNull() {
        SnmpValue result = MockSnmpValue.NULL_VALUE;
        this.testSyntaxEquals(result, "", "1");
    }

    @Test
    public void testMeetsCriteriaWithString() {
        MockSnmpValue.StringSnmpValue result = new MockSnmpValue.StringSnmpValue("A Test String");
        this.testSyntaxEquals((SnmpValue)result, "A Test String", "a test string");
        this.testSyntaxMatches((SnmpValue)result, "[tT][eE][sS][tT]", "test");
        this.testSyntaxMatches((SnmpValue)result, "^A Test String$", "^A Test$");
    }

    @Test
    public void testMeetsCriteriaWithObjectID() {
        MockSnmpValue.OidSnmpValue result = new MockSnmpValue.OidSnmpValue(".1.2.3.4.5.6.7.8.9");
        this.testSyntaxEquals((SnmpValue)result, ".1.2.3.4.5.6.7.8.9", "..1.2.3.4.5.6.7.8.9");
        this.testSyntaxMatches((SnmpValue)result, "\\.7\\.", "\\.11\\.");
    }

    @Test
    public void testMeetsCriteriaWithIPAddr() throws Exception {
        MockSnmpValue.IpAddressSnmpValue result = new MockSnmpValue.IpAddressSnmpValue("10.1.1.1");
        this.testSyntaxEquals((SnmpValue)result, "10.1.1.1", "10.1.1.2");
        this.testSyntaxMatches((SnmpValue)result, "10\\.1\\.1\\.[1-5]", "10\\.1\\.1\\.[02-9]");
    }

    @Test
    public void testNumericString() {
        MockSnmpValue.StringSnmpValue result = new MockSnmpValue.StringSnmpValue("12345");
        this.testOrderOperations((SnmpValue)result, 12345);
    }

    @Test
    public void testMeetsCriteriaWithInteger() {
        MockSnmpValue.Integer32SnmpValue result = new MockSnmpValue.Integer32SnmpValue(1234);
        this.testSyntaxEquals((SnmpValue)result, "1234", "2234");
        this.testOrderOperations((SnmpValue)result, 1234);
        this.testSyntaxMatches((SnmpValue)result, "23", "14");
    }

    @Test
    public void testMeetsCriteriaWithCounter32() {
        MockSnmpValue.Counter32SnmpValue result = new MockSnmpValue.Counter32SnmpValue(1);
        this.testSyntaxEquals((SnmpValue)result, "1", "2");
        this.testOrderOperations((SnmpValue)result, 1);
    }

    @Test
    public void testMeetsCriteriaWithGauge32() {
        MockSnmpValue.Gauge32SnmpValue result = new MockSnmpValue.Gauge32SnmpValue(1);
        this.testSyntaxEquals((SnmpValue)result, "1", "2");
        this.testOrderOperations((SnmpValue)result, 1);
    }

    @Test
    public void testMeetsCriteriaWithTimeTicks() {
        MockSnmpValue.TimeticksSnmpValue result = new MockSnmpValue.TimeticksSnmpValue("1");
        this.testSyntaxEquals((SnmpValue)result, "1", "2");
        this.testOrderOperations((SnmpValue)result, 1);
    }

    @Test
    public void testMeetsCriteriaWithCounter64() {
        MockSnmpValue.Counter64SnmpValue result = new MockSnmpValue.Counter64SnmpValue(1L);
        this.testSyntaxEquals((SnmpValue)result, "1", "2");
        this.testOrderOperations((SnmpValue)result, 1);
    }

    @Test
    public void testErrorConditions() {
        MockSnmpValue.Integer32SnmpValue result = new MockSnmpValue.Integer32SnmpValue(1);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("operator X is unknown"));
        try {
            this.monitor.meetsCriteria((SnmpValue)result, "X", "123");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testErrorConditions2() {
        MockSnmpValue.Integer32SnmpValue result = new MockSnmpValue.Integer32SnmpValue(1);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new NumberFormatException("For input string: \"abc\""));
        try {
            this.monitor.meetsCriteria((SnmpValue)result, "<", "abc");
            Assert.fail((String)"expected an exception");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    private void testSyntaxEquals(SnmpValue result, String eqString, String neString) {
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, null, null));
        Assert.assertTrue((String)("result '" + result + "' should pass equal test with '" + eqString + "'"), (boolean)this.monitor.meetsCriteria(result, "=", eqString));
        Assert.assertFalse((String)("result '" + result + "' should fail equal test with '" + neString + "'"), (boolean)this.monitor.meetsCriteria(result, "=", neString));
        Assert.assertFalse((String)("result '" + result + "' should fail not equal test with '" + eqString + "'"), (boolean)this.monitor.meetsCriteria(result, "!=", eqString));
        Assert.assertTrue((String)("result '" + result + "' should pass not equal test with '" + neString + "'"), (boolean)this.monitor.meetsCriteria(result, "!=", neString));
    }

    private void testSyntaxMatches(SnmpValue result, String matchString, String noMatchString) {
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, "~", matchString));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, "~", noMatchString));
    }

    private void testOrderOperations(SnmpValue result, int value) {
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, "<", Integer.toString(value + 1)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, "<", Integer.toString(value)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, "<", Integer.toString(value - 1)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, "<=", Integer.toString(value + 1)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, "<=", Integer.toString(value)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, "<=", Integer.toString(value - 1)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, ">", Integer.toString(value + 1)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, ">", Integer.toString(value)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, ">", Integer.toString(value - 1)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, ">=", Integer.toString(value + 1)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, ">=", Integer.toString(value)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, ">=", Integer.toString(value - 1)));
    }
}

