/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.annotations.JUnitHttpServer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.HttpMonitor;
import org.opennms.netmgt.poller.monitors.HttpsMonitor;
import org.opennms.netmgt.poller.monitors.MonitorTestUtils;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
@JUnitConfigurationEnvironment
public class HttpMonitorTest {
    private boolean m_runTests = true;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testPollStatusReason() throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(99, "www.opennms.org", "HTTP");
        p.setKey("port");
        p.setValue("3020");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testResponseRange() throws UnknownHostException {
        this.callTestResponseRange(false);
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testResponseRangeIPv6() throws UnknownHostException {
        this.callTestResponseRange(true);
    }

    public void callTestResponseRange(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, "localhost", "HTTP", preferIPv6);
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-199");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
        p.setKey("response");
        p.setValue("100,200,302,400-500");
        m.put(p.getKey(), p.getValue());
        monitor = new HttpMonitor();
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
        p.setKey("response");
        p.setValue("*");
        m.put(p.getKey(), p.getValue());
        monitor = new HttpMonitor();
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @Ignore
    public void testTimeout() throws UnknownHostException {
        this.callTestTimeout(false);
    }

    @Test
    public void testTimeoutIPv6() throws UnknownHostException {
        this.callTestTimeout(true);
    }

    public void callTestTimeout(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, preferIPv6 ? InetAddressUtils.UNPINGABLE_ADDRESS_IPV6 : InetAddressUtils.UNPINGABLE_ADDRESS, "HTTP");
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-199");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
        Assert.assertTrue((boolean)status.getReason().contains("HTTP connection timeout"));
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testMatchingTextInResponse() throws UnknownHostException {
        this.callTestMatchingTextInResponse(false);
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testMatchingTextInResponseIPv6() throws UnknownHostException {
        this.callTestMatchingTextInResponse(true);
    }

    public void callTestMatchingTextInResponse(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, "localhost", "HTTP", preferIPv6);
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-499");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("localhost");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("opennmsrulz");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
        p.setKey("response-text");
        p.setValue("written by monkeys");
        m.put(p.getKey(), p.getValue());
        MockUtil.println((String)"\nliteral text check: \"written by monkeys\"");
        monitor = new HttpMonitor();
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
        p.setKey("response-text");
        p.setValue("~.*[Tt]est HTTP [Ss]erver.*");
        m.put(p.getKey(), p.getValue());
        MockUtil.println((String)"\nregex check: \".*[Tt]est HTTP [Ss]erver.*\"");
        monitor = new HttpMonitor();
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    public void testBase64Encoding() {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        p.setKey("basic-authentication");
        p.setValue("Aladdin:open sesame");
        m.put(p.getKey(), p.getValue());
        Assert.assertEquals((Object)"QWxhZGRpbjpvcGVuIHNlc2FtZQ==", (Object)HttpMonitor.determineBasicAuthentication(m));
        Assert.assertFalse((boolean)"QWxhZGRpbjpvcZVuIHNlc2FtZQ==".equals(HttpMonitor.determineBasicAuthentication(m)));
    }

    @Test
    @JUnitHttpServer(port=10342, basicAuth=true)
    public void testBasicAuthentication() throws UnknownHostException {
        this.callTestBasicAuthentication(false);
    }

    @Test
    @JUnitHttpServer(port=10342, basicAuth=true)
    public void testBasicAuthenticationIPv6() throws UnknownHostException {
        this.callTestBasicAuthentication(true);
    }

    public void callTestBasicAuthentication(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(1, "localhost", "HTTP", preferIPv6);
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-302");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("localhost");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/");
        m.put(p.getKey(), p.getValue());
        p.setKey("basic-authentication");
        p.setValue("admin:istrator");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
        p.setKey("basic-authentication");
        p.setValue("admin:flagrator");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertNotNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342, https=true, basicAuth=true)
    public void testBasicAuthenticationWithHttps() throws UnknownHostException {
        this.callTestBasicAuthenticationWithHttps(false);
    }

    @Test
    @JUnitHttpServer(port=10342, https=true, basicAuth=true)
    public void testBasicAuthenticationWithHttpsIPv6() throws UnknownHostException {
        this.callTestBasicAuthenticationWithHttps(true);
    }

    public void callTestBasicAuthenticationWithHttps(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpsMonitor monitor = new HttpsMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(1, "localhost", "HTTPS", preferIPv6);
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-302");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("localhost");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/index.html");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
        Assert.assertEquals((Object)"HTTP response value: 401. Expecting: 100-302./Ports: 10342", (Object)status.getReason());
        p.setKey("basic-authentication");
        p.setValue("admin:istrator");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testWithUrl() throws UnknownHostException {
        this.callTestWithUrl(false);
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testWithUrlIPv6() throws UnknownHostException {
        this.callTestWithUrl(true);
    }

    public void callTestWithUrl(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, "localhost", "HTTP", preferIPv6);
        p.setKey("host-name");
        p.setValue("localhost");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/twinkies.html");
        m.put(p.getKey(), p.getValue());
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("100-499");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("~.*Don.t you love twinkies..*");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testWithInvalidNodelabelHostName() throws UnknownHostException {
        this.callTestWithInvalidNodelabelHostName(false);
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testWithInvalidNodelabelHostNameIPv6() throws UnknownHostException {
        this.callTestWithInvalidNodelabelHostName(true);
    }

    public void callTestWithInvalidNodelabelHostName(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        PollStatus status = null;
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, "localhost", "HTTP", preferIPv6);
        svc.setNodeLabel("bad.virtual.host.example.com");
        p.setKey("nodelabel-host-name");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("0");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("response");
        p.setValue("404");
        m.put(p.getKey(), p.getValue());
        p.setKey("verbose");
        p.setValue("true");
        m.put(p.getKey(), p.getValue());
        status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
        Assert.assertNull((Object)status.getReason());
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"opennms.com"})
    public void testPollInInvalidVirtualDomain() throws UnknownHostException {
        this.callTestPollInInvalidVirtualDomain(false);
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"opennms.com"})
    public void testPollInInvalidVirtualDomainIPv6() throws UnknownHostException {
        this.callTestPollInInvalidVirtualDomain(true);
    }

    public void callTestPollInInvalidVirtualDomain(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, "localhost", "HTTP", preferIPv6);
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("www.google.com");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/twinkies.html");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("~.*twinkies.*");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        Assert.assertEquals((String)"poll status available", (long)2L, (long)status.getStatusCode());
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"www.opennms.org"})
    public void testPollValidVirtualDomain() throws UnknownHostException {
        this.callTestPollValidVirtualDomain(false);
    }

    @Test
    @JUnitHttpServer(port=10342, vhosts={"www.opennms.org"})
    public void testPollValidVirtualDomainIPv6() throws UnknownHostException {
        this.callTestPollValidVirtualDomain(true);
    }

    public void callTestPollValidVirtualDomain(boolean preferIPv6) throws UnknownHostException {
        if (!this.m_runTests) {
            return;
        }
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Parameter p = new Parameter();
        HttpMonitor monitor = new HttpMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, "localhost", "HTTP", preferIPv6);
        p.setKey("port");
        p.setValue("10342");
        m.put(p.getKey(), p.getValue());
        p.setKey("retry");
        p.setValue("1");
        m.put(p.getKey(), p.getValue());
        p.setKey("timeout");
        p.setValue("500");
        m.put(p.getKey(), p.getValue());
        p.setKey("host-name");
        p.setValue("www.opennms.org");
        m.put(p.getKey(), p.getValue());
        p.setKey("url");
        p.setValue("/twinkies.html");
        m.put(p.getKey(), p.getValue());
        p.setKey("response-text");
        p.setValue("~.*twinkies.*");
        m.put(p.getKey(), p.getValue());
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        Assert.assertEquals((String)"poll status not available", (long)1L, (long)status.getStatusCode());
    }

    @Test
    @JUnitHttpServer(port=10342)
    public void testNMS2702() throws UnknownHostException {
        HttpMonitor monitor = new HttpMonitor();
        Map<String, String> parameters = Collections.synchronizedMap(new TreeMap());
        parameters.put("port", "10342");
        parameters.put("url", "/test-NMS2702.html");
        parameters.put("retry", "1");
        parameters.put("timeout", "500");
        parameters.put("verbose", "true");
        parameters.put("response-text", "~.*OK.*");
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService(3, "localhost", "HTTP", false);
        PollStatus status = monitor.poll((MonitoredService)svc, parameters);
        Assert.assertTrue((boolean)status.isAvailable());
        parameters.put("response-text", "~.*Jetty.*");
        svc = MonitorTestUtils.getMonitoredService(3, "localhost", "HTTP", false);
        status = monitor.poll((MonitoredService)svc, parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }
}

