/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.DNSResolutionMonitor;
import org.opennms.test.mock.MockLogAppender;

public class DNSResolutionMonitorTest {
    @Before
    public void setUp() {
        MockLogAppender.setupLogging((boolean)true);
    }

    @Test
    public void testPoll() throws Exception {
        MockMonitoredService dual = new MockMonitoredService(1, "wipv6day.opennms.org", InetAddress.getLocalHost(), "RESOLVE");
        MockMonitoredService v4only = new MockMonitoredService(1, "choopa-ipv4.opennms.org", InetAddress.getLocalHost(), "RESOLVE");
        MockMonitoredService v6only = new MockMonitoredService(1, "choopa-ipv6.opennms.org", InetAddress.getLocalHost(), "RESOLVE");
        MockMonitoredService neither = new MockMonitoredService(1, "no-such-name.example.com", InetAddress.getLocalHost(), "RESOLVE");
        DNSResolutionMonitor monitor = new DNSResolutionMonitor();
        monitor.initialize(Collections.emptyMap());
        monitor.initialize((MonitoredService)dual);
        monitor.initialize((MonitoredService)v4only);
        monitor.initialize((MonitoredService)v6only);
        monitor.initialize((MonitoredService)neither);
        Map<String, String> v4Parms = Collections.singletonMap("resolution-type", "v4");
        Map<String, String> v6Parms = Collections.singletonMap("resolution-type", "v6");
        Map<String, String> bothParms = Collections.singletonMap("resolution-type", "both");
        Map<String, String> eitherParms = Collections.singletonMap("resolution-type", "either");
        Assert.assertEquals((Object)PollStatus.available(), (Object)monitor.poll((MonitoredService)dual, v4Parms));
        Assert.assertEquals((Object)PollStatus.available(), (Object)monitor.poll((MonitoredService)dual, v6Parms));
        Assert.assertEquals((Object)PollStatus.available(), (Object)monitor.poll((MonitoredService)dual, bothParms));
        Assert.assertEquals((Object)PollStatus.available(), (Object)monitor.poll((MonitoredService)dual, eitherParms));
        Assert.assertEquals((Object)PollStatus.available(), (Object)monitor.poll((MonitoredService)v4only, v4Parms));
        Assert.assertEquals((Object)PollStatus.unavailable(), (Object)monitor.poll((MonitoredService)v4only, v6Parms));
        Assert.assertEquals((Object)PollStatus.unavailable(), (Object)monitor.poll((MonitoredService)v4only, bothParms));
        Assert.assertEquals((Object)PollStatus.available(), (Object)monitor.poll((MonitoredService)v4only, eitherParms));
        Assert.assertEquals((Object)PollStatus.unavailable(), (Object)monitor.poll((MonitoredService)v6only, v4Parms));
        Assert.assertEquals((Object)PollStatus.available(), (Object)monitor.poll((MonitoredService)v6only, v6Parms));
        Assert.assertEquals((Object)PollStatus.unavailable(), (Object)monitor.poll((MonitoredService)v6only, bothParms));
        Assert.assertEquals((Object)PollStatus.available(), (Object)monitor.poll((MonitoredService)v6only, eitherParms));
        Assert.assertEquals((Object)PollStatus.unavailable(), (Object)monitor.poll((MonitoredService)neither, v4Parms));
        Assert.assertEquals((Object)PollStatus.unavailable(), (Object)monitor.poll((MonitoredService)neither, v6Parms));
        Assert.assertEquals((Object)PollStatus.unavailable(), (Object)monitor.poll((MonitoredService)neither, bothParms));
        Assert.assertEquals((Object)PollStatus.unavailable(), (Object)monitor.poll((MonitoredService)neither, eitherParms));
        monitor.release((MonitoredService)dual);
        monitor.release((MonitoredService)v4only);
        monitor.release((MonitoredService)v6only);
        monitor.release((MonitoredService)neither);
        monitor.release();
    }
}

