/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd.mock;

import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.netmgt.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.mock.MockNotification;
import org.opennms.netmgt.notifd.mock.NotificationAnticipator;
import org.opennms.test.mock.MockUtil;

public class MockNotificationStrategy
implements NotificationStrategy {
    private static NotificationAnticipator s_anticipator = null;

    public MockNotificationStrategy() {
        MockUtil.println((String)("Created a " + MockNotificationStrategy.class.getName()));
    }

    public int send(List<Argument> arguments) {
        MockUtil.println((String)("Message sent with arguments:" + arguments));
        MockNotification notification = new MockNotification();
        for (Argument arg : arguments) {
            if (arg.getSwitch().equals("-subject")) {
                notification.setSubject(arg.getValue());
                continue;
            }
            if (arg.getSwitch().equals("-email")) {
                notification.setEmail(arg.getValue());
                continue;
            }
            if (!arg.getSwitch().equals("-tm")) continue;
            notification.setTextMsg(arg.getValue());
        }
        notification.setExpectedTime(System.currentTimeMillis());
        NotificationAnticipator anticipator = MockNotificationStrategy.getAnticipator();
        if (anticipator == null) {
            throw new NullPointerException("anticipator is null");
        }
        anticipator.notificationReceived(notification);
        return 0;
    }

    public static NotificationAnticipator getAnticipator() {
        return s_anticipator;
    }

    public static void setAnticipator(NotificationAnticipator anticipator) {
        s_anticipator = anticipator;
    }

    static {
        MockUtil.println((String)("Static initializer on " + MockNotificationStrategy.class.getName()));
    }
}

