/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.mock.EventWrapper;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;

public class EventAnticipator
implements EventListener {
    boolean m_discardUnanticipated = false;
    final List<EventWrapper> m_anticipatedEvents = new ArrayList<EventWrapper>();
    final List<Event> m_anticipatedEventsReceived = new ArrayList<Event>();
    final List<Event> m_unanticipatedEvents = new ArrayList<Event>();

    public boolean isDiscardUnanticipated() {
        return this.m_discardUnanticipated;
    }

    public void setDiscardUnanticipated(boolean discardUnanticipated) {
        this.m_discardUnanticipated = discardUnanticipated;
    }

    public void anticipateEvent(Event event) {
        this.anticipateEvent(event, false);
    }

    public synchronized void anticipateEvent(Event event, boolean checkUnanticipatedList) {
        EventWrapper w = new EventWrapper(event);
        if (checkUnanticipatedList) {
            Iterator<Event> it = this.m_unanticipatedEvents.iterator();
            while (it.hasNext()) {
                Event unE = it.next();
                EventWrapper unW = new EventWrapper(unE);
                if (!unW.equals((Object)w)) continue;
                it.remove();
                this.notifyAll();
                return;
            }
        }
        this.m_anticipatedEvents.add(w);
        this.notifyAll();
    }

    public synchronized void eventReceived(Event event) {
        EventWrapper w = new EventWrapper(event);
        if (this.m_anticipatedEvents.contains(w)) {
            this.m_anticipatedEvents.remove(w);
            this.m_anticipatedEventsReceived.add(event);
            this.notifyAll();
        } else {
            this.saveUnanticipatedEvent(event);
        }
    }

    private void saveUnanticipatedEvent(Event event) {
        if (!this.m_discardUnanticipated) {
            this.m_unanticipatedEvents.add(event);
        }
    }

    public synchronized Collection<Event> getAnticipatedEvents() {
        ArrayList<Event> events = new ArrayList<Event>(this.m_anticipatedEvents.size());
        for (EventWrapper w : this.m_anticipatedEvents) {
            events.add(w.getEvent());
        }
        return events;
    }

    public synchronized List<Event> getAnticipatedEventsRecieved() {
        return new ArrayList<Event>(this.m_anticipatedEventsReceived);
    }

    public void reset() {
        this.resetAnticipated();
        this.resetUnanticipated();
    }

    public void resetUnanticipated() {
        this.m_unanticipatedEvents.clear();
    }

    public void resetAnticipated() {
        this.m_anticipatedEvents.clear();
        this.m_anticipatedEventsReceived.clear();
    }

    public Collection<Event> unanticipatedEvents() {
        return Collections.synchronizedCollection(Collections.unmodifiableCollection(this.m_unanticipatedEvents));
    }

    public synchronized Collection<Event> waitForAnticipated(long millis) {
        long last;
        long now = last = System.currentTimeMillis();
        for (long waitTime = millis; waitTime > 0L; waitTime -= now - last) {
            if (this.m_anticipatedEvents.isEmpty()) {
                return new ArrayList<Event>(0);
            }
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                LogUtils.errorf((Object)this, (Throwable)e, (String)"interrupted while waiting for anticipated events", (Object[])new Object[0]);
            }
            now = System.currentTimeMillis();
            last = now;
        }
        return this.getAnticipatedEvents();
    }

    public void eventProcessed(Event event) {
    }

    public void verifyAnticipated(long wait, long sleepMiddle, long sleepAfter, int anticipatedSize, int unanticipatedSize) {
        StringBuffer problems = new StringBuffer();
        Collection<Event> missingEvents = this.waitForAnticipated(wait);
        if (sleepMiddle > 0L) {
            try {
                Thread.sleep(sleepMiddle);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (anticipatedSize >= 0 && missingEvents.size() != anticipatedSize) {
            problems.append(missingEvents.size() + " expected events still outstanding (expected " + anticipatedSize + "):\n");
            problems.append(EventAnticipator.listEvents("\t", missingEvents));
        }
        if (sleepAfter > 0L) {
            try {
                Thread.sleep(sleepAfter);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (unanticipatedSize >= 0 && this.unanticipatedEvents().size() != unanticipatedSize) {
            problems.append(this.unanticipatedEvents().size() + " unanticipated events received (expected " + unanticipatedSize + "):\n");
            problems.append(EventAnticipator.listEvents("\t", this.unanticipatedEvents()));
        }
        if (problems.length() > 0) {
            problems.deleteCharAt(problems.length() - 1);
            Assert.fail((String)problems.toString());
        }
    }

    public void verifyAnticipated() {
        this.verifyAnticipated(0L, 0L, 0L, 0, 0);
    }

    private static String listEvents(String prefix, Collection<Event> events) {
        StringBuffer b = new StringBuffer();
        for (Event event : events) {
            b.append(prefix);
            b.append(event.getUei() + " / " + event.getNodeid() + " / " + event.getInterface() + " / " + event.getService());
            b.append("\n");
        }
        return b.toString();
    }

    public String getName() {
        return "eventAnticipator";
    }

    public void onEvent(Event e) {
        this.eventReceived(e);
    }
}

