/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.eventd.EventHandler;
import org.opennms.netmgt.eventd.EventIpcManagerDefaultImpl;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class EventIpcManagerDefaultImplTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private EventIpcManagerDefaultImpl m_manager;
    private EventHandler m_eventHandler = (EventHandler)this.m_mocks.createMock(EventHandler.class);
    private MockEventListener m_listener = new MockEventListener();
    private Throwable m_caughtThrowable = null;
    private Thread m_caughtThrowableThread = null;

    public void setUp() throws Exception {
        this.m_manager = new EventIpcManagerDefaultImpl();
        this.m_manager.setEventHandler(this.m_eventHandler);
        this.m_manager.setHandlerPoolSize(5);
        this.m_manager.afterPropertiesSet();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                EventIpcManagerDefaultImplTest.this.m_caughtThrowable = throwable;
                EventIpcManagerDefaultImplTest.this.m_caughtThrowableThread = thread;
            }
        });
    }

    public void runTest() throws Throwable {
        super.runTest();
        EventIpcManagerDefaultImplTest.assertEquals((String)"unprocessed received events", (int)0, (int)this.m_listener.getEvents().size());
        if (this.m_caughtThrowable != null) {
            throw new Exception("Thread " + this.m_caughtThrowableThread + " threw an uncaught exception: " + this.m_caughtThrowable, this.m_caughtThrowable);
        }
    }

    public void testInitWithNoHandlerPoolSize() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("handlerPoolSize not set"));
        EventIpcManagerDefaultImpl manager = new EventIpcManagerDefaultImpl();
        manager.setEventHandler(this.m_eventHandler);
        try {
            manager.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testInitWithNoEventHandler() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("eventHandler not set"));
        EventIpcManagerDefaultImpl manager = new EventIpcManagerDefaultImpl();
        manager.setHandlerPoolSize(5);
        try {
            manager.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testInit() throws Exception {
        EventIpcManagerDefaultImpl manager = new EventIpcManagerDefaultImpl();
        manager.setEventHandler(this.m_eventHandler);
        manager.setHandlerPoolSize(5);
        manager.afterPropertiesSet();
    }

    public void testBroadcastWithNoListeners() throws Exception {
        EventBuilder bldr = new EventBuilder(null, "testBroadcastWithNoListeners");
        this.m_mocks.replayAll();
        this.m_manager.broadcastNow(bldr.getEvent());
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
    }

    public void testSendNowNullEvent() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("event argument cannot be null"));
        try {
            this.m_manager.sendNow((Event)null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testSendNowNullEventLog() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("eventLog argument cannot be null"));
        try {
            this.m_manager.sendNow((Log)null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAddEventListenerNullListener() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("listener argument cannot be null"));
        try {
            this.m_manager.addEventListener((EventListener)null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAddEventListenerAndBroadcast() throws Exception {
        EventBuilder bldr = new EventBuilder(null, "testAddEventListenerAndBroadcast");
        Event event = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.addEventListener((EventListener)this.m_listener);
        this.m_manager.broadcastNow(event);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
        EventIpcManagerDefaultImplTest.assertTrue((String)"could not remove broadcasted event--did it make it?", (boolean)this.m_listener.getEvents().remove(event));
    }

    public void testAddEventListenerTwoArgumentListNullListener() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("listener argument cannot be null"));
        try {
            this.m_manager.addEventListener((EventListener)null, new ArrayList(0));
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAddEventListenerTwoArgumentListNullUeiList() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("ueilist argument cannot be null"));
        try {
            this.m_manager.addEventListener((EventListener)this.m_listener, (Collection)null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAddEventListenerTwoArgumentStringAndBroadcast() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/foo", "testAddEventListenerTwoArgumentStringAndBroadcast");
        Event e = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.addEventListener((EventListener)this.m_listener, e.getUei());
        this.m_manager.broadcastNow(e);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
        EventIpcManagerDefaultImplTest.assertTrue((String)"could not remove broadcasted event--did it make it?", (boolean)this.m_listener.getEvents().remove(e));
    }

    public void testAddEventListenerTwoArgumentStringWithUeiPartAndBroadcast() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/foo", "testAddEventListenerTwoArgumentStringWithUeiPartAndBroadcast");
        Event e = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.addEventListener((EventListener)this.m_listener, "uei.opennms.org/");
        this.m_manager.broadcastNow(e);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
        EventIpcManagerDefaultImplTest.assertTrue((String)"could not remove broadcasted event--did it make it?", (boolean)this.m_listener.getEvents().remove(e));
    }

    public void testAddEventListenerTwoArgumentStringWithUeiPartMultipleTrimAndBroadcast() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/foo", "testAddEventListenerTwoArgumentStringWithUeiPartMultipleTrimAndBroadcast");
        Event e = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.addEventListener((EventListener)this.m_listener, "uei.opennms.org/");
        this.m_manager.broadcastNow(e);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
        EventIpcManagerDefaultImplTest.assertTrue((String)"could not remove broadcasted event--did it make it?", (boolean)this.m_listener.getEvents().remove(e));
    }

    public void testAddEventListenerTwoArgumentStringWithUeiPartTooLittleAndBroadcast() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/foo", "testAddEventListenerTwoArgumentStringWithUeiPartTooLittleAndBroadcast");
        Event e = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.addEventListener((EventListener)this.m_listener, "uei.opennms.org");
        this.m_manager.broadcastNow(e);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
    }

    public void testAddEventListenerTwoArgumentStringWithUeiPartTooMuchAndBroadcast() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/foo", "testAddEventListenerTwoArgumentStringWithUeiPartTooMuchAndBroadcast");
        Event e = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.addEventListener((EventListener)this.m_listener, "uei.opennms.org/*");
        this.m_manager.broadcastNow(e);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
    }

    public void testAddEventListenerWithUeiAndSubUeiMatchAndBroadcast() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/foo", "testAddEventListenerWithUeiAndSubUeiMatchAndBroadcast");
        Event e = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.addEventListener((EventListener)this.m_listener, "uei.opennms.org/foo");
        this.m_manager.addEventListener((EventListener)this.m_listener, "uei.opennms.org/");
        this.m_manager.broadcastNow(e);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
        EventIpcManagerDefaultImplTest.assertTrue((String)"could not remove broadcasted event--did it make it?", (boolean)this.m_listener.getEvents().remove(e));
    }

    public void testAddEventListenerTwoArgumentStringNullListener() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("listener argument cannot be null"));
        try {
            this.m_manager.addEventListener((EventListener)null, "");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAddEventListenerTwoArgumentStringNullUeiList() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("uei argument cannot be null"));
        try {
            this.m_manager.addEventListener((EventListener)this.m_listener, (String)null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testRemoveEventListenerNullListener() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("listener argument cannot be null"));
        try {
            this.m_manager.removeEventListener((EventListener)null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testRemoveEventListenerTwoArgumentListNullListener() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("listener argument cannot be null"));
        try {
            this.m_manager.removeEventListener((EventListener)null, new ArrayList(0));
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testRemoveEventListenerTwoArgumentListNullUeiList() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("ueilist argument cannot be null"));
        try {
            this.m_manager.removeEventListener((EventListener)this.m_listener, (Collection)null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testRemoveEventListenerTwoArgumentStringNullListener() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("listener argument cannot be null"));
        try {
            this.m_manager.removeEventListener((EventListener)null, "");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testRemoveEventListenerTwoArgumentStringNullUeiList() throws Exception {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("uei argument cannot be null"));
        try {
            this.m_manager.removeEventListener((EventListener)this.m_listener, (String)null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAddEventListenerThenAddEventListenerWithUeiAndBroadcast() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/foo", "testAddEventListenerThenAddEventListenerWithUeiAndBroadcast");
        Event e = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.addEventListener((EventListener)this.m_listener);
        this.m_manager.addEventListener((EventListener)this.m_listener, e.getUei());
        this.m_manager.broadcastNow(e);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
        EventIpcManagerDefaultImplTest.assertTrue((String)"could not remove broadcasted event--did it make it?", (boolean)this.m_listener.getEvents().remove(e));
    }

    public void testAddEventListenerWithUeiAndBroadcastThenAddEventListener() throws Exception {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/foo", "testAddEventListenerWithUeiAndBroadcastThenAddEventListener");
        Event e = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.addEventListener((EventListener)this.m_listener, e.getUei());
        this.m_manager.addEventListener((EventListener)this.m_listener);
        this.m_manager.broadcastNow(e);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
        EventIpcManagerDefaultImplTest.assertTrue((String)"could not remove broadcasted event--did it make it?", (boolean)this.m_listener.getEvents().remove(e));
    }

    public void testNoDateDate() throws InterruptedException {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeLostService", "the one true event source");
        bldr.setNodeid(1L);
        bldr.setInterface(InetAddressUtils.addr((String)"192.168.1.1"));
        bldr.setService("ICMP");
        Event e = bldr.getEvent();
        this.m_mocks.replayAll();
        this.m_manager.broadcastNow(e);
        Thread.sleep(100L);
        this.m_mocks.verifyAll();
    }

    public class MockEventListener
    implements EventListener {
        private List<Event> m_events = new ArrayList<Event>();

        public String getName() {
            return "party on, Wayne";
        }

        public void onEvent(Event e) {
            this.m_events.add(e);
        }

        public List<Event> getEvents() {
            return this.m_events;
        }
    }
}

