/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import junit.framework.TestCase;
import org.opennms.netmgt.config.EventConfDao;
import org.opennms.netmgt.eventd.BroadcastEventProcessor;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class BroadcastEventProcessorTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private EventConfDao m_eventConfDao = (EventConfDao)this.m_mocks.createMock(EventConfDao.class);

    public void testInstantiateWithNullEventIpcManager() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("argument eventIpcManager must not be null"));
        try {
            new BroadcastEventProcessor(null, this.m_eventConfDao);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testInstantiateWithNullEventConfDao() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("argument eventConfDao must not be null"));
        try {
            new BroadcastEventProcessor((EventIpcManager)new MockEventIpcManager(), null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testInstantiateAndClose() {
        MockEventIpcManager eventIpcManager = new MockEventIpcManager();
        BroadcastEventProcessor processor = new BroadcastEventProcessor((EventIpcManager)eventIpcManager, this.m_eventConfDao);
        processor.close();
    }

    public void testReload() {
        MockEventIpcManager eventIpcManager = new MockEventIpcManager();
        BroadcastEventProcessor processor = new BroadcastEventProcessor((EventIpcManager)eventIpcManager, this.m_eventConfDao);
        EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/eventsConfigChange", "dunno");
        this.m_eventConfDao.reload();
        this.m_mocks.replayAll();
        processor.onEvent(eventBuilder.getEvent());
        this.m_mocks.verifyAll();
    }
}

