/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.List;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.config.syslogd.HideMatch;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;

public class SyslogdConfigFactoryTest {
    private SyslogdConfigFactory m_factory;

    @Before
    public void setUp() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.setRelativeHomeDirectory("src/test/resources");
        daoTestConfig.afterPropertiesSet();
        MockNetwork network = new MockNetwork();
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
        this.m_factory = new SyslogdConfigFactory(ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"/etc/syslogd-configuration.xml"));
    }

    @Test
    public void testSetUp() {
    }

    @Test
    public void testMyHostNameGrouping() {
        Assert.assertEquals((long)6L, (long)this.m_factory.getMatchingGroupHost());
    }

    @Test
    public void testMyMessageGroup() {
        Assert.assertEquals((long)8L, (long)this.m_factory.getMatchingGroupMessage());
    }

    @Test
    public void testPattern() {
        Assert.assertEquals((Object)"^.*\\s(19|20)\\d\\d([-/.])(0[1-9]|1[012])\\2(0[1-9]|[12][0-9]|3[01])(\\s+)(\\S+)(\\s)(\\S.+)", (Object)this.m_factory.getForwardingRegexp());
    }

    @Test
    public void testUEI() {
        List ueiList = this.m_factory.getUeiList().getUeiMatchCollection();
        UeiMatch uei = (UeiMatch)ueiList.get(0);
        Assert.assertEquals((Object)"substr", (Object)uei.getMatch().getType());
        Assert.assertEquals((Object)"CRISCO", (Object)uei.getMatch().getExpression());
        Assert.assertEquals((Object)"uei.opennms.org/tests/syslogd/substrUeiRewriteTest", (Object)uei.getUei());
        uei = (UeiMatch)ueiList.get(1);
        Assert.assertEquals((Object)"regex", (Object)uei.getMatch().getType());
        Assert.assertEquals((Object)"foo: (\\d+) out of (\\d+) tests failed for (\\S+)$", (Object)uei.getMatch().getExpression());
        Assert.assertEquals((Object)"uei.opennms.org/tests/syslogd/regexUeiRewriteTest", (Object)uei.getUei());
    }

    @Test
    public void testHideTheseMessages() {
        for (HideMatch hide : this.m_factory.getHideMessages().getHideMatchCollection()) {
            boolean typeOk = hide.getMatch().getType().equals("substr") || hide.getMatch().getType().equals("regex");
            Assert.assertTrue((boolean)typeOk);
            if (hide.getMatch().getType().equals("substr")) {
                Assert.assertEquals((Object)"TESTHIDING", (Object)hide.getMatch().getExpression());
                continue;
            }
            if (!hide.getMatch().getType().equals("regex")) continue;
            Assert.assertEquals((Object)"[Dd]ouble[Ss]ecret", (Object)hide.getMatch().getExpression());
        }
    }

    @Test
    public void testImportFiles() throws Exception {
        SyslogdConfigFactory factory = new SyslogdConfigFactory(ConfigurationTestUtils.getInputStreamForResource((Object)this, (String)"/etc/syslogd-configuration-with-imports.xml"));
        Assert.assertEquals((long)22L, (long)factory.getUeiList().getUeiMatchCount());
        Assert.assertEquals((long)4L, (long)factory.getHideMessages().getHideMatchCount());
        int countMatch = 0;
        for (HideMatch hide : factory.getHideMessages().getHideMatchCollection()) {
            if (!hide.getMatch().getExpression().startsWith("bad")) continue;
            ++countMatch;
        }
        Assert.assertEquals((long)2L, (long)countMatch);
        countMatch = 0;
        for (UeiMatch ueiMatch : factory.getUeiList().getUeiMatchCollection()) {
            if (ueiMatch.getProcessMatch() == null || !ueiMatch.getProcessMatch().getExpression().startsWith("agalue")) continue;
            ++countMatch;
        }
        Assert.assertEquals((long)8L, (long)countMatch);
    }
}

