/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.model.discovery.IPAddress;
import org.opennms.netmgt.model.discovery.IPAddressRange;
import org.opennms.netmgt.model.discovery.IPAddressRangeSet;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class SnmpEventInfoTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConfigRangeCreateOutOfOrder() {
        new IPAddressRange("192.168.1.2", "192.168.1.1");
    }

    @Test
    public void testAddressIncr() {
        IPAddress ipA = new IPAddress("::5");
        Assert.assertEquals((Object)"::6", (Object)ipA.incr().toString());
        IPAddress ipB = new IPAddress("::ffff:ffff");
        Assert.assertEquals((Object)"::1:0:0", (Object)ipB.incr().toString());
        IPAddress ipC = new IPAddress("::ff00:ffff");
        Assert.assertEquals((Object)"::ff01:0", (Object)ipC.incr().toString());
        IPAddress ipD = new IPAddress("::ff00:7fff");
        Assert.assertEquals((Object)"::ff00:8000", (Object)ipD.incr().toString());
    }

    @Test
    public void testConfigAddressDecr() {
        IPAddress a = new IPAddress("::6");
        Assert.assertEquals((Object)"::5", (Object)a.decr().toString());
        IPAddress b = new IPAddress("::1:0:0");
        Assert.assertEquals((Object)"::ffff:ffff", (Object)b.decr().toString());
        IPAddress c = new IPAddress("ff::ffff:1:0");
        Assert.assertEquals((Object)"ff::ffff:0:ffff", (Object)c.decr().toString());
        IPAddress d = new IPAddress("ff::ffff:1:8000");
        Assert.assertEquals((Object)"ff::ffff:1:7fff", (Object)d.decr().toString());
    }

    @Test
    public void testContainsAddr() {
        IPAddressRange range = new IPAddressRange("192.168.1.1", "192.168.1.3");
        Assert.assertFalse((boolean)range.contains("192.168.0.1"));
        Assert.assertTrue((boolean)range.contains("192.168.1.1"));
        Assert.assertTrue((boolean)range.contains("192.168.1.2"));
        Assert.assertTrue((boolean)range.contains("192.168.1.3"));
        Assert.assertFalse((boolean)range.contains("192.168.1.4"));
    }

    @Test
    public void testFollows() {
        IPAddressRange s = new IPAddressRange("192.168.1.5", "192.168.1.6");
        IPAddressRange q = new IPAddressRange("192.168.1.1", "192.168.1.2");
        IPAddressRange r = new IPAddressRange("192.168.1.3", "192.168.1.4");
        Assert.assertTrue((boolean)r.comesAfter(q));
        Assert.assertFalse((boolean)r.comesAfter(r));
        Assert.assertFalse((boolean)r.comesAfter(s));
    }

    @Test
    public void testContainsAddrIPv6() {
        IPAddressRange r = new IPAddressRange("2001:db8::10", "2001:db8::20");
        Assert.assertFalse((boolean)r.contains("192.168.0.1"));
        Assert.assertFalse((boolean)r.contains("2001:db8::1"));
        Assert.assertTrue((boolean)r.contains("2001:db8::10"));
        Assert.assertTrue((boolean)r.contains("2001:db8::15"));
        Assert.assertTrue((boolean)r.contains("2001:db8::20"));
        Assert.assertFalse((boolean)r.contains("2001:db8::21"));
    }

    @Test
    public void testContainsRange() {
        IPAddressRange r = new IPAddressRange("192.168.1.1", "192.168.1.10");
        Assert.assertTrue((boolean)r.contains(new IPAddressRange("192.168.1.1", "192.168.1.1")));
        Assert.assertTrue((boolean)r.contains(new IPAddressRange("192.168.1.10", "192.168.1.10")));
        Assert.assertTrue((boolean)r.contains(new IPAddressRange("192.168.1.2", "192.168.1.7")));
        Assert.assertFalse((boolean)r.contains(new IPAddressRange("192.168.1.0", "192.168.1.1")));
        Assert.assertFalse((boolean)r.contains(new IPAddressRange("192.168.1.2", "192.168.1.11")));
        Assert.assertFalse((boolean)r.contains(new IPAddressRange("192.168.1.0", "192.168.1.11")));
    }

    @Test
    public void testPreceedsRange() {
        IPAddressRange r = new IPAddressRange("192.168.1.10", "192.168.1.20");
        Assert.assertTrue((boolean)r.comesBefore(new IPAddressRange("192.168.1.21", "192.168.1.30")));
        Assert.assertTrue((boolean)r.comesBefore(new IPAddressRange("192.168.1.21", "192.168.1.21")));
        Assert.assertFalse((boolean)r.comesBefore(new IPAddressRange("192.168.1.20", "192.168.1.30")));
        Assert.assertFalse((boolean)r.comesBefore(new IPAddressRange("192.168.1.7", "192.168.1.9")));
    }

    @Test
    public void testOverlapsRange() {
        IPAddressRange r = new IPAddressRange("192.168.1.10", "192.168.1.20");
        Assert.assertTrue((boolean)r.overlaps(new IPAddressRange("192.168.1.10", "192.168.1.10")));
        Assert.assertTrue((boolean)r.overlaps(new IPAddressRange("192.168.1.20", "192.168.1.20")));
        Assert.assertTrue((boolean)r.overlaps(new IPAddressRange("192.168.1.10", "192.168.1.20")));
        Assert.assertTrue((boolean)r.overlaps(new IPAddressRange("192.168.1.9", "192.168.1.22")));
        Assert.assertTrue((boolean)r.overlaps(new IPAddressRange("192.168.1.15", "192.168.1.22")));
        Assert.assertTrue((boolean)r.overlaps(new IPAddressRange("192.168.1.9", "192.168.1.15")));
        Assert.assertTrue((boolean)r.overlaps(new IPAddressRange("192.168.1.11", "192.168.1.19")));
        Assert.assertFalse((boolean)r.overlaps(new IPAddressRange("192.168.1.5", "192.168.1.9")));
        Assert.assertFalse((boolean)r.overlaps(new IPAddressRange("192.168.1.21", "192.168.1.22")));
    }

    @Test
    public void testAdjacentRange() {
        IPAddressRange r = new IPAddressRange("192.168.1.10", "192.168.1.20");
        Assert.assertTrue((boolean)r.adjoins(new IPAddressRange("192.168.1.7", "192.168.1.9")));
        Assert.assertFalse((boolean)r.adjoins(new IPAddressRange("192.168.1.7", "192.168.1.8")));
        Assert.assertFalse((boolean)r.adjoins(new IPAddressRange("192.168.1.7", "192.168.1.21")));
        Assert.assertTrue((boolean)r.adjoins(new IPAddressRange("192.168.1.21", "192.168.1.21")));
    }

    @Test
    public void testConfigRangeEquals() {
        IPAddressRange r = new IPAddressRange("192.168.1.10", "192.168.1.20");
        Assert.assertEquals((Object)r, (Object)r);
        Assert.assertEquals((Object)r, (Object)new IPAddressRange("192.168.1.10", "192.168.1.20"));
        Assert.assertFalse((boolean)r.equals((Object)new IPAddressRange("192.168.1.10", "192.168.1.19")));
    }

    @Test
    public void testCombine() {
        IPAddressRange rr = new IPAddressRange("192.168.1.10", "192.168.1.20");
        Assert.assertEquals((Object)rr, (Object)rr.combine(new IPAddressRange("192.168.1.10", "192.168.1.20")));
        Assert.assertEquals((Object)rr, (Object)rr.combine(new IPAddressRange("192.168.1.11", "192.168.1.20")));
        Assert.assertEquals((Object)rr, (Object)rr.combine(new IPAddressRange("192.168.1.10", "192.168.1.19")));
        Assert.assertEquals((Object)rr, (Object)rr.combine(new IPAddressRange("192.168.1.11", "192.168.1.19")));
        Assert.assertEquals((Object)new IPAddressRange("192.168.1.9", "192.168.1.20"), (Object)rr.combine(new IPAddressRange("192.168.1.9", "192.168.1.12")));
        Assert.assertEquals((Object)new IPAddressRange("192.168.1.10", "192.168.1.22"), (Object)rr.combine(new IPAddressRange("192.168.1.13", "192.168.1.22")));
        Assert.assertEquals((Object)new IPAddressRange("192.168.1.9", "192.168.1.22"), (Object)rr.combine(new IPAddressRange("192.168.1.9", "192.168.1.22")));
        Assert.assertEquals((Object)new IPAddressRange("192.168.1.7", "192.168.1.20"), (Object)rr.combine(new IPAddressRange("192.168.1.7", "192.168.1.9")));
        Assert.assertEquals((Object)new IPAddressRange("192.168.1.10", "192.168.1.24"), (Object)rr.combine(new IPAddressRange("192.168.1.21", "192.168.1.24")));
    }

    @Test
    public void testRemove() {
        IPAddressRange r = new IPAddressRange("192.168.1.10", "192.168.1.20");
        Assert.assertArrayEquals((Object[])new IPAddressRange[0], (Object[])r.remove(r));
        Assert.assertArrayEquals((Object[])new IPAddressRange[0], (Object[])r.remove(new IPAddressRange("192.168.1.5", "192.168.1.27")));
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{r}, (Object[])r.remove(new IPAddressRange("192.168.1.5", "192.168.1.7")));
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{r}, (Object[])r.remove(new IPAddressRange("192.168.1.22", "192.168.1.27")));
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{new IPAddressRange("192.168.1.15", "192.168.1.20")}, (Object[])r.remove(new IPAddressRange("192.168.1.5", "192.168.1.14")));
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{new IPAddressRange("192.168.1.10", "192.168.1.14")}, (Object[])r.remove(new IPAddressRange("192.168.1.15", "192.168.1.24")));
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{new IPAddressRange("192.168.1.10", "192.168.1.14"), new IPAddressRange("192.168.1.16", "192.168.1.20")}, (Object[])r.remove(new IPAddressRange("192.168.1.15", "192.168.1.15")));
    }

    @Test
    public void testListAdd() {
        IPAddressRange r = new IPAddressRange("192.168.1.10", "192.168.1.20");
        IPAddressRangeSet ranges = new IPAddressRangeSet();
        ranges.add(r);
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{r}, (Object[])ranges.toArray());
        IPAddressRange s = new IPAddressRange("192.168.1.30", "192.168.1.40");
        ranges.add(s);
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{r, s}, (Object[])ranges.toArray());
        IPAddressRange t = new IPAddressRange("192.168.1.2", "192.168.1.8");
        ranges.add(t);
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{t, r, s}, (Object[])ranges.toArray());
        IPAddressRange u = new IPAddressRange("192.168.1.22", "192.168.1.28");
        ranges.add(u);
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{t, r, u, s}, (Object[])ranges.toArray());
        ranges.add(new IPAddressRange("192.168.1.18", "192.168.1.24"));
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{t, new IPAddressRange("192.168.1.10", "192.168.1.28"), s}, (Object[])ranges.toArray());
        ranges.add(new IPAddressRange("192.168.1.9", "192.168.1.9"));
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{new IPAddressRange("192.168.1.2", "192.168.1.28"), s}, (Object[])ranges.toArray());
    }

    @Test
    public void testListRemove() {
        IPAddressRange r = new IPAddressRange("192.168.1.1", "192.168.1.100");
        IPAddressRangeSet ranges = new IPAddressRangeSet();
        ranges.add(r);
        IPAddressRange s = new IPAddressRange("192.168.1.30", "192.168.1.40");
        ranges.remove(s);
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{new IPAddressRange("192.168.1.1", "192.168.1.29"), new IPAddressRange("192.168.1.41", "192.168.1.100")}, (Object[])ranges.toArray());
        IPAddressRange t = new IPAddressRange("192.168.1.20", "192.168.1.35");
        ranges.remove(t);
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{new IPAddressRange("192.168.1.1", "192.168.1.19"), new IPAddressRange("192.168.1.41", "192.168.1.100")}, (Object[])ranges.toArray());
        IPAddressRange u = new IPAddressRange("192.168.1.35", "192.168.1.50");
        ranges.remove(u);
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{new IPAddressRange("192.168.1.1", "192.168.1.19"), new IPAddressRange("192.168.1.51", "192.168.1.100")}, (Object[])ranges.toArray());
        ranges.remove(new IPAddressRange("192.168.1.60", "192.168.1.70"));
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{new IPAddressRange("192.168.1.1", "192.168.1.19"), new IPAddressRange("192.168.1.51", "192.168.1.59"), new IPAddressRange("192.168.1.71", "192.168.1.100")}, (Object[])ranges.toArray());
        ranges.remove(new IPAddressRange("192.168.1.10", "192.168.1.80"));
        Assert.assertArrayEquals((Object[])new IPAddressRange[]{new IPAddressRange("192.168.1.1", "192.168.1.9"), new IPAddressRange("192.168.1.81", "192.168.1.100")}, (Object[])ranges.toArray());
    }

    @Test
    public final void testModifySpecificInDef() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>192.168.0.5</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition read-community=\"abc\">\n        <specific>192.168.0.5</specific>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setCommunityString("abc");
        info.setFirstIPAddress("192.168.0.5");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public final void testModifySpecificInDefIPv6() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>2001:db8::10</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition read-community=\"abc\">\n        <specific>2001:db8::10</specific>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setCommunityString("abc");
        info.setFirstIPAddress("2001:db8::10");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public final void testAddAdjacentSpecificToDef() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>192.168.0.5</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.0.5\" end=\"192.168.0.6\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.0.6");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public final void testAddAdjacentSpecificToDefIPv6() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>2001:db8::10</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"2001:db8::10\" end=\"2001:db8::11\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("2001:db8::11");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public final void testAddSpecificBetweenAdjacentsSpecifics() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>192.168.0.5</specific>\n        <specific>192.168.0.7</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.0.5\" end=\"192.168.0.7\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.0.6");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public final void testAddSpecificBetweenAdjacentsSpecificsMostlyZeros() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>0.0.0.5</specific>\n        <specific>0.0.0.7</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"0.0.0.5\" end=\"0.0.0.7\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("0.0.0.6");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public final void testAddSpecificBetweenAdjacentsSpecificsIPv6() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>::5</specific>\n        <specific>::7</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"::5\" end=\"::7\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("::6");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public final void testAddSpecificBetweenAdjacentSpecificAndRange() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.0.7\" end=\"192.168.0.9\"/>\n        <specific>192.168.0.5</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.0.5\" end=\"192.168.0.9\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.0.6");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testSplitRange() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.100\" end=\"192.168.1.200\"/>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.100\" end=\"192.168.1.119\"/>\n        <range begin=\"192.168.1.131\" end=\"192.168.1.200\"/>\n    </definition>\n    <definition version=\"v1\">\n        <range begin=\"192.168.1.120\" end=\"192.168.1.130\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.120");
        info.setLastIPAddress("192.168.1.130");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testRemoveSpecificFromRange() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.100\" end=\"192.168.1.200\"/>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.100\" end=\"192.168.1.119\"/>\n        <range begin=\"192.168.1.121\" end=\"192.168.1.200\"/>\n    </definition>\n    <definition version=\"v1\">\n        <specific>192.168.1.120</specific>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.120");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testRemoveSpecificNearEndOfRange() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.100\" end=\"192.168.1.200\"/>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.100\" end=\"192.168.1.198\"/>\n        <specific>192.168.1.200</specific>\n    </definition>\n    <definition version=\"v1\">\n        <specific>192.168.1.199</specific>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.199");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testRemoveSpecificAtEndOfRange() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.100\" end=\"192.168.1.200\"/>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.100\" end=\"192.168.1.199\"/>\n    </definition>\n    <definition version=\"v1\">\n        <specific>192.168.1.200</specific>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.200");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testRecombineSpecificIntoRange() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.14\"/>\n        <range begin=\"192.168.1.16\" end=\"192.168.1.40\"/>\n    </definition>\n    <definition version=\"v1\">\n        <specific>192.168.1.15</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.40\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.1.15");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testRemoveSpecificInSeparateDefWithNewRange() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>192.168.1.30</specific>\n        <specific>10.1.1.1</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>10.1.1.1</specific>\n    </definition>\n    <definition version=\"v1\">\n        <range begin=\"192.168.1.15\" end=\"192.168.1.35\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.15");
        info.setLastIPAddress("192.168.1.35");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testRemoveTrivialEntry() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>192.168.1.30</specific>\n        <specific>10.1.1.1</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>10.1.1.1</specific>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setFirstIPAddress("192.168.1.30");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testInvalidRange() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n   <definition version=\"v2c\">\n       <range begin=\"192.168.0.3\" end=\"192.168.0.100\"/>   </definition>\n\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.0.3");
        info.setLastIPAddress("192.168.0.1");
        try {
            SnmpPeerFactory.getInstance().define(info);
            Assert.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNewSpecifcSameAsBeginInOldDef() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.0.3\" end=\"192.168.0.100\"/>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.0.4\" end=\"192.168.0.100\"/>\n    </definition>\n    <definition version=\"v1\">\n        <specific>192.168.0.3</specific>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.0.3");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testOverlapsTwoRanges() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.20\"/>\n        <range begin=\"192.168.1.30\" end=\"192.168.1.40\"/>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.14\"/>\n        <range begin=\"192.168.1.36\" end=\"192.168.1.40\"/>\n    </definition>\n    <definition version=\"v1\">\n        <range begin=\"192.168.1.15\" end=\"192.168.1.35\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.15");
        info.setLastIPAddress("192.168.1.35");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    public void testOverlapsTwoRangesAndCombinesThem(String firstIp, String lastIp) throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.20\"/>\n        <range begin=\"192.168.1.30\" end=\"192.168.1.40\"/>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.40\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress(firstIp);
        info.setLastIPAddress(lastIp);
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testCombineOverlappingRanges() throws Exception {
        this.testOverlapsTwoRangesAndCombinesThem("192.168.1.15", "192.168.1.35");
        this.testOverlapsTwoRangesAndCombinesThem("192.168.1.10", "192.168.1.35");
        this.testOverlapsTwoRangesAndCombinesThem("192.168.1.20", "192.168.1.35");
        this.testOverlapsTwoRangesAndCombinesThem("192.168.1.21", "192.168.1.35");
        this.testOverlapsTwoRangesAndCombinesThem("192.168.1.15", "192.168.1.40");
        this.testOverlapsTwoRangesAndCombinesThem("192.168.1.21", "192.168.1.30");
        this.testOverlapsTwoRangesAndCombinesThem("192.168.1.21", "192.168.1.29");
        this.testOverlapsTwoRangesAndCombinesThem("192.168.1.10", "192.168.1.40");
    }

    @Test
    public void testRecombineRanges() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.14\"/>\n        <range begin=\"192.168.1.36\" end=\"192.168.1.40\"/>\n    </definition>\n    <definition version=\"v1\">\n        <range begin=\"192.168.1.15\" end=\"192.168.1.35\"/>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.40\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.1.15");
        info.setLastIPAddress("192.168.1.35");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public void testRecombineRangesNonAdjacentRange() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.14\"/>\n        <range begin=\"192.168.1.36\" end=\"192.168.1.40\"/>\n    </definition>\n    <definition version=\"v1\">\n        <range begin=\"192.168.1.15\" end=\"192.168.1.35\"/>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <range begin=\"192.168.1.10\" end=\"192.168.1.40\"/>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.1.12");
        info.setLastIPAddress("192.168.1.38");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    public final void testAddNewSpecificToConfig() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>192.168.0.5</specific>\n        <specific>192.168.0.6</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>192.168.0.5</specific>\n    </definition>\n    <definition version=\"v1\">\n        <specific>192.168.0.6</specific>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.0.6");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    @Ignore(value="This is no longer really valid since we don't have to optimize in a separate pass")
    public final void testOptimizeAllDefs() throws IOException {
        String snmpConfigXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>192.168.0.5</specific>\n    </definition>\n    <definition read-community=\"opennmsrules\">\n        <range begin=\"192.168.100.1\" end=\"192.168.100.254\"/>\n        <range begin=\"192.168.101.1\" end=\"192.168.101.254\"/>\n        <range begin=\"192.168.102.1\" end=\"192.168.102.254\"/>\n        <range begin=\"192.168.103.1\" end=\"192.168.103.254\"/>\n        <range begin=\"192.168.104.1\" end=\"192.168.104.254\"/>\n        <range begin=\"192.168.105.1\" end=\"192.168.105.254\"/>\n        <range begin=\"192.168.106.1\" end=\"192.168.106.254\"/>\n        <range begin=\"192.168.107.1\" end=\"192.168.107.254\"/>\n        <range begin=\"192.168.0.1\" end=\"192.168.0.10\"/>\n    </definition>\n    <definition read-community=\"opennmsrules2\">\n        <range begin=\"192.168.100.0\" end=\"192.168.100.255\"/>\n        <range begin=\"192.168.101.0\" end=\"192.168.101.255\"/>\n        <range begin=\"192.168.102.0\" end=\"192.168.102.255\"/>\n        <range begin=\"192.168.103.0\" end=\"192.168.103.255\"/>\n        <range begin=\"192.168.104.0\" end=\"192.168.104.255\"/>\n        <range begin=\"192.168.105.0\" end=\"192.168.105.255\"/>\n        <range begin=\"192.168.106.0\" end=\"192.168.106.255\"/>\n        <range begin=\"192.168.107.0\" end=\"192.168.107.255\"/>\n        <range begin=\"192.168.0.1\" end=\"192.168.0.10\"/>\n    </definition>\n    <definition read-community=\"splice-test\" version=\"v2c\">\n        <range begin=\"10.1.2.1\" end=\"10.1.2.100\"/>\n        <range begin=\"11.1.2.1\" end=\"11.1.2.100\"/>\n        <range begin=\"12.1.2.1\" end=\"12.1.2.100\"/>\n        <specific>10.1.1.1</specific>\n        <specific>10.1.1.2</specific>\n        <specific>10.1.1.3</specific>\n        <specific>10.1.1.5</specific>\n        <specific>10.1.1.6</specific>\n        <specific>10.1.1.10</specific>\n    </definition>\n    <definition read-community=\"splice2-test\">\n        <range begin=\"10.1.1.11\" end=\"10.1.1.100\"/>\n        <range begin=\"11.1.2.1\" end=\"11.1.2.100\"/>\n        <range begin=\"12.1.2.1\" end=\"12.1.2.100\"/>\n        <specific>10.1.1.10</specific>\n    </definition>\n    <definition read-community=\"splice3-test\">\n        <range begin=\"10.1.1.11\" end=\"10.1.1.100\"/>\n        <range begin=\"11.1.2.1\" end=\"11.1.2.1\"/>\n        <range begin=\"12.1.2.1\" end=\"12.1.2.1\"/>\n        <specific>10.1.1.10</specific>\n        <specific>10.1.1.12</specific>\n    </definition>\n</snmp-config>\n";
        String expectedConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> standalone=\"yes\"\n<snmp-config retry=\"3\" timeout=\"800\" read-community=\"public\" write-community=\"private\" xmlns=\"http://xmlns.opennms.org/xsd/config/snmp\">\n    <definition version=\"v2c\">\n        <specific>192.168.0.5</specific>\n    </definition>\n    <definition read-community=\"opennmsrules\">\n        <range begin=\"192.168.0.1\" end=\"192.168.0.10\"/>\n        <range begin=\"192.168.100.1\" end=\"192.168.100.254\"/>\n        <range begin=\"192.168.101.1\" end=\"192.168.101.254\"/>\n        <range begin=\"192.168.102.1\" end=\"192.168.102.254\"/>\n        <range begin=\"192.168.103.1\" end=\"192.168.103.254\"/>\n        <range begin=\"192.168.104.1\" end=\"192.168.104.254\"/>\n        <range begin=\"192.168.105.1\" end=\"192.168.105.254\"/>\n        <range begin=\"192.168.106.1\" end=\"192.168.106.254\"/>\n        <range begin=\"192.168.107.1\" end=\"192.168.107.254\"/>\n    </definition>\n    <definition read-community=\"opennmsrules2\">\n        <range begin=\"192.168.0.1\" end=\"192.168.0.10\"/>\n        <range begin=\"192.168.100.0\" end=\"192.168.107.255\"/>\n    </definition>\n    <definition read-community=\"splice-test\" version=\"v2c\">\n        <range begin=\"10.1.1.1\" end=\"10.1.1.3\"/>\n        <range begin=\"10.1.1.5\" end=\"10.1.1.6\"/>\n        <range begin=\"10.1.2.1\" end=\"10.1.2.100\"/>\n        <range begin=\"11.1.2.1\" end=\"11.1.2.100\"/>\n        <range begin=\"12.1.2.1\" end=\"12.1.2.100\"/>\n        <specific>10.1.1.10</specific>\n    </definition>\n    <definition read-community=\"splice2-test\">\n        <range begin=\"10.1.1.10\" end=\"10.1.1.100\"/>\n        <range begin=\"11.1.2.1\" end=\"11.1.2.100\"/>\n        <range begin=\"12.1.2.1\" end=\"12.1.2.100\"/>\n    </definition>\n    <definition read-community=\"splice3-test\">\n        <range begin=\"10.1.1.10\" end=\"10.1.1.100\"/>\n        <specific>11.1.2.1</specific>\n        <specific>12.1.2.1</specific>\n    </definition>\n</snmp-config>\n";
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(snmpConfigXml));
        Assert.assertEquals((Object)snmpConfigXml, (Object)SnmpPeerFactory.marshallConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        SnmpConfig config = SnmpPeerFactory.getSnmpConfig();
        Assert.assertEquals((long)6L, (long)config.getDefinitionCount());
        info.setCommunityString("opennmsrules2");
        new SnmpConfigManager(config).optimizeAllDefs();
        String actualConfig = SnmpPeerFactory.marshallConfig();
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    @Test
    @Ignore
    public void testAddSpecificToBigFile() throws Exception {
        FileSystemResource res = new FileSystemResource("/Users/brozow/big-snmp-config.xml");
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Resource)res));
        SnmpEventInfo info = new SnmpEventInfo();
        info.setCommunityString("th3l04n3r");
        info.setFirstIPAddress("192.168.1.15");
        info.setLastIPAddress("192.168.1.35");
        SnmpPeerFactory.getInstance().define(info);
        String actualConfig = SnmpPeerFactory.marshallConfig();
        System.err.println(actualConfig);
    }

    @Test
    @Ignore
    public void testConfigTheHeckOutOfIt() throws Exception {
        FileSystemResource configResource = new FileSystemResource("/Users/brozow/big-snmp-config.xml");
        FileSystemResource events = new FileSystemResource("/Users/brozow/support/NEN/palin/wave-events.txt");
        File configDir = new File("/Users/brozow/support/NEN/palin/configs");
        configDir.mkdirs();
        SnmpEventInfo[] updates = this.readEventInfo(events.getInputStream());
        Assert.assertNotNull((Object)updates);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Resource)configResource));
        int index = 0;
        for (SnmpEventInfo update : updates) {
            try {
                File dir = new File(configDir, String.format("%03d", index));
                dir.mkdirs();
                SnmpPeerFactory.saveToFile((File)new File(dir, "pre-config.xml"));
                SnmpPeerFactory.getInstance().define(update);
                File saveUpdate = new File(dir, "update");
                FileUtils.writeStringToFile((File)saveUpdate, (String)String.format("%s %s %s\n", update.getFirstIPAddress(), update.getLastIPAddress(), update.getCommunityString()));
                SnmpPeerFactory.saveToFile((File)new File(dir, "post-config.xml"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)String.format("Applying update with index %d change community string for %s  to %s failed.", index, update.getFirstIPAddress(), update.getCommunityString()));
            }
            ++index;
        }
        String actualConfig = SnmpPeerFactory.marshallConfig();
        System.err.println(actualConfig);
    }

    private SnmpEventInfo[] readEventInfo(InputStream in) throws UnknownHostException {
        ArrayList<SnmpEventInfo> updates = new ArrayList<SnmpEventInfo>(500);
        Scanner s = new Scanner(in);
        int lineCount = 0;
        while (s.hasNextLine()) {
            s.findInLine("\\s*firstIPAddress=([0-9.]+) communityString=([^ ]*) lastIPAddress=([0-9.]+)\\s*");
            MatchResult result = s.match();
            System.out.printf("%d: %s - %s: %s\n", ++lineCount, result.group(1), result.group(3), result.group(2));
            SnmpEventInfo info = new SnmpEventInfo();
            info.setFirstIPAddress(result.group(1));
            info.setLastIPAddress(result.group(3));
            info.setCommunityString(result.group(2));
            updates.add(info);
            s.nextLine();
        }
        s.close();
        return updates.toArray(new SnmpEventInfo[0]);
    }
}

