/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sql.DataSource;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.PollerConfigManager;
import org.opennms.netmgt.config.poller.Downtime;
import org.opennms.netmgt.config.poller.Filter;
import org.opennms.netmgt.config.poller.IncludeRange;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Rrd;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.core.io.ClassPathResource;

public class PollerConfigFactoryTest
extends TestCase {
    public static final String POLLER_CONFIG = "\n<poller-configuration\n   threads=\"10\"\n   nextOutageId=\"SELECT nextval('outageNxtId')\"\n   serviceUnresponsiveEnabled=\"false\">\n   <node-outage status=\"on\" pollAllIfNoCriticalServiceDefined=\"true\"></node-outage>\n   <package name=\"default\">\n       <filter>IPADDR IPLIKE *.*.*.*</filter>\n       <rrd step = \"300\">\n           <rra>RRA:AVERAGE:0.5:1:2016</rra>\n           <rra>RRA:AVERAGE:0.5:12:4464</rra>\n           <rra>RRA:MIN:0.5:12:4464</rra>\n           <rra>RRA:MAX:0.5:12:4464</rra>\n       </rrd>\n       <service name=\"ICMP\" interval=\"300000\">\n         <parameter key=\"test-key\" value=\"test-value\"/>\n         <parameter key=\"any-parm\">            <config>              <data/>            </config>         </parameter>       </service>\n       <downtime begin=\"0\" end=\"30000\"/>\n   </package>\n   <monitor service=\"ICMP\" class-name=\"org.opennms.netmgt.poller.monitors.LdapMonitor\"/>\n</poller-configuration>\n";

    public static void main(String[] args) {
        TestRunner.run(PollerConfigFactoryTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        ClassPathResource dbConfig = new ClassPathResource("/org/opennms/netmgt/config/test-database-schema.xml");
        InputStream s = dbConfig.getInputStream();
        DatabaseSchemaConfigFactory dscf = new DatabaseSchemaConfigFactory(s);
        s.close();
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)dscf);
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "Router");
        network.addInterface("192.168.1.1");
        network.addService("ICMP");
        network.addService("SMTP");
        network.addInterface("192.168.1.2");
        network.addService("ICMP");
        network.addService("SMTP");
        network.addNode(2, "Server");
        network.addInterface("192.168.1.3");
        network.addService("ICMP");
        network.addService("HTTP");
        network.addNode(3, "Firewall");
        network.addInterface("192.168.1.4");
        network.addService("SMTP");
        network.addService("HTTP");
        network.addInterface("192.168.1.5");
        network.addService("SMTP");
        network.addService("HTTP");
        network.addInterface("192.169.1.5");
        network.addService("SMTP");
        network.addService("HTTP");
        network.addNode(4, "TestNode121");
        network.addInterface("123.12.123.121");
        network.addService("HTTP");
        network.addNode(5, "TestNode122");
        network.addInterface("123.12.123.122");
        network.addService("HTTP");
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
    }

    protected void tearDown() throws Exception {
        DataSourceFactory.setInstance(null);
        super.tearDown();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public void testPollerConfigFactory() throws Exception {
        TestPollerConfigManager factory = new TestPollerConfigManager(POLLER_CONFIG, "localhost", false);
        PollerConfigFactoryTest.assertNull((Object)factory.getPackage("TestPkg"));
        Package pkg = new Package();
        pkg.setName("TestPkg");
        Filter filter = new Filter();
        filter.setContent("IPADDR IPLIKE *.*.*.*");
        pkg.setFilter(filter);
        Rrd rrd = new Rrd();
        rrd.setStep(300);
        rrd.addRra("RRA:AVERAGE:0.5:1:2016");
        pkg.setRrd(rrd);
        Service svc = new Service();
        svc.setName("TestService");
        svc.setInterval(300000L);
        pkg.addService(svc);
        Downtime dt = new Downtime();
        dt.setBegin(0L);
        pkg.addDowntime(dt);
        IncludeRange inclde = new IncludeRange();
        inclde.setBegin("192.169.0.0");
        inclde.setEnd("192.169.255.255");
        pkg.addIncludeRange(inclde);
        factory.addPackage(pkg);
        factory.save();
        PollerConfigFactoryTest.assertNotNull((Object)factory.getPackage("TestPkg"));
        TestPollerConfigManager newFactory = new TestPollerConfigManager(factory.getXml(), "localhost", false);
        Package p = newFactory.getPackage("TestPkg");
        PollerConfigFactoryTest.assertNotNull((Object)p);
        PollerConfigFactoryTest.assertTrue((boolean)newFactory.isInterfaceInPackage("192.169.1.5", p));
        PollerConfigFactoryTest.assertFalse((boolean)newFactory.isInterfaceInPackage("192.168.1.5", p));
    }

    public void testInterfaceInPackage() throws Exception {
        TestPollerConfigManager factory = new TestPollerConfigManager(POLLER_CONFIG, "localhost", false);
        Package pkg = factory.getPackage("default");
        PollerConfigFactoryTest.assertNotNull((String)"Unable to find pkg default", (Object)pkg);
        PollerConfigFactoryTest.assertTrue((String)"Expected 192.168.1.1 to be in the package", (boolean)factory.isInterfaceInPackage("192.168.1.1", pkg));
    }

    public void testSpecific() throws Exception {
        TestPollerConfigManager factory = new TestPollerConfigManager(POLLER_CONFIG, "localhost", false);
        PollerConfigFactoryTest.assertNull((Object)factory.getPackage("TestPkg"));
        Package pkg = new Package();
        pkg.setName("TestPkg");
        Filter filter = new Filter();
        filter.setContent("IPADDR != '0.0.0.0'");
        pkg.setFilter(filter);
        Rrd rrd = new Rrd();
        rrd.setStep(300);
        rrd.addRra("RRA:AVERAGE:0.5:1:2016");
        pkg.setRrd(rrd);
        Service svc = new Service();
        svc.setName("TestService");
        svc.setInterval(300000L);
        pkg.addService(svc);
        Downtime dt = new Downtime();
        dt.setBegin(0L);
        pkg.addDowntime(dt);
        pkg.addSpecific("123.12.123.121");
        pkg.addSpecific("123.12.123.122");
        factory.addPackage(pkg);
        factory.save();
        PollerConfigFactoryTest.assertNotNull((Object)factory.getPackage("TestPkg"));
        TestPollerConfigManager newFactory = new TestPollerConfigManager(factory.getXml(), "localhost", false);
        Package p = newFactory.getPackage("TestPkg");
        PollerConfigFactoryTest.assertNotNull((Object)p);
        System.out.println(factory.getXml());
        PollerConfigFactoryTest.assertTrue((String)"Expect 123.12.123.121 to be part of the package", (boolean)newFactory.isInterfaceInPackage("123.12.123.121", p));
        PollerConfigFactoryTest.assertTrue((String)"Expect 123.12.123.122 to be part of the package", (boolean)newFactory.isInterfaceInPackage("123.12.123.122", p));
        PollerConfigFactoryTest.assertFalse((String)"Expected 192.168.1.1 to be excluded from the package", (boolean)newFactory.isInterfaceInPackage("192.168.1.1", p));
    }

    static class TestPollerConfigManager
    extends PollerConfigManager {
        private String m_xml;

        public TestPollerConfigManager(String xml, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
            super((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), localServer, verifyServer);
            this.save();
        }

        public void update() throws IOException, MarshalException, ValidationException {
            this.m_config = (PollerConfiguration)CastorUtils.unmarshal(PollerConfiguration.class, (InputStream)new ByteArrayInputStream(this.m_xml.getBytes("UTF-8")));
            this.setUpInternalData();
        }

        protected void saveXml(String xml) throws IOException {
            this.m_xml = xml;
        }

        public String getXml() {
            return this.m_xml;
        }
    }
}

