/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabaseAware;
import org.opennms.netmgt.dao.support.JdbcFilterDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.notifd.mock.MockNotifdConfigManager;
import org.opennms.test.ConfigurationTestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class NotificationManagerTest
implements TemporaryDatabaseAware<TemporaryDatabase> {
    @Autowired
    private DataSource m_dataSource;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_serviceDao;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private CategoryDao m_categoryDao;
    private NotificationManagerImpl m_notificationManager;
    private NotifdConfigManager m_configManager;
    private TemporaryDatabase m_database;

    public void setTemporaryDatabase(TemporaryDatabase database) {
        this.m_database = database;
    }

    @Before
    public void setUp() throws Exception {
        DatabaseSchemaConfigFactory.init();
        JdbcFilterDao jdbcFilterDao = new JdbcFilterDao();
        jdbcFilterDao.setDataSource((DataSource)this.m_database);
        jdbcFilterDao.setDatabaseSchemaConfigFactory(DatabaseSchemaConfigFactory.getInstance());
        jdbcFilterDao.afterPropertiesSet();
        FilterDaoFactory.setInstance((FilterDao)jdbcFilterDao);
        this.m_configManager = new MockNotifdConfigManager(ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)this, (String)"notifd-configuration.xml", (String[][])new String[0][]));
        this.m_notificationManager = new NotificationManagerImpl(this.m_configManager, this.m_dataSource);
        OnmsDistPoller distPoller = new OnmsDistPoller("localhost", "127.0.0.1");
        OnmsCategory category1 = new OnmsCategory("CategoryOne");
        this.m_categoryDao.save((Object)category1);
        OnmsCategory category2 = new OnmsCategory("CategoryTwo");
        this.m_categoryDao.save((Object)category2);
        OnmsCategory category3 = new OnmsCategory("CategoryThree");
        this.m_categoryDao.save((Object)category3);
        OnmsCategory category4 = new OnmsCategory("CategoryFour");
        this.m_categoryDao.save((Object)category4);
        this.m_categoryDao.flush();
        OnmsServiceType serviceType = new OnmsServiceType("HTTP");
        this.m_serviceTypeDao.save((Object)serviceType);
        OnmsNode node = new OnmsNode(distPoller, "node 1");
        node.addCategory(category1);
        node.addCategory(category2);
        node.addCategory(category3);
        OnmsIpInterface ipInterface = new OnmsIpInterface("192.168.1.1", node);
        OnmsMonitoredService service = new OnmsMonitoredService(ipInterface, serviceType);
        this.m_nodeDao.save((Object)node);
        node = new OnmsNode(distPoller, "node 2");
        node.addCategory(category1);
        node.addCategory(category2);
        node.addCategory(category4);
        this.m_nodeDao.save((Object)node);
        ipInterface = new OnmsIpInterface("192.168.1.1", node);
        this.m_ipInterfaceDao.save((Object)ipInterface);
        service = new OnmsMonitoredService(ipInterface, serviceType);
        this.m_serviceDao.save((Object)service);
        ipInterface = new OnmsIpInterface("0.0.0.0", node);
        this.m_ipInterfaceDao.save((Object)ipInterface);
        node = new OnmsNode(distPoller, "node 3");
        this.m_nodeDao.save((Object)node);
        ipInterface = new OnmsIpInterface("192.168.1.2", node);
        this.m_ipInterfaceDao.save((Object)ipInterface);
        service = new OnmsMonitoredService(ipInterface, serviceType);
        this.m_serviceDao.save((Object)service);
        node = new OnmsNode(distPoller, "node 4");
        this.m_nodeDao.save((Object)node);
        ipInterface = new OnmsIpInterface("192.168.1.3", node);
        this.m_ipInterfaceDao.save((Object)ipInterface);
        node = new OnmsNode(distPoller, "node 5");
        this.m_nodeDao.save((Object)node);
        this.m_nodeDao.flush();
        this.m_ipInterfaceDao.flush();
        this.m_serviceDao.flush();
        this.m_serviceTypeDao.flush();
        this.m_categoryDao.flush();
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNoElement() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 0, null, null, "(ipaddr IPLIKE *.*.*.*)", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNoNodeIdWithIpAddr() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 0, "192.168.1.1", null, "(ipaddr == '192.168.1.1')", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNoNodeIdWithIpAddrNotInDb() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 0, "192.168.1.2", null, "(ipaddr == '192.168.1.1')", false);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNoNodeIdWithService() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 0, null, "HTTP", "(ipaddr == '192.168.1.1')", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testRuleBogus() {
        try {
            this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(aklsdfjweklj89jaikj)", false);
            Assert.fail((String)"Expected exception to be thrown!");
        }
        catch (FilterParseException filterParseException) {
            // empty catch block
        }
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIplikeAllStars() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(ipaddr IPLIKE *.*.*.*)", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNodeOnlyMatch() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, null, null, "(ipaddr == '192.168.1.1')", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNodeOnlyMatchZeroesIpAddr() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "0.0.0.0", null, "(ipaddr == '192.168.1.1')", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNodeOnlyNoMatch() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 3, null, null, "(ipaddr == '192.168.1.1')", false);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testWrongNodeId() throws InterruptedException {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 2, "192.168.1.1", "HTTP", "(nodeid == 1)", false);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpAddrSpecificPass() throws InterruptedException {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", null, "(ipaddr == '192.168.1.1')", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpAddrSpecificFail() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", null, "(ipaddr == '192.168.1.2')", false);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpAddrServiceSpecificPass() throws InterruptedException {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(ipaddr == '192.168.1.1')", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpAddrServiceSpecificFail() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(ipaddr == '192.168.1.2')", false);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpAddrServiceSpecificWrongService() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "ICMP", "(ipaddr == '192.168.1.1')", false);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpAddrServiceSpecificWrongIP() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.2", "HTTP", "(ipaddr == '192.168.1.1')", false);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testMultipleCategories() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 1, "192.168.1.1", "HTTP", "(catincCategoryOne) & (catincCategoryTwo) & (catincCategoryThree)", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testMultipleCategoriesNotMember() throws InterruptedException {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 2, "192.168.1.1", "HTTP", "(catincCategoryOne) & (catincCategoryTwo) & (catincCategoryThree)", false);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpAddrMatchWithNoServiceOnInterface() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 4, null, null, "(ipaddr == '192.168.1.3')", true);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNodeMatchWithNoInterfacesOnNode() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 5, null, null, "(nodeId == 5)", false);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testRuleWithOrNoMatch() {
        this.doTestNodeInterfaceServiceWithRule("node/interface/service match", 3, "192.168.1.2", "HTTP", "(nodelabel=='node 1') | (nodelabel=='node 2')", false);
    }

    private void doTestNodeInterfaceServiceWithRule(String description, int nodeId, String intf, String svc, String rule, boolean matches) {
        Notification notif = new Notification();
        notif.setName("a notification");
        notif.setRule(rule);
        EventBuilder builder = new EventBuilder("uei.opennms.org/doNotCareAboutTheUei", "Test.Event");
        builder.setNodeid((long)nodeId);
        builder.setInterface(InetAddressUtils.addr((String)intf));
        builder.setService(svc);
        Assert.assertEquals((String)description, (Object)matches, (Object)this.m_notificationManager.nodeInterfaceServiceValid(notif, builder.getEvent()));
    }

    public static class NotificationManagerImpl
    extends NotificationManager {
        protected NotificationManagerImpl(NotifdConfigManager configManager, DataSource dcf) {
            super(configManager, dcf);
        }

        protected void saveXML(String xmlString) throws IOException {
        }

        public void update() throws IOException, MarshalException, ValidationException {
        }
    }
}

