/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.DefaultEventConfDao;
import org.opennms.netmgt.config.EventconfFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.eventconf.AlarmData;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.util.StringUtils;

public class EventconfFactoryTest {
    private static final String knownUEI1 = "uei.opennms.org/internal/capsd/snmpConflictsWithDb";
    private static final String knownLabel1 = "OpenNMS-defined capsd event: snmpConflictsWithDb";
    private static final String knownSubfileUEI1 = "uei.opennms.org/IETF/Bridge/traps/newRoot";
    private static final String knownSubfileLabel1 = "BRIDGE-MIB defined trap event: newRoot";
    private static final String unknownUEI1 = "uei.opennms.org/foo/thisShouldBeAnUnknownUEI";

    @Before
    public void setUp() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.setRelativeHomeDirectory("src/test/resources");
        daoTestConfig.afterPropertiesSet();
        EventconfFactory.init();
    }

    @Test
    public void testIsSecureTagWhenExists() {
        Assert.assertTrue((String)"isSecureTag(\"logmsg\") should be true", (boolean)EventconfFactory.getInstance().isSecureTag("logmsg"));
    }

    @Test
    public void testIsSecureTagWhenDoesNotExist() {
        Assert.assertFalse((String)"isSecureTag(\"foobarbaz\") should be false", (boolean)EventconfFactory.getInstance().isSecureTag("foobarbaz"));
    }

    @Test
    public void testFindByUeiKnown() {
        Event eventConf = EventconfFactory.getInstance().findByUei(knownUEI1);
        Assert.assertNotNull((String)"returned event configuration for known UEI 'uei.opennms.org/internal/capsd/snmpConflictsWithDb' should not be null", (Object)eventConf);
        Assert.assertEquals((String)"UEI", (Object)knownUEI1, (Object)eventConf.getUei());
        Assert.assertEquals((String)"label", (Object)knownLabel1, (Object)eventConf.getEventLabel());
    }

    @Test
    public void testFindByUeiUnknown() {
        Event eventConf = EventconfFactory.getInstance().findByUei(unknownUEI1);
        Assert.assertNull((String)"returned event configuration for unknown UEI 'uei.opennms.org/foo/thisShouldBeAnUnknownUEI' should be null", (Object)eventConf);
    }

    @Test
    public void testFindByEventUeiKnown() {
        EventBuilder bldr = new EventBuilder(knownUEI1, "testFindByEventUeiKnown");
        Event eventConf = EventconfFactory.getInstance().findByEvent(bldr.getEvent());
        Assert.assertNotNull((String)"returned event configuration for event with known UEI 'uei.opennms.org/internal/capsd/snmpConflictsWithDb' should not be null", (Object)eventConf);
        Assert.assertEquals((String)"UEI", (Object)bldr.getEvent().getUei(), (Object)eventConf.getUei());
    }

    @Test
    public void testFindByEventUnknown() {
        EventBuilder bldr = new EventBuilder(unknownUEI1, "testFindByEventUnknown");
        Event eventConf = EventconfFactory.getInstance().findByEvent(bldr.getEvent());
        Assert.assertNull((String)"returned event configuration for event with unknown UEI 'uei.opennms.org/foo/thisShouldBeAnUnknownUEI' should be null", (Object)eventConf);
    }

    @Test
    public void testGetEventsByLabel() {
        List<Event> events = this.getEventsByLabel();
        ArrayList<String> beforeSort = new ArrayList<String>(events.size());
        for (Event e : events) {
            String label = e.getEventLabel();
            beforeSort.add(label);
        }
        ArrayList afterSort = new ArrayList(beforeSort);
        Collections.sort(afterSort, String.CASE_INSENSITIVE_ORDER);
        Assert.assertEquals((long)beforeSort.size(), (long)afterSort.size());
        for (int i = 0; i < beforeSort.size(); ++i) {
            Assert.assertEquals((String)("Lists unequals at index " + i), beforeSort.get(i), afterSort.get(i));
        }
    }

    private List<Event> getEventsByLabel() {
        return EventconfFactory.getInstance().getEventsByLabel();
    }

    @Test
    public void testGetEventByUEI() {
        List result = EventconfFactory.getInstance().getEvents(knownUEI1);
        Assert.assertEquals((String)"Should only be one result", (long)1L, (long)result.size());
        Event firstEvent = (Event)result.get(0);
        Assert.assertEquals((String)"UEI should be uei.opennms.org/internal/capsd/snmpConflictsWithDb", (Object)knownUEI1, (Object)firstEvent.getUei());
        result = EventconfFactory.getInstance().getEvents("uei.opennms.org/internal/capsd/nonexistent");
        Assert.assertNull((String)"Should be null list for non-existent URI", (Object)result);
        result = EventconfFactory.getInstance().getEvents(knownSubfileUEI1);
        Assert.assertEquals((String)"Should only be one result", (long)1L, (long)result.size());
        firstEvent = (Event)result.get(0);
        Assert.assertEquals((String)"UEI should be uei.opennms.org/IETF/Bridge/traps/newRoot", (Object)knownSubfileUEI1, (Object)firstEvent.getUei());
    }

    @Test
    public void testGetEventUEIS() {
        List ueis = EventconfFactory.getInstance().getEventUEIs();
        Assert.assertEquals((String)"Count must be correct", (long)10011L, (long)ueis.size());
        Assert.assertTrue((String)"Must contain known UEI", (boolean)ueis.contains(knownUEI1));
        Assert.assertTrue((String)"Must contain known UEI", (boolean)ueis.contains(knownSubfileUEI1));
    }

    @Test
    public void testGetLabels() {
        Map labels = EventconfFactory.getInstance().getEventLabels();
        Assert.assertEquals((String)"Count must be correct", (long)10011L, (long)labels.size());
        Assert.assertTrue((String)"Must contain known UEI", (boolean)labels.containsKey(knownUEI1));
        Assert.assertEquals((String)"Must have known Label", labels.get(knownUEI1), (Object)knownLabel1);
        Assert.assertTrue((String)"Must contain known UEI", (boolean)labels.containsKey(knownSubfileUEI1));
        Assert.assertEquals((String)"Must have known Label", labels.get(knownSubfileUEI1), (Object)knownSubfileLabel1);
    }

    @Test
    public void testGetLabel() {
        Assert.assertEquals((String)"Must have correct labelOpenNMS-defined capsd event: snmpConflictsWithDb", (Object)knownLabel1, (Object)EventconfFactory.getInstance().getEventLabel(knownUEI1));
        Assert.assertEquals((String)"Must have correct labelBRIDGE-MIB defined trap event: newRoot", (Object)knownSubfileLabel1, (Object)EventconfFactory.getInstance().getEventLabel(knownSubfileUEI1));
    }

    @Test
    public void testGetAlarmType() {
        Event event = new Event();
        AlarmData data = new AlarmData();
        data.setAlarmType(Integer.valueOf(2));
        data.setClearKey("uei.opennms.org.testUei:localhost:1");
        data.setReductionKey("reduceme");
        event.setAlarmData(data);
        int i = event.getAlarmData().getAlarmType();
        Assert.assertEquals((long)2L, (long)i);
        Assert.assertTrue((boolean)"uei.opennms.org.testUei:localhost:1".equals(event.getAlarmData().getClearKey()));
        Assert.assertTrue((boolean)"reduceme".equals(event.getAlarmData().getReductionKey()));
    }

    @Test
    public void testReload() {
        String newUEI = "uei.opennms.org/custom/newTestUEI";
        List events = EventconfFactory.getInstance().getEvents(knownUEI1);
        Event event = (Event)events.get(0);
        event.setUei(newUEI);
        List events2 = EventconfFactory.getInstance().getEvents(newUEI);
        Event event2 = (Event)events2.get(0);
        Assert.assertNotNull((String)"Must have some events", (Object)event2);
        Assert.assertEquals((String)"Must be exactly 1 event", (long)1L, (long)events2.size());
        Assert.assertEquals((String)"uei must be the new one", (Object)newUEI, (Object)event2.getUei());
        try {
            EventconfFactory.getInstance().reload();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Should not have had exception while reloading factory " + e.getMessage()));
        }
        List events3 = EventconfFactory.getInstance().getEvents(knownUEI1);
        Assert.assertNotNull((String)"Must have some events", (Object)events3);
        Assert.assertEquals((String)"Must be exactly 1 event", (long)1L, (long)events3.size());
        Event event3 = (Event)events3.get(0);
        Assert.assertEquals((String)"uei must be the new one", (Object)knownUEI1, (Object)event3.getUei());
        List events4 = EventconfFactory.getInstance().getEvents(newUEI);
        Assert.assertNull((String)"Must be no events by that name", (Object)events4);
    }

    @Test
    public void testLoadConfigurationSingleConfig() throws Exception {
        this.loadConfiguration("singleConfig/eventconf.xml");
    }

    @Test
    public void testLoadConfigurationTwoDeepConfigAbsolutePaths() throws Exception {
        this.loadConfiguration("twoDeepConfig/eventconf.xml");
    }

    @Test
    public void testLoadConfigurationThreeDeepConfig() throws Exception {
        boolean caughtExceptionThatWeWanted = false;
        try {
            this.loadConfiguration("threeDeepConfig/eventconf.xml");
        }
        catch (DataAccessException e) {
            if (e.getMessage().contains("cannot include other configuration files")) {
                caughtExceptionThatWeWanted = true;
            }
            throw e;
        }
        if (!caughtExceptionThatWeWanted) {
            Assert.fail((String)"Did not get the exception that we wanted");
        }
    }

    @Test
    public void testLoadConfigurationTwoDeepConfigWithGlobal() throws Exception {
        boolean caughtExceptionThatWeWanted = false;
        try {
            this.loadConfiguration("twoDeepConfigWithGlobal/eventconf.xml");
        }
        catch (DataAccessException e) {
            if (e.getMessage().contains("cannot have a 'global' element")) {
                caughtExceptionThatWeWanted = true;
            }
            throw e;
        }
        if (!caughtExceptionThatWeWanted) {
            Assert.fail((String)"Did not get the exception that we wanted");
        }
    }

    @Test
    public void testLoadConfigurationRelativeTwoDeepConfig() throws Exception {
        this.loadConfiguration("relativeTwoDeepConfig/eventconf.xml");
    }

    @Test
    public void testLoadConfigurationWithNoFileRelativePathFailure() throws Exception {
        boolean caughtExceptionThatWeWanted = false;
        try {
            this.loadConfiguration("relativeTwoDeepConfig/eventconf.xml", false);
        }
        catch (DataAccessException e) {
            if (e.getMessage().contains("so the relative path cannot be resolved")) {
                caughtExceptionThatWeWanted = true;
            }
            throw e;
        }
        if (!caughtExceptionThatWeWanted) {
            Assert.fail((String)"Did not get the exception that we wanted");
        }
    }

    @Test
    public void testLoadConfigurationWithClassPathInclude() throws Exception {
        this.loadConfiguration("classpathTwoDeep/eventconf.xml", false);
    }

    @Test
    public void testIncludedEventFilesExistAndNoExtras() throws Exception {
        File eventConfFile = ConfigurationTestUtils.getFileForConfigFile((String)"eventconf.xml");
        File eventsDirFile = new File(eventConfFile.getParentFile(), "events");
        Assert.assertTrue((String)("events directory exists at " + eventsDirFile.getAbsolutePath()), (boolean)eventsDirFile.exists());
        Assert.assertTrue((String)("events directory is a directory at " + eventsDirFile.getAbsolutePath()), (boolean)eventsDirFile.isDirectory());
        File[] eventFilesOnDiskArray = eventsDirFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".xml");
            }
        });
        HashSet<File> eventFilesOnDisk = new HashSet<File>(Arrays.asList(eventFilesOnDiskArray));
        InputStream is = ConfigurationTestUtils.getInputStreamForConfigFile((String)"eventconf.xml");
        Events events = (Events)CastorUtils.unmarshal(Events.class, (InputStream)is);
        is.close();
        HashSet<File> eventFilesIncluded = new HashSet<File>(events.getEventFileCollection().size());
        for (String eventFile : events.getEventFileCollection()) {
            eventFilesIncluded.add(new File(eventConfFile.getParentFile(), eventFile));
        }
        HashSet includedNotOnDisk = new HashSet(eventFilesIncluded);
        includedNotOnDisk.removeAll(eventFilesOnDisk);
        if (!includedNotOnDisk.isEmpty()) {
            Assert.fail((String)("Event configuration file " + eventConfFile.getAbsolutePath() + " references included files that could not be found:\n\t" + StringUtils.collectionToDelimitedString(includedNotOnDisk, (String)"\n\t")));
        }
        HashSet<File> onDiskNotIncluded = new HashSet<File>(eventFilesOnDisk);
        onDiskNotIncluded.removeAll(eventFilesIncluded);
        if (!onDiskNotIncluded.isEmpty()) {
            Assert.fail((String)("Events directory " + eventsDirFile.getAbsolutePath() + " contains event files that are not referenced in event configuration file " + eventConfFile.getAbsolutePath() + ":\n\t" + StringUtils.collectionToDelimitedString(onDiskNotIncluded, (String)"\n\t")));
        }
    }

    @Test
    public void testLoadStandardConfiguration() throws Exception {
        DefaultEventConfDao dao = new DefaultEventConfDao();
        dao.setConfigResource((Resource)new FileSystemResource(ConfigurationTestUtils.getFileForConfigFile((String)"eventconf.xml")));
        dao.afterPropertiesSet();
    }

    private void loadConfiguration(String relativeResourcePath) throws DataAccessException, IOException {
        this.loadConfiguration(relativeResourcePath, true);
    }

    private void loadConfiguration(String relativeResourcePath, boolean passFile) throws DataAccessException, IOException {
        DefaultEventConfDao dao = new DefaultEventConfDao();
        if (passFile) {
            URL url = this.getUrlForRelativeResourcePath(relativeResourcePath);
            dao.setConfigResource((Resource)new MockFileSystemResourceWithInputStream(new File(url.getFile()), this.getFilteredInputStreamForConfig(relativeResourcePath)));
        } else {
            dao.setConfigResource((Resource)new InputStreamResource(this.getFilteredInputStreamForConfig(relativeResourcePath)));
        }
        dao.afterPropertiesSet();
    }

    private InputStream getFilteredInputStreamForConfig(String resourceSuffix) throws IOException {
        URL url = this.getUrlForRelativeResourcePath(resourceSuffix);
        return ConfigurationTestUtils.getInputStreamForResourceWithReplacements((Object)this, (String)this.getResourceForRelativePath(resourceSuffix), (String[][])new String[][]{{"\\$\\{install.etc.dir\\}", new File(url.getFile()).getParent()}});
    }

    private URL getUrlForRelativeResourcePath(String resourceSuffix) {
        URL url = this.getClass().getResource(this.getResourceForRelativePath(resourceSuffix));
        Assert.assertNotNull((String)("URL for resource " + this.getResourceForRelativePath(resourceSuffix) + " must not be null"), (Object)url);
        return url;
    }

    private String getResourceForRelativePath(String resourceSuffix) {
        return "/org/opennms/netmgt/config/eventd/" + resourceSuffix;
    }

    private class MockFileSystemResourceWithInputStream
    implements Resource {
        private Resource m_delegate;
        private InputStream m_inputStream;

        public MockFileSystemResourceWithInputStream(File file, InputStream inputStream) {
            this.m_delegate = new FileSystemResource(file);
            this.m_inputStream = inputStream;
        }

        public InputStream getInputStream() {
            return this.m_inputStream;
        }

        public Resource createRelative(String relative) throws IOException {
            return this.m_delegate.createRelative(relative);
        }

        public boolean exists() {
            return this.m_delegate.exists();
        }

        public String getDescription() {
            return this.m_delegate.getDescription();
        }

        public File getFile() throws IOException {
            return this.m_delegate.getFile();
        }

        public String getFilename() {
            return this.m_delegate.getFilename();
        }

        public URL getURL() throws IOException {
            return this.m_delegate.getURL();
        }

        public boolean isOpen() {
            return this.m_delegate.isOpen();
        }

        public URI getURI() throws IOException {
            return this.m_delegate.getURI();
        }

        public boolean isReadable() {
            return this.m_delegate.isReadable();
        }

        public long lastModified() throws IOException {
            return this.m_delegate.lastModified();
        }

        public long contentLength() throws IOException {
            return this.m_delegate.contentLength();
        }
    }
}

