/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.test.ConfigurationTestUtils;
import org.springframework.core.io.Resource;

public class ConfigureSnmpTest
extends TestCase {
    private final int m_startingDefCount = 5;

    protected void setUp() throws Exception {
        super.setUp();
        Resource rsrc = ConfigurationTestUtils.getSpringResourceForResource((Object)((Object)this), (String)"snmp-config-configureSnmpTest.xml");
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(rsrc));
    }

    public void testToIpAddrString() throws UnknownHostException {
        String addr = "192.168.1.1";
        ConfigureSnmpTest.assertEquals((String)addr, (String)InetAddressUtils.toIpAddrString((byte[])InetAddressUtils.addr((String)addr).getAddress()));
    }

    public void testCreateSnmpEventInfo() throws UnknownHostException {
        EventBuilder bldr = this.createConfigureSnmpEventBuilder("192.168.1.1", null);
        this.addCommunityStringToEvent(bldr, "seemore");
        SnmpEventInfo info = new SnmpEventInfo(bldr.getEvent());
        ConfigureSnmpTest.assertNotNull((Object)info);
        ConfigureSnmpTest.assertEquals((String)"192.168.1.1", (String)info.getFirstIPAddress());
        ConfigureSnmpTest.assertNull((Object)info.getLastIPAddress());
        ConfigureSnmpTest.assertTrue((boolean)info.isSpecific());
    }

    public void testSnmpEventInfoClassWithSpecific() throws UnknownHostException {
        String addr = "192.168.0.5";
        EventBuilder bldr = this.createConfigureSnmpEventBuilder("192.168.0.5", null);
        this.addCommunityStringToEvent(bldr, "abc");
        SnmpEventInfo info = new SnmpEventInfo(bldr.getEvent());
        SnmpPeerFactory.getInstance().define(info);
        SnmpAgentConfig agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.0.5"));
        ConfigureSnmpTest.assertEquals((String)InetAddressUtils.str((InetAddress)agent.getAddress()), (String)"192.168.0.5");
        ConfigureSnmpTest.assertEquals((String)"abc", (String)agent.getReadCommunity());
    }

    public void testSnmpEventInfoClassWithRangeReplacingSpecific() throws UnknownHostException {
        String addr1 = "192.168.0.5";
        String addr2 = "192.168.0.7";
        SnmpAgentConfig agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.0.5"));
        ConfigureSnmpTest.assertEquals((int)2, (int)agent.getVersion());
        EventBuilder bldr = this.createConfigureSnmpEventBuilder("192.168.0.5", "192.168.0.7");
        SnmpEventInfo info = new SnmpEventInfo(bldr.getEvent());
        info.setVersion("v2c");
        SnmpPeerFactory.getInstance().define(info);
        agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.0.5"));
        ConfigureSnmpTest.assertEquals((String)InetAddressUtils.str((InetAddress)agent.getAddress()), (String)"192.168.0.5");
        ConfigureSnmpTest.assertEquals((int)2, (int)agent.getVersion());
        ConfigureSnmpTest.assertEquals((int)5, (int)SnmpPeerFactory.getSnmpConfig().getDefinitionCount());
    }

    public void testSnmpEventInfoClassWithRangeSuperSettingDefRanges() throws UnknownHostException {
        String addr1 = "192.168.99.1";
        String addr2 = "192.168.108.254";
        SnmpAgentConfig agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.99.1"));
        ConfigureSnmpTest.assertEquals((int)1, (int)agent.getVersion());
        EventBuilder bldr = this.createConfigureSnmpEventBuilder("192.168.99.1", "192.168.108.254");
        SnmpEventInfo info = new SnmpEventInfo(bldr.getEvent());
        info.setCommunityString("opennmsrules");
        SnmpPeerFactory.getInstance().define(info);
        agent = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)"192.168.99.1"));
        ConfigureSnmpTest.assertEquals((String)InetAddressUtils.str((InetAddress)agent.getAddress()), (String)"192.168.99.1");
        ConfigureSnmpTest.assertEquals((int)1, (int)agent.getVersion());
        ConfigureSnmpTest.assertEquals((int)5, (int)SnmpPeerFactory.getSnmpConfig().getDefinitionCount());
    }

    public void testSplicingSpecificsIntoRanges() throws UnknownHostException {
        ConfigureSnmpTest.assertEquals((int)3, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getRangeCount());
        ConfigureSnmpTest.assertEquals((int)6, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getSpecificCount());
        String specificAddr = "10.1.1.7";
        EventBuilder bldr = this.createConfigureSnmpEventBuilder("10.1.1.7", null);
        SnmpEventInfo info = new SnmpEventInfo(bldr.getEvent());
        info.setCommunityString("splice-test");
        info.setVersion("v2c");
        SnmpPeerFactory.getInstance().define(info);
        ConfigureSnmpTest.assertEquals((int)5, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getRangeCount());
        ConfigureSnmpTest.assertEquals((String)"10.1.1.10", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getSpecific(0));
        ConfigureSnmpTest.assertEquals((int)1, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(2).getSpecificCount());
        ConfigureSnmpTest.assertEquals((int)5, (int)SnmpPeerFactory.getSnmpConfig().getDefinitionCount());
    }

    public void testSplice2() throws UnknownHostException {
        ConfigureSnmpTest.assertEquals((int)3, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getRangeCount());
        ConfigureSnmpTest.assertEquals((int)1, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getSpecificCount());
        ConfigureSnmpTest.assertEquals((String)"10.1.1.10", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getSpecific(0));
        ConfigureSnmpTest.assertEquals((String)"10.1.1.11", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getRange(0).getBegin());
        String specificAddr = "10.1.1.7";
        EventBuilder bldr = this.createConfigureSnmpEventBuilder("10.1.1.7", null);
        SnmpEventInfo info = new SnmpEventInfo(bldr.getEvent());
        info.setCommunityString("splice2-test");
        SnmpPeerFactory.getInstance().define(info);
        ConfigureSnmpTest.assertEquals((int)3, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getRangeCount());
        ConfigureSnmpTest.assertEquals((int)1, (int)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getSpecificCount());
        ConfigureSnmpTest.assertEquals((String)"10.1.1.7", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getSpecific(0));
        ConfigureSnmpTest.assertEquals((String)"10.1.1.10", (String)SnmpPeerFactory.getSnmpConfig().getDefinition(3).getRange(0).getBegin());
        String marshalledConfig = SnmpPeerFactory.marshallConfig();
        ConfigureSnmpTest.assertNotNull((Object)marshalledConfig);
    }

    private EventBuilder createConfigureSnmpEventBuilder(String firstIp, String lastIp) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/configureSNMP", "ConfigureSnmpTest");
        bldr.addParam("firstIPAddress", firstIp);
        bldr.addParam("lastIPAddress", lastIp);
        return bldr;
    }

    private void addCommunityStringToEvent(EventBuilder bldr, String commStr) {
        bldr.addParam("communityString", commStr);
    }
}

