/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.test.ThrowableAnticipator;

public class GenericIndexResourceTypeTest {
    @Test
    public void testNullResourceType() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("resourceType argument must not be null"));
        try {
            new GenericIndexResourceType(null, null, null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testInstantiate() {
        this.instantiate();
    }

    @Test
    public void testGetStorageStrategy() {
        GenericIndexResourceType g = this.instantiate();
        Assert.assertNotNull((String)"storageStrategy should not be null", (Object)g.getStorageStrategy());
        Assert.assertNotNull((String)"persistenceSelectorStrategy should not be null", (Object)g.getPersistenceSelectorStrategy());
    }

    private GenericIndexResourceType instantiate() {
        ResourceType rt = new ResourceType();
        PersistenceSelectorStrategy ps = new PersistenceSelectorStrategy();
        ps.setClazz("org.opennms.netmgt.collectd.PersistAllSelectorStrategy");
        rt.setPersistenceSelectorStrategy(ps);
        StorageStrategy ss = new StorageStrategy();
        ss.setClazz("org.opennms.netmgt.dao.support.IndexStorageStrategy");
        rt.setStorageStrategy(ss);
        return new GenericIndexResourceType(null, null, rt);
    }
}

