/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xmlrpcd.XmlRpcNotifier;
import org.opennms.netmgt.xmlrpcd.XmlrpcAnticipator;
import org.opennms.test.ThrowableAnticipator;

public class XmlRpcNotifierTest {
    private XmlrpcAnticipator m_anticipator;
    private XmlRpcNotifier m_notifier;
    private MockDatabase m_db;
    private MockNetwork m_network;
    private static final String s_uei = "uei!";
    private static final int s_noNodeId = 0;
    static final int s_nodeId = 1;
    private static final String s_nodeLabel = "Router";
    private static final String s_source = XmlRpcNotifierTest.class.getName();
    private static final String s_host = "bar";
    private static final String s_interface = "192.168.1.1";
    private static final String s_service = "ICMP";
    private static final String s_description = "the ICMP service";
    private static final String s_severity = "Critical";
    private static final int s_unknownNodeId = 2;
    private static int s_port = 59000;
    private static final boolean USE_DIFFERENT_PORT_PER_TEST = false;

    @Before
    public void setUp() throws Exception, InterruptedException, IOException {
        MockLogAppender.setupLogging();
        int port = s_port;
        this.m_anticipator = new XmlrpcAnticipator(port);
        this.m_anticipator.anticipateCall("notifyReceivedEvent", "0", "uei.opennms.org/internal/capsd/xmlrpcNotification", "test connection");
        XmlrpcServer remoteServer = new XmlrpcServer();
        remoteServer.setUrl("http://localhost:" + port);
        this.m_notifier = new XmlRpcNotifier(new XmlrpcServer[]{remoteServer}, 1, 1500, false, "");
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService(s_service);
        this.m_network.addNode(1, s_nodeLabel);
        this.m_network.addInterface(s_interface);
        this.m_network.addService(s_service);
        this.m_db = new MockDatabase();
        this.m_db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)this.m_db);
    }

    public void finishUp() {
        this.m_anticipator.verifyAnticipated();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @After
    public void tearDown() throws Exception, InterruptedException, IOException {
        this.m_anticipator.shutdown();
    }

    @Test
    public void testEventListener() {
        this.finishUp();
    }

    @Test
    public void testNotifySuccess() {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        this.m_anticipator.anticipateCall("notifySuccess", String.valueOf(txNo), uei, message);
        Assert.assertTrue((String)"notifier notifySuccess", (boolean)this.m_notifier.notifySuccess(txNo, uei, message));
        this.finishUp();
    }

    @Test
    public void testFailureNotifySuccess() throws Exception {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        this.finishUp();
        this.m_anticipator.shutdown();
        Assert.assertFalse((String)"notifier notifySuccess", (boolean)this.m_notifier.notifySuccess(txNo, uei, message));
    }

    @Test
    public void testNotifyFailure() {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        this.m_anticipator.anticipateCall("notifyFailure", String.valueOf(txNo), uei, message);
        Assert.assertTrue((String)"notifier notifyFailure", (boolean)this.m_notifier.notifyFailure(txNo, uei, message));
        this.finishUp();
    }

    @Test
    public void testFailureNotifyFailure() throws Exception {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        this.finishUp();
        this.m_anticipator.shutdown();
        Assert.assertFalse((String)"notifier notifyFailure", (boolean)this.m_notifier.notifyFailure(txNo, uei, message));
    }

    @Test
    public void testNotifyReceivedEvent() {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        this.m_anticipator.anticipateCall("notifyReceivedEvent", String.valueOf(txNo), uei, message);
        Assert.assertTrue((String)"notifier notifyReceviedEvent", (boolean)this.m_notifier.notifyReceivedEvent(txNo, uei, message));
        this.finishUp();
    }

    @Test
    public void testFailureNotifyReceivedEvent() throws Exception {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        this.finishUp();
        this.m_anticipator.shutdown();
        Assert.assertFalse((String)"notifier notifyReceviedEvent", (boolean)this.m_notifier.notifyReceivedEvent(txNo, uei, message));
    }

    @Test
    public void testSendServiceDownEvent() throws Exception {
        Date date = new Date();
        this.m_anticipator.anticipateCall("sendServiceDownEvent", s_nodeLabel, s_interface, s_service, "Not Available", s_host, EventConstants.formatToString((Date)date));
        EventBuilder bldr = this.serviceEventBuilder(date);
        Assert.assertTrue((String)"notifier sendServiceDownEvent", (boolean)this.m_notifier.sendServiceDownEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testFailureSendServiceDownEvent() throws Exception {
        Date date = new Date();
        this.finishUp();
        this.m_anticipator.shutdown();
        EventBuilder bldr = this.serviceEventBuilder(date);
        Assert.assertFalse((String)"notifier sendServiceDownEvent", (boolean)this.m_notifier.sendServiceDownEvent(bldr.getEvent()));
    }

    @Test
    public void testSendServiceUpEvent() throws Exception {
        Date date = new Date();
        this.m_anticipator.anticipateCall("sendServiceUpEvent", s_nodeLabel, s_interface, s_service, "Not Available", s_host, EventConstants.formatToString((Date)date));
        EventBuilder bldr = this.serviceEventBuilder(date);
        Assert.assertTrue((String)"notifier sendServiceUpEvent", (boolean)this.m_notifier.sendServiceUpEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testFailureSendServiceUpEvent() throws Exception {
        Date date = new Date();
        this.finishUp();
        this.m_anticipator.shutdown();
        EventBuilder bldr = this.serviceEventBuilder(date);
        Assert.assertFalse((String)"notifier sendServiceUpEvent", (boolean)this.m_notifier.sendServiceUpEvent(bldr.getEvent()));
    }

    @Test
    public void testSendInterfaceDownEvent() throws Exception {
        Date date = new Date();
        this.m_anticipator.anticipateCall("sendInterfaceDownEvent", s_nodeLabel, s_interface, s_host, EventConstants.formatToString((Date)date));
        EventBuilder bldr = this.serviceEventBuilder(date);
        Assert.assertTrue((String)"notifier sendInterfaceDownEvent", (boolean)this.m_notifier.sendInterfaceDownEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testFailureSendInterfaceDownEvent() throws Exception {
        Date date = new Date();
        this.finishUp();
        this.m_anticipator.shutdown();
        EventBuilder bldr = this.serviceEventBuilder(date);
        Assert.assertFalse((String)"notifier sendInterfaceDownEvent", (boolean)this.m_notifier.sendInterfaceDownEvent(bldr.getEvent()));
    }

    @Test
    public void testSendInterfaceUpEvent() throws Exception {
        Date date = new Date();
        this.m_anticipator.anticipateCall("sendInterfaceUpEvent", s_nodeLabel, s_interface, s_host, s_host, EventConstants.formatToString((Date)date));
        EventBuilder bldr = this.serviceEventBuilder(date);
        Assert.assertTrue((String)"notifier sendInterfaceUpEvent", (boolean)this.m_notifier.sendInterfaceUpEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testFailureSendInterfaceUpEvent() throws Exception {
        Date date = new Date();
        this.finishUp();
        this.m_anticipator.shutdown();
        EventBuilder bldr = this.serviceEventBuilder(date);
        Assert.assertFalse((String)"notifier sendInterfaceUpEvent", (boolean)this.m_notifier.sendInterfaceUpEvent(bldr.getEvent()));
    }

    @Test
    public void testSendNodeDownEvent() throws Exception {
        Date date = new Date();
        this.m_anticipator.anticipateCall("sendNodeDownEvent", s_nodeLabel, s_host, EventConstants.formatToString((Date)date));
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        Assert.assertTrue((String)"notifier sendNodeDownEvent", (boolean)this.m_notifier.sendNodeDownEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testFailureSendNodeDownEvent() throws Exception {
        Date date = new Date();
        this.finishUp();
        this.m_anticipator.shutdown();
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        Assert.assertFalse((String)"notifier sendNodeDownEvent", (boolean)this.m_notifier.sendNodeDownEvent(bldr.getEvent()));
    }

    @Test
    public void testSendNodeUpEvent() throws Exception {
        Date date = new Date();
        this.m_anticipator.anticipateCall("sendNodeUpEvent", s_nodeLabel, s_host, EventConstants.formatToString((Date)date));
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        Assert.assertTrue((String)"notifier sendNodeUpEvent", (boolean)this.m_notifier.sendNodeUpEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testFailureSendNodeUpEvent() throws Exception {
        Date date = new Date();
        this.finishUp();
        this.m_anticipator.shutdown();
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        Assert.assertFalse((String)"notifier sendNodeUpEvent", (boolean)this.m_notifier.sendNodeUpEvent(bldr.getEvent()));
    }

    @Test
    public void testSendEventSimple() {
        Date date = new Date();
        this.m_anticipator.anticipateCall("sendEvent", XmlRpcNotifierTest.basicEventMap(date));
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testFailureSendEventSimple() throws Exception {
        Date date = new Date();
        this.finishUp();
        this.m_anticipator.shutdown();
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        Assert.assertFalse((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
    }

    @Test
    public void testSendEventSource() {
        Date date = new Date();
        Hashtable<String, String> eventMap = XmlRpcNotifierTest.basicEventMap(date);
        eventMap.put("source", "some other source");
        this.m_anticipator.anticipateCall("sendEvent", eventMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.setSource("some other source");
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventHost() {
        Date date = new Date();
        Hashtable<String, String> eventMap = XmlRpcNotifierTest.basicEventMap(date);
        eventMap.put("host", "some other host");
        this.m_anticipator.anticipateCall("sendEvent", eventMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.setHost("some other host");
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventInterface() {
        Date date = new Date();
        Hashtable<String, String> eventMap = XmlRpcNotifierTest.basicEventMap(date);
        eventMap.put("interface", s_interface);
        this.m_anticipator.anticipateCall("sendEvent", eventMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.setInterface(InetAddressUtils.addr((String)s_interface));
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventService() {
        Date date = new Date();
        Hashtable<String, String> eventMap = XmlRpcNotifierTest.basicEventMap(date);
        eventMap.put("service", s_service);
        this.m_anticipator.anticipateCall("sendEvent", eventMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.setService(s_service);
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventDescription() {
        Date date = new Date();
        Hashtable<String, String> eventMap = XmlRpcNotifierTest.basicEventMap(date);
        eventMap.put("description", s_description);
        this.m_anticipator.anticipateCall("sendEvent", eventMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.setDescription(s_description);
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventSeverity() {
        Date date = new Date();
        Hashtable<String, String> eventMap = XmlRpcNotifierTest.basicEventMap(date);
        eventMap.put("severity", s_severity);
        this.m_anticipator.anticipateCall("sendEvent", eventMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.setSeverity(s_severity);
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventEmptyParms() {
        Date date = new Date();
        this.m_anticipator.anticipateCall("sendEvent", XmlRpcNotifierTest.basicEventMap(date));
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.setParms(new ArrayList());
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventOneParm() {
        Date date = new Date();
        String parmZeroName = "foo";
        String parmZeroContent = s_host;
        String parmZeroType = "string";
        Hashtable<String, String> eventMap = XmlRpcNotifierTest.basicEventMap(date);
        XmlRpcNotifierTest.addRpcParm(eventMap, 0, parmZeroName, parmZeroContent, parmZeroType);
        this.m_anticipator.anticipateCall("sendEvent", eventMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.addParam(parmZeroName, parmZeroContent, parmZeroType, "text");
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventTwoParms() {
        String parmZeroName = "foo";
        String parmZeroContent = s_host;
        String parmZeroType = "string";
        String parmOneName = "baz";
        String parmOneContent = "blam";
        String parmOneType = "string";
        Date date = new Date();
        Hashtable<String, String> eventMap = XmlRpcNotifierTest.basicEventMap(date);
        XmlRpcNotifierTest.addRpcParm(eventMap, 0, parmZeroName, parmZeroContent, parmZeroType);
        XmlRpcNotifierTest.addRpcParm(eventMap, 1, parmOneName, parmOneContent, parmOneType);
        this.m_anticipator.anticipateCall("sendEvent", eventMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        bldr.addParam(parmZeroName, parmZeroContent, parmZeroType, "text");
        bldr.addParam(parmOneName, parmOneContent, parmOneType, "text");
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventNoNodeId() {
        Date date = new Date();
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("uei", "hi!");
        t.put("source", s_source);
        t.put("time", EventConstants.formatToString((Date)date));
        t.put("nodeId", String.valueOf(0));
        this.m_anticipator.anticipateCall("sendEvent", t);
        EventBuilder bldr = new EventBuilder("hi!", s_source, date);
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventNoNodeLabel() {
        Date date = new Date();
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("uei", "hi!");
        t.put("source", s_source);
        t.put("time", EventConstants.formatToString((Date)date));
        t.put("nodeId", String.valueOf(2));
        this.m_anticipator.anticipateCall("sendEvent", t);
        EventBuilder bldr = new EventBuilder("hi!", s_source, date);
        bldr.setNodeid(2L);
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(bldr.getEvent()));
        this.finishUp();
    }

    @Test
    public void testSendEventNullEvent() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("event object must not be null"));
        try {
            this.m_notifier.sendEvent(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.finishUp();
    }

    public static void addSnmpAttributes(EventBuilder bldr, String community, String enterpriseId, int generic, int specific, long dateLong, String version) {
        bldr.setCommunity(community);
        bldr.setGeneric(generic);
        bldr.setEnterpriseId(enterpriseId);
        bldr.setSpecific(specific);
        bldr.setSnmpTimeStamp(dateLong);
        bldr.setSnmpVersion(version);
    }

    @Test
    public void testSendTrapSimple() {
        Date date = new Date();
        String enterpriseId = ".1.3.6.4.1.1.1";
        Hashtable<String, String> trapMap = XmlRpcNotifierTest.basicTrapMap(date, "public", enterpriseId, 6, 2, date.getTime(), "1");
        this.m_anticipator.anticipateCall("sendSnmpTrapEvent", trapMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        Event e = bldr.getEvent();
        XmlRpcNotifierTest.addSnmpAttributes(bldr, "public", enterpriseId, 6, 2, date.getTime(), "1");
        Snmp snmp = bldr.getEvent().getSnmp();
        e.setSnmp(snmp);
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    @Test
    public void testFailureSendTrapSimple() throws Exception {
        Date date = new Date();
        String enterpriseId = ".1.3.6.4.1.1.1";
        this.finishUp();
        this.m_anticipator.shutdown();
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        Event e = bldr.getEvent();
        XmlRpcNotifierTest.addSnmpAttributes(bldr, "public", enterpriseId, 6, 2, date.getTime(), "1");
        Snmp snmp = bldr.getEvent().getSnmp();
        e.setSnmp(snmp);
        Assert.assertFalse((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
    }

    @Test
    public void testSendTrapIdText() {
        Date date = new Date();
        String enterpriseId = ".1.3.6.4.1.1.1";
        Hashtable<String, String> trapMap = XmlRpcNotifierTest.basicTrapMap(date, "public", enterpriseId, 6, 2, date.getTime(), "1");
        trapMap.put("enterpriseIdText", "foo!");
        this.m_anticipator.anticipateCall("sendSnmpTrapEvent", trapMap);
        EventBuilder bldr = XmlRpcNotifierTest.basicEventBuilder(date);
        Event e = bldr.getEvent();
        XmlRpcNotifierTest.addSnmpAttributes(bldr, "public", enterpriseId, 6, 2, date.getTime(), "1");
        Snmp snmp = bldr.getEvent().getSnmp();
        snmp.setIdtext("foo!");
        e.setSnmp(snmp);
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    @Test
    public void testSendTrapEmptySnmp() {
        Date date = new Date();
        Hashtable<String, String> trapMap = XmlRpcNotifierTest.basicTrapMap(date, "null", "null", 0, 0, 0L, "null");
        this.m_anticipator.anticipateCall("sendSnmpTrapEvent", trapMap);
        Event e = XmlRpcNotifierTest.basicEventBuilder(date).getEvent();
        Snmp s = new Snmp();
        e.setSnmp(s);
        Assert.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public static EventBuilder basicEventBuilder(Date date) {
        return new EventBuilder(s_uei, s_source, date).setHost(s_host).setNodeid(1L);
    }

    private EventBuilder serviceEventBuilder(Date date) {
        return XmlRpcNotifierTest.basicEventBuilder(date).setInterface(InetAddressUtils.addr((String)s_interface)).setService(s_service);
    }

    private static Hashtable<String, String> basicEventMap(Date date) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("uei", s_uei);
        t.put("source", s_source);
        t.put("time", EventConstants.formatToString((Date)date));
        t.put("host", s_host);
        t.put("nodeId", String.valueOf(1));
        t.put("nodeLabel", s_nodeLabel);
        return t;
    }

    static Hashtable<String, String> basicTrapMap(Date date, String community, String enterpriseId, int generic, int specific, long dateLong, String version) {
        Hashtable<String, String> trapMap = XmlRpcNotifierTest.basicEventMap(date);
        trapMap.put("communityString", community);
        trapMap.put("genericTrapNumber", String.valueOf(generic));
        trapMap.put("enterpriseId", enterpriseId);
        trapMap.put("specificTrapNumber", String.valueOf(specific));
        trapMap.put("timeStamp", String.valueOf(dateLong));
        trapMap.put("version", version);
        return trapMap;
    }

    public Parm makeEventParm(String name, String content, String type, String encoding) {
        Parm p = new Parm();
        p.setParmName(name);
        Value v = new Value();
        v.setContent(content);
        v.setType(type);
        v.setEncoding(encoding);
        p.setValue(v);
        return p;
    }

    public static void addRpcParm(Hashtable<String, String> t, int index, String name, String content, String type) {
        String prefix = "param" + index + " ";
        t.put(prefix + "name", name);
        t.put(prefix + "value", content);
        t.put(prefix + "type", type);
    }
}

