/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import javax.annotation.Resource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.TrapdConfigFactory;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.trapd.Trapd;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/opennms/applicationContext-soa.xml", "classpath:META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:META-INF/opennms/mockEventIpcManager.xml", "classpath:META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:META-INF/opennms/applicationContext-daemon.xml", "classpath:META-INF/opennms/applicationContext-trapDaemon.xml", "classpath:org/opennms/netmgt/trapd/applicationContext-trapDaemonTest-snmpTrapPort.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class TrapdTest
implements InitializingBean {
    @Resource(name="snmpTrapPort")
    Integer m_snmpTrapPort;
    @Autowired
    Trapd m_trapd;
    @Autowired
    MockEventIpcManager m_mockEventIpcManager;
    @Autowired
    TrapdConfigFactory m_trapdConfigFactory;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void onSetUpInTransactionIfEnabled() throws Exception {
        this.m_mockEventIpcManager.setSynchronous(true);
        this.m_trapd.onStart();
    }

    @After
    public void onTearDownInTransactionIfEnabled() throws Exception {
        this.m_trapd.onStop();
        this.m_mockEventIpcManager.getEventAnticipator().verifyAnticipated(3000L, 0L, 0L, 0, 0);
    }

    @Test
    public void testSnmpV1TrapSend() throws Exception {
        String localhost = "127.0.0.1";
        InetAddress localAddr = InetAddressUtils.addr((String)localhost);
        SnmpV1TrapBuilder pdu = SnmpUtils.getV1TrapBuilder();
        pdu.setEnterprise(SnmpObjId.get((String)".1.3.6.1.4.1.5813"));
        pdu.setGeneric(1);
        pdu.setSpecific(0);
        pdu.setTimeStamp(666L);
        pdu.setAgentAddress(localAddr);
        EventBuilder defaultTrapBuilder = new EventBuilder("uei.opennms.org/default/trap", "trapd");
        defaultTrapBuilder.setInterface(localAddr);
        this.m_mockEventIpcManager.getEventAnticipator().anticipateEvent(defaultTrapBuilder.getEvent());
        EventBuilder newSuspectBuilder = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "trapd");
        newSuspectBuilder.setInterface(localAddr);
        this.m_mockEventIpcManager.getEventAnticipator().anticipateEvent(newSuspectBuilder.getEvent());
        pdu.send(localhost, this.m_snmpTrapPort.intValue(), "public");
        Thread.sleep(5000L);
    }
}

