/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.Base64;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.mock.EventAnticipator;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.trapd.MockTrapdIpMgr;
import org.opennms.netmgt.trapd.TrapQueueProcessorFactory;
import org.opennms.netmgt.trapd.Trapd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:META-INF/opennms/mockEventIpcManager.xml", "classpath:META-INF/opennms/applicationContext-daemon.xml", "classpath:META-INF/opennms/applicationContext-trapDaemon.xml", "classpath:org/opennms/netmgt/trapd/applicationContext-trapDaemonTest.xml"})
@JUnitConfigurationEnvironment
public class TrapHandlerTestCase
implements InitializingBean {
    @Autowired
    private Trapd m_trapd = null;
    @Autowired
    private MockEventIpcManager m_eventMgr;
    @Autowired
    private MockTrapdIpMgr m_trapdIpMgr;
    @Autowired
    private TrapQueueProcessorFactory m_processorFactory;
    private EventAnticipator m_anticipator;
    private InetAddress m_localhost = null;
    @Resource(name="snmpTrapPort")
    private Integer m_snmpTrapPort;
    private boolean m_doStop = false;
    private static final String m_ip = "127.0.0.1";
    private static final long m_nodeId = 1L;

    @BeforeClass
    public static void setUpLogging() {
        MockLogAppender.setupLogging();
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        this.m_anticipator = new EventAnticipator();
        this.m_eventMgr.setEventAnticipator(this.m_anticipator);
        this.m_localhost = InetAddressUtils.addr((String)m_ip);
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.m_trapdIpMgr.setNodeId(m_ip, 1L);
        this.m_trapd.start();
        this.m_doStop = true;
    }

    public Collection<Event> finishUp() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_eventMgr.finishProcessingEvents();
        this.m_anticipator.verifyAnticipated(1000L, 0L, 0L, 0, 0);
        return this.m_anticipator.getAnticipatedEventsRecieved();
    }

    @After
    public void tearDown() throws Exception {
        if (this.m_trapd != null && this.m_doStop) {
            this.m_trapd.stop();
            this.m_trapd = null;
        }
    }

    @Test
    @DirtiesContext
    public void testV1TrapNoNewSuspect() throws Exception {
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.anticipateAndSend(false, false, "uei.opennms.org/default/trap", "v1", null, 6, 1);
    }

    @Test
    @DirtiesContext
    public void testV2TrapNoNewSuspect() throws Exception {
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.anticipateAndSend(false, false, "uei.opennms.org/default/trap", "v2c", null, 6, 1);
    }

    @Test
    @DirtiesContext
    public void testV1TrapNewSuspect() throws Exception {
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.anticipateAndSend(true, false, "uei.opennms.org/default/trap", "v1", null, 6, 1);
    }

    @Test
    @DirtiesContext
    public void testV2TrapNewSuspect() throws Exception {
        this.m_trapdIpMgr.clearKnownIpsMap();
        this.anticipateAndSend(true, false, "uei.opennms.org/default/trap", "v2c", null, 6, 1);
    }

    @Test
    @DirtiesContext
    public void testV1EnterpriseIdAndGenericMatch() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/IETF/BGP/traps/bgpEstablished", "v1", ".1.3.6.1.2.1.15.7", 6, 1);
    }

    @Test
    @DirtiesContext
    public void testV2EnterpriseIdAndGenericAndSpecificMatch() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/IETF/BGP/traps/bgpEstablished", "v2c", ".1.3.6.1.2.1.15.7", 6, 1);
    }

    @Test
    @DirtiesContext
    public void testV1EnterpriseIdAndGenericAndSpecificAndMatchWithVarbinds() throws Exception {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        LinkedHashMap<String, SnmpValue> varbinds = new LinkedHashMap<String, SnmpValue>();
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.4.2404", valueFactory.getInt32(3));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.5.2404", valueFactory.getInt32(2));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.6.2404", valueFactory.getInt32(5));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.3.0.2404", valueFactory.getOctetString("http://a.b.c.d/cgi/fDetail?index=2404".getBytes()));
        this.anticipateAndSend(false, true, "uei.opennms.org/vendor/HP/traps/hpicfFaultFinderTrap", "v1", ".1.3.6.1.4.1.11.2.14.12.1", 6, 5, varbinds);
    }

    @Test
    @DirtiesContext
    public void testV2EnterpriseIdAndGenericAndSpecificAndMatchWithVarbinds() throws Exception {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        LinkedHashMap<String, SnmpValue> varbinds = new LinkedHashMap<String, SnmpValue>();
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.4.2404", valueFactory.getInt32(3));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.5.2404", valueFactory.getInt32(2));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.2.1.6.2404", valueFactory.getInt32(5));
        varbinds.put(".1.3.6.1.4.1.11.2.14.11.1.7.3.0.2404", valueFactory.getOctetString("http://a.b.c.d/cgi/fDetail?index=2404".getBytes()));
        this.anticipateAndSend(false, true, "uei.opennms.org/vendor/HP/traps/hpicfFaultFinderTrap", "v2c", ".1.3.6.1.4.1.11.2.14.12.1", 6, 5, varbinds);
    }

    @Test
    @DirtiesContext
    public void testV1EnterpriseIdAndGenericAndSpecificAndMatchWithVarbindsAndTC() throws Exception {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        LinkedHashMap<String, SnmpValue> varbinds = new LinkedHashMap<String, SnmpValue>();
        varbinds.put(".1.3.6.1.4.1.14179.2.6.2.20.0", valueFactory.getOctetString(new byte[]{0, 20, -15, -83, -89, 80}));
        Collection<Event> events = this.anticipateAndSend(false, true, "uei.opennms.org/vendor/cisco/bsnAPNoiseProfileUpdatedToPass", "v1", ".1.3.6.1.4.1.14179.2.6.3", 6, 38, varbinds);
        boolean foundMacAddress = false;
        for (Event event : events) {
            for (Parm parm : event.getParmCollection()) {
                if (!".1.3.6.1.4.1.14179.2.6.2.20.0".equals(parm.getParmName())) continue;
                Assert.assertEquals((String)"MAC address does not match", (Object)"00:14:F1:AD:A7:50", (Object)parm.getValue().getContent());
                foundMacAddress = true;
            }
        }
        Assert.assertTrue((String)"Did not find expected MAC address parm", (boolean)foundMacAddress);
    }

    @Test
    @DirtiesContext
    public void testV2EnterpriseIdAndGenericAndSpecificAndMatchWithVarbindsAndTC() throws Exception {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        byte[] macAddr = new byte[]{0, 20, -15, -83, -89, 80};
        String encoded = new String(Base64.encodeBase64((byte[])macAddr));
        byte[] decodeBytes = Base64.decodeBase64((char[])encoded.toCharArray());
        this.assertByteArrayEquals(macAddr, decodeBytes);
        LinkedHashMap<String, SnmpValue> varbinds = new LinkedHashMap<String, SnmpValue>();
        varbinds.put(".1.3.6.1.4.1.14179.2.6.2.20.0", valueFactory.getOctetString(macAddr));
        Collection<Event> events = this.anticipateAndSend(false, true, "uei.opennms.org/vendor/cisco/bsnAPNoiseProfileUpdatedToPass", "v2c", ".1.3.6.1.4.1.14179.2.6.3", 6, 38, varbinds);
        boolean foundMacAddress = false;
        for (Event event : events) {
            for (Parm parm : event.getParmCollection()) {
                if (!".1.3.6.1.4.1.14179.2.6.2.20.0".equals(parm.getParmName())) continue;
                Assert.assertEquals((String)"MAC address does not match", (Object)"00:14:F1:AD:A7:50", (Object)parm.getValue().getContent());
                foundMacAddress = true;
            }
        }
        Assert.assertTrue((String)"Did not find expected MAC address parm", (boolean)foundMacAddress);
    }

    private void assertByteArrayEquals(byte[] macAddr, byte[] bytes) {
        Assert.assertEquals((String)("expect length: " + macAddr.length), (long)macAddr.length, (long)bytes.length);
        for (int i = 0; i < macAddr.length; ++i) {
            Assert.assertEquals((String)("Expected byte " + i + " to match"), (long)macAddr[i], (long)bytes[i]);
        }
    }

    @Test
    @DirtiesContext
    public void testV2EnterpriseIdAndGenericAndSpecificMatchWithZero() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/IETF/BGP/traps/bgpEstablished", "v2c", ".1.3.6.1.2.1.15.7.0", 6, 1);
    }

    @Test
    @DirtiesContext
    public void testV2EnterpriseIdAndGenericAndSpecificMissWithExtraZeros() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v2c", ".1.3.6.1.2.1.15.7.0.0", 6, 1);
    }

    @Test
    @DirtiesContext
    public void testV1EnterpriseIdAndGenericAndSpecificMissWithWrongGeneric() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v1", ".1.3.6.1.2.1.15.7", 5, 1);
    }

    @Test
    @DirtiesContext
    public void testV1EnterpriseIdAndGenericAndSpecificMissWithWrongSpecific() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v1", ".1.3.6.1.2.1.15.7", 6, 50);
    }

    @Test
    @DirtiesContext
    public void testV1GenericMatch() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/generic/traps/SNMP_Cold_Start", "v1", null, 0, 0);
    }

    @Test
    @DirtiesContext
    public void testV2GenericMatch() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/generic/traps/SNMP_Cold_Start", "v2c", ".1.3.6.1.6.3.1.1.5.1", 0, 0);
    }

    @Test
    @DirtiesContext
    public void testV1TrapDroppedEvent() throws Exception {
        this.anticipateAndSend(false, true, null, "v1", ".1.3.6.1.2.1.15.7", 6, 2);
    }

    @Test
    @DirtiesContext
    public void testV2TrapDroppedEvent() throws Exception {
        this.anticipateAndSend(false, true, null, "v2c", ".1.3.6.1.2.1.15.7", 6, 2);
    }

    @Test
    @DirtiesContext
    public void testV1TrapDefaultEvent() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v1", null, 6, 1);
    }

    @Test
    @DirtiesContext
    public void testV2TrapDefaultEvent() throws Exception {
        this.anticipateAndSend(false, true, "uei.opennms.org/default/trap", "v2c", null, 6, 1);
    }

    @Test
    @DirtiesContext
    public void testNodeGainedModifiesIpMgr() throws Exception {
        long nodeId = 2L;
        this.m_processorFactory.setNewSuspect(Boolean.valueOf(true));
        this.anticipateEvent("uei.opennms.org/default/trap", m_ip, nodeId);
        Event event = this.anticipateEvent("uei.opennms.org/nodes/nodeGainedInterface", m_ip, nodeId);
        this.m_eventMgr.sendNow(event);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.sendTrap("v1", null, 6, 1);
        this.finishUp();
    }

    @Test
    @DirtiesContext
    public void testInterfaceReparentedModifiesIpMgr() throws Exception {
        long nodeId = 2L;
        this.m_processorFactory.setNewSuspect(Boolean.valueOf(true));
        this.anticipateEvent("uei.opennms.org/default/trap", m_ip, nodeId);
        Event event = this.anticipateEvent("uei.opennms.org/nodes/interfaceReparented", m_ip, nodeId);
        this.m_eventMgr.sendNow(event);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.sendTrap("v1", null, 6, 1);
        this.finishUp();
    }

    @Test
    @DirtiesContext
    public void testInterfaceDeletedModifiesIpMgr() throws Exception {
        long nodeId = 0L;
        this.m_processorFactory.setNewSuspect(Boolean.valueOf(true));
        this.anticipateEvent("uei.opennms.org/default/trap", m_ip, nodeId);
        Event event = this.anticipateEvent("uei.opennms.org/nodes/interfaceDeleted", m_ip, nodeId);
        this.m_eventMgr.sendNow(event);
        this.anticipateEvent("uei.opennms.org/internal/discovery/newSuspect", m_ip, nodeId);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.sendTrap("v1", null, 6, 1);
        this.finishUp();
    }

    public Event anticipateEvent(String uei) {
        return this.anticipateEvent(uei, m_ip, 1L);
    }

    public Event anticipateEvent(String uei, String ip, long nodeId) {
        EventBuilder bldr = new EventBuilder(uei, "TrapHandlerTestCase");
        bldr.setNodeid(nodeId);
        bldr.setInterface(InetAddressUtils.addr((String)ip));
        this.m_anticipator.anticipateEvent(bldr.getEvent());
        return bldr.getEvent();
    }

    public Collection<Event> anticipateAndSend(boolean newSuspectOnTrap, boolean nodeKnown, String event, String version, String enterprise, int generic, int specific) throws Exception {
        return this.anticipateAndSend(newSuspectOnTrap, nodeKnown, event, version, enterprise, generic, specific, null);
    }

    public Collection<Event> anticipateAndSend(boolean newSuspectOnTrap, boolean nodeKnown, String event, String snmpTrapVersion, String enterprise, int generic, int specific, LinkedHashMap<String, SnmpValue> varbinds) throws Exception {
        this.m_processorFactory.setNewSuspect(Boolean.valueOf(newSuspectOnTrap));
        if (newSuspectOnTrap) {
            this.anticipateEvent("uei.opennms.org/internal/discovery/newSuspect", m_ip, 0L);
        }
        if (event != null) {
            if (nodeKnown) {
                this.anticipateEvent(event);
            } else {
                this.anticipateEvent(event, m_ip, 0L);
            }
        }
        if (varbinds == null) {
            this.sendTrap(snmpTrapVersion, enterprise, generic, specific);
        } else {
            this.sendTrap(snmpTrapVersion, enterprise, generic, specific, varbinds);
        }
        return this.finishUp();
    }

    public void sendTrap(String version, String enterprise, int generic, int specific) throws Exception {
        if (enterprise == null) {
            enterprise = ".0.0";
        }
        if (version.equals("v1")) {
            this.sendV1Trap(enterprise, generic, specific);
        } else if (version.equals("v2c")) {
            this.sendV2Trap(enterprise, specific);
        } else {
            throw new Exception("unsupported SNMP version for test: " + version);
        }
    }

    private void sendTrap(String version, String enterprise, int generic, int specific, LinkedHashMap<String, SnmpValue> varbinds) throws Exception {
        if (enterprise == null) {
            enterprise = ".0.0";
        }
        if (version.equals("v1")) {
            this.sendV1Trap(enterprise, generic, specific, varbinds);
        } else if (version.equals("v2c")) {
            this.sendV2Trap(enterprise, specific, varbinds);
        } else {
            throw new Exception("unsupported SNMP version for test: " + version);
        }
    }

    public void sendV1Trap(String enterprise, int generic, int specific) throws Exception {
        SnmpV1TrapBuilder pdu = SnmpUtils.getV1TrapBuilder();
        pdu.setEnterprise(SnmpObjId.get((String)enterprise));
        pdu.setGeneric(generic);
        pdu.setSpecific(specific);
        pdu.setTimeStamp(0L);
        pdu.setAgentAddress(this.m_localhost);
        pdu.send(this.getHostAddress(), this.m_snmpTrapPort.intValue(), "public");
    }

    private String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.m_localhost);
    }

    public void sendV1Trap(String enterprise, int generic, int specific, LinkedHashMap<String, SnmpValue> varbinds) throws Exception {
        SnmpV1TrapBuilder pdu = SnmpUtils.getV1TrapBuilder();
        pdu.setEnterprise(SnmpObjId.get((String)enterprise));
        pdu.setGeneric(generic);
        pdu.setSpecific(specific);
        pdu.setTimeStamp(0L);
        pdu.setAgentAddress(this.m_localhost);
        for (Map.Entry<String, SnmpValue> pairs : varbinds.entrySet()) {
            pdu.addVarBind(SnmpObjId.get((String)pairs.getKey()), pairs.getValue());
        }
        pdu.send(this.getHostAddress(), this.m_snmpTrapPort.intValue(), "public");
    }

    public void sendV2Trap(String enterprise, int specific) throws Exception {
        SnmpObjId trapOID;
        SnmpObjId enterpriseId = SnmpObjId.get((String)enterprise);
        boolean isGeneric = false;
        if (SnmpObjId.get((String)".1.3.6.1.6.3.1.1.5").isPrefixOf(enterpriseId)) {
            isGeneric = true;
            trapOID = enterpriseId;
        } else {
            trapOID = SnmpObjId.get((SnmpObjId)enterpriseId, (SnmpObjId)new SnmpInstId(specific));
        }
        SnmpTrapBuilder pdu = SnmpUtils.getV2TrapBuilder();
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.2.1.1.3.0"), SnmpUtils.getValueFactory().getTimeTicks(0L));
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.1.0"), SnmpUtils.getValueFactory().getObjectId(trapOID));
        if (isGeneric) {
            pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.3.0"), SnmpUtils.getValueFactory().getObjectId(enterpriseId));
        }
        pdu.send(this.getHostAddress(), this.m_snmpTrapPort.intValue(), "public");
    }

    public void sendV2Trap(String enterprise, int specific, LinkedHashMap<String, SnmpValue> varbinds) throws Exception {
        SnmpObjId trapOID;
        SnmpObjId enterpriseId = SnmpObjId.get((String)enterprise);
        boolean isGeneric = false;
        if (SnmpObjId.get((String)".1.3.6.1.6.3.1.1.5").isPrefixOf(enterpriseId)) {
            isGeneric = true;
            trapOID = enterpriseId;
        } else {
            trapOID = SnmpObjId.get((SnmpObjId)enterpriseId, (SnmpObjId)new SnmpInstId(specific));
        }
        SnmpTrapBuilder pdu = SnmpUtils.getV2TrapBuilder();
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.2.1.1.3.0"), SnmpUtils.getValueFactory().getTimeTicks(0L));
        pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.1.0"), SnmpUtils.getValueFactory().getObjectId(trapOID));
        if (isGeneric) {
            pdu.addVarBind(SnmpObjId.get((String)".1.3.6.1.6.3.1.1.4.3.0"), SnmpUtils.getValueFactory().getObjectId(enterpriseId));
        }
        for (Map.Entry<String, SnmpValue> entry : varbinds.entrySet()) {
            pdu.addVarBind(SnmpObjId.get((String)entry.getKey()), entry.getValue());
        }
        pdu.send(this.getHostAddress(), this.m_snmpTrapPort.intValue(), "public");
    }
}

