/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.io.Serializable;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.netmgt.ticketd.TicketerServiceLayer;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath:/META-INF/opennms/applicationContext-mockEventd.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-troubleTicketer.xml", "classpath:/org/opennms/netmgt/ticketd/applicationContext-configOverride.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment(systemProperties={"opennms.ticketer.plugin=org.opennms.netmgt.ticketd.DefaultTicketerServiceLayerIntegrationTest.TestTicketerPlugin"})
public class DefaultTicketerServiceLayerIntegrationTest
implements InitializingBean {
    @Autowired
    private TicketerServiceLayer m_ticketerServiceLayer;
    @Autowired
    private TestTicketerPlugin m_ticketerPlugin;
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
    }

    @After
    public void tearDown() {
        this.m_databasePopulator.resetDatabase();
    }

    @Test
    public void testWire() {
        Assert.assertNotNull((Object)this.m_ticketerServiceLayer);
        Assert.assertNotNull((Object)this.m_ticketerPlugin);
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.findAll().get(0);
        Assert.assertNull((Object)alarm.getTTicketState());
        Assert.assertNull((Object)alarm.getTTicketId());
        int alarmId = alarm.getId();
        this.m_ticketerServiceLayer.createTicketForAlarm(alarmId, new HashMap());
        this.m_alarmDao.flush();
        alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        Assert.assertEquals((Object)TroubleTicketState.OPEN, (Object)alarm.getTTicketState());
        Assert.assertNotNull((Object)alarm.getTTicketId());
        Assert.assertEquals((Object)"testId", (Object)alarm.getTTicketId());
        this.m_ticketerServiceLayer.updateTicketForAlarm(alarm.getId().intValue(), alarm.getTTicketId());
        this.m_alarmDao.flush();
        alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        Assert.assertEquals((Object)TroubleTicketState.OPEN, (Object)alarm.getTTicketState());
        this.m_ticketerServiceLayer.closeTicketForAlarm(alarmId, alarm.getTTicketId());
        this.m_alarmDao.flush();
        alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
        Assert.assertEquals((Object)TroubleTicketState.CLOSED, (Object)alarm.getTTicketState());
    }

    public static class TestTicketerPlugin
    implements Plugin {
        public Ticket get(String ticketId) {
            Ticket ticket = new Ticket();
            ticket.setId(ticketId);
            return ticket;
        }

        public void saveOrUpdate(Ticket ticket) {
            ticket.setId("testId");
        }
    }
}

