/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SyslogRegexTest {
    private final int m_count = 1000000;
    private String m_matchPattern;
    private String m_logMessage;

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws ParseException {
        return Arrays.asList({"\\s(19|20)\\d\\d([-/.])(0[1-9]|1[012])\\2(0[1-9]|[12][0-9]|3[01])(\\s+)(\\S+)(\\s)(\\S.+)", "<6>main: 2010-08-19 localhost foo23: load test 23 on tty1"}, {"\\s(19|20)\\d\\d([-/.])(0[1-9]|1[012])\\2(0[1-9]|[12][0-9]|3[01])(\\s+)(\\S+)(\\s)(\\S.+)", "<6>main: 2010-08-01 localhost foo23: load test 23 on tty1"}, {"foo0: .*load test (\\S+) on ((pts\\/\\d+)|(tty\\d+))", "<6>main: 2010-08-19 localhost foo23: load test 23 on tty1"}, {"foo23: .*load test (\\S+) on ((pts\\/\\d+)|(tty\\d+))", "<6>main: 2010-08-19 localhost foo23: load test 23 on tty1"}, {"1997", "<6>main: 2010-08-19 localhost foo23: load test 23 on tty1"});
    }

    public SyslogRegexTest(String matchPattern, String logMessage) {
        this.m_matchPattern = matchPattern;
        this.m_logMessage = logMessage;
        System.err.println("=== " + this.m_matchPattern + " ===");
    }

    @Test
    @Ignore
    public void testRegex() {
        String logMessage = this.m_logMessage;
        String matchPattern = this.m_matchPattern;
        this.tryPattern(logMessage, matchPattern);
    }

    private void tryPattern(String logMessage, String matchPattern) {
        Matcher m;
        int i;
        Pattern pattern = Pattern.compile(matchPattern, 8);
        boolean matches = false;
        long start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            m = pattern.matcher(logMessage);
            matches = m.matches();
        }
        long end = System.currentTimeMillis();
        this.printSpeed("matches = " + matches, start, end);
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            m = pattern.matcher(logMessage);
            matches = m.find();
        }
        end = System.currentTimeMillis();
        this.printSpeed("find = " + matches, start, end);
        pattern = Pattern.compile(".*" + this.m_matchPattern + ".*");
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            m = pattern.matcher(logMessage);
            matches = m.matches();
        }
        end = System.currentTimeMillis();
        this.printSpeed("matches (.* at beginning and end) = " + matches, start, end);
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            m = pattern.matcher(logMessage);
            matches = m.find();
        }
        end = System.currentTimeMillis();
        this.printSpeed("find (.* at beginning and end) = " + matches, start, end);
        pattern = Pattern.compile("^.*" + this.m_matchPattern + ".*$");
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            m = pattern.matcher(logMessage);
            matches = m.matches();
        }
        end = System.currentTimeMillis();
        this.printSpeed("matches (^.* at beginning, .*$ at end) = " + matches, start, end);
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            m = pattern.matcher(logMessage);
            matches = m.find();
        }
        end = System.currentTimeMillis();
        this.printSpeed("find (^.* at beginning, .*$ at end) = " + matches, start, end);
    }

    private void printSpeed(String message, long start, long end) {
        System.err.println(String.format("%s: total time: %d, number per second: %8.4f", message, end - start, 1.0E9 / (double)(end - start)));
    }
}

