/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.poller.pollables.PollableServiceConfig;
import org.opennms.netmgt.scheduler.Timer;

@RunWith(value=MockitoJUnitRunner.class)
public class PollableServiceConfigTest {
    @Test
    public void testPollableServiceConfig() throws Exception {
        FilterDao fd = (FilterDao)Mockito.mock(FilterDao.class);
        FilterDaoFactory.setInstance((FilterDao)fd);
        FileInputStream is = new FileInputStream(new File("src/test/resources/etc/psm-poller-configuration.xml"));
        PollerConfigFactory factory = new PollerConfigFactory(0L, (InputStream)is, "localhost", false);
        PollerConfigFactory.setInstance((PollerConfig)factory);
        IOUtils.closeQuietly((InputStream)is);
        PollContext context = (PollContext)Mockito.mock(PollContext.class);
        PollableNetwork network = new PollableNetwork(context);
        PollableNode node = network.createNodeIfNecessary(1, "foo");
        PollableInterface iface = new PollableInterface(node, InetAddressUtils.addr((String)"127.0.0.1"));
        PollableService svc = new PollableService(iface, "MQ_API_DirectRte_v2");
        PollOutagesConfig pollOutagesConfig = (PollOutagesConfig)Mockito.mock(PollOutagesConfig.class);
        Package pkg = factory.getPackage("MapQuest");
        Timer timer = (Timer)Mockito.mock(Timer.class);
        PollableServiceConfig psc = new PollableServiceConfig(svc, (PollerConfig)factory, pollOutagesConfig, pkg, timer);
        ServiceMonitor sm = (ServiceMonitor)Mockito.mock(ServiceMonitor.class);
        psc.setServiceMonitor(sm);
        psc.poll();
    }
}

