/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.util.Collections;
import java.util.Map;
import junit.framework.TestCase;
import org.opennms.core.utils.TimeoutTracker;

public class TimeoutTrackerTest
extends TestCase {
    public void testShouldRetry() {
        int retries = 2;
        Map emptyMap = Collections.emptyMap();
        TimeoutTracker tracker = new TimeoutTracker(emptyMap, retries, 3000);
        int count = 0;
        tracker.reset();
        while (tracker.shouldRetry()) {
            tracker.startAttempt();
            ++count;
            TimeoutTrackerTest.assertTrue((tracker.elapsedTimeInMillis() < 100.0 ? 1 : 0) != 0);
            tracker.nextAttempt();
        }
        TimeoutTrackerTest.assertEquals((String)"expected one try and 2 retries", (int)3, (int)count);
    }

    public void testElapsedTimeButNoStartAttempt() {
        Map emptyMap = Collections.emptyMap();
        TimeoutTracker tracker = new TimeoutTracker(emptyMap, 0, 3000);
        try {
            tracker.elapsedTimeInMillis();
            TimeoutTrackerTest.fail((String)"expected an exception since no startAttempt is called");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testElapsedTime() throws InterruptedException {
        long sleepTime = 200L;
        Map emptyMap = Collections.emptyMap();
        TimeoutTracker tracker = new TimeoutTracker(emptyMap, 0, 3000);
        tracker.startAttempt();
        Thread.sleep(sleepTime, 0);
        double elapsedTimeInMillis = tracker.elapsedTimeInMillis();
        long minTime = sleepTime;
        long maxTime = 2L * sleepTime;
        TimeoutTrackerTest.assertTrue((String)("Expected value for elapsedTimeInMillis should be greater than " + minTime), (elapsedTimeInMillis > (double)(minTime - 1L) ? 1 : 0) != 0);
        TimeoutTrackerTest.assertTrue((String)("Expected value for elapsedTimeInMillis should be less than " + maxTime), (elapsedTimeInMillis < (double)(maxTime + 1L) ? 1 : 0) != 0);
    }
}

