/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.monitors.SystemExecuteMonitor;

public class SystemExecuteMonitorTest {
    private SystemExecuteMonitor monitor;
    private final String NODELABEL = "www.OpenNMS.org";
    private MonitoredService svc;
    private Map<String, Object> parameters;

    @Before
    public void setup() throws Exception {
        this.monitor = new SystemExecuteMonitor();
        this.svc = new MockMonitoredService(42, "www.OpenNMS.org", InetAddress.getLocalHost(), "myService");
        this.parameters = new HashMap<String, Object>();
    }

    @Test
    public void testPollScriptParameterNotSet() {
        this.monitor = new SystemExecuteMonitor();
        PollStatus pollStatus = this.monitor.poll(this.svc, this.parameters);
        Assert.assertEquals((String)"Unknown", (String)pollStatus.getStatusName());
    }

    @Test
    public void testPollScriptParameterEmpty() {
        this.monitor = new SystemExecuteMonitor();
        this.parameters.put("script", "");
        PollStatus pollStatus = this.monitor.poll(this.svc, this.parameters);
        Assert.assertEquals((String)"Unknown", (String)pollStatus.getStatusName());
    }

    @Test
    @Ignore
    public void testPollScriptParameterNotExecutable() {
        this.monitor = new SystemExecuteMonitor();
        this.parameters.put("script", "/tmp/log.log");
        PollStatus pollStatus = this.monitor.poll(this.svc, this.parameters);
        Assert.assertEquals((String)"Unknown", (String)pollStatus.getStatusName());
    }

    @Test
    @Ignore
    public void testPollScriptParameterNotExecutableFoo() {
        this.monitor = new SystemExecuteMonitor();
        this.parameters.put("script", "/tmp/loadspeed.sh");
        this.parameters.put("timeout", "30000");
        this.parameters.put("args", "http://${nodelabel} ${timeout}");
        PollStatus pollStatus = this.monitor.poll(this.svc, this.parameters);
        Assert.assertEquals((String)"Up", (String)pollStatus.getStatusName());
    }
}

