/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.math.BigInteger;
import java.net.UnknownHostException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.test.ThrowableAnticipator;

public class SnmpMonitorStrategyTest {
    private SnmpMonitorStrategy monitor = new SnmpMonitorStrategy(){

        public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
            throw new UnsupportedOperationException("method not implemented; go away, punk!");
        }
    };

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testMeetsCriteriaWithNullResult() {
        SnmpValue result = null;
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, null, null));
    }

    @Test
    public void testMeetsCriteriaWithSnmpNull() {
        SnmpValue result = this.nullValue();
        this.testSyntaxEquals(result, "", "1");
    }

    @Test
    public void testMeetsCriteriaWithString() {
        SnmpValue result = this.octetString("A Test String");
        this.testSyntaxEquals(result, "A Test String", "a test string");
        this.testSyntaxMatches(result, "[tT][eE][sS][tT]", "test");
        this.testSyntaxMatches(result, "^A Test String$", "^A Test$");
    }

    @Test
    public void testMeetsCriteriaWithObjectID() {
        SnmpValue result = this.oid(".1.2.3.4.5.6.7.8.9");
        this.testSyntaxEquals(result, ".1.2.3.4.5.6.7.8.9", "..1.2.3.4.5.6.7.8.9");
        this.testSyntaxMatches(result, "\\.7\\.", "\\.11\\.");
    }

    @Test
    public void testMeetsCriteriaWithIPAddr() throws Exception {
        SnmpValue result = this.ipAddr("10.1.1.1");
        this.testSyntaxEquals(result, "10.1.1.1", "10.1.1.2");
        this.testSyntaxMatches(result, "10\\.1\\.1\\.[1-5]", "10\\.1\\.1\\.[02-9]");
    }

    @Test
    public void testNumericString() {
        SnmpValue result = this.octetString("12345");
        this.testOrderOperations(result, 12345);
    }

    @Test
    public void testMeetsCriteriaWithInteger() {
        SnmpValue result = this.int32Value(1234);
        this.testSyntaxEquals(result, "1234", "2234");
        this.testOrderOperations(result, 1234);
        this.testSyntaxMatches(result, "23", "14");
    }

    private SnmpValue int32Value(int i) {
        return SnmpUtils.getValueFactory().getInt32(i);
    }

    @Test
    public void testMeetsCriteriaWithCounter32() {
        SnmpValue result = this.counter32Value(1);
        this.testSyntaxEquals(result, "1", "2");
        this.testOrderOperations(result, 1);
    }

    private SnmpValue counter32Value(int i) {
        return SnmpUtils.getValueFactory().getCounter32((long)i);
    }

    @Test
    public void testMeetsCriteriaWithGauge32() {
        SnmpValue result = this.gauge32Value(1);
        this.testSyntaxEquals(result, "1", "2");
        this.testOrderOperations(result, 1);
    }

    private SnmpValue gauge32Value(int i) {
        return SnmpUtils.getValueFactory().getGauge32((long)i);
    }

    @Test
    public void testMeetsCriteriaWithTimeTicks() {
        SnmpValue result = this.timeticks("1");
        this.testSyntaxEquals(result, "1", "2");
        this.testOrderOperations(result, 1);
    }

    private SnmpValue timeticks(String val) {
        return SnmpUtils.getValueFactory().getTimeTicks(Long.parseLong(val));
    }

    @Test
    public void testMeetsCriteriaWithCounter64() {
        SnmpValue result = this.counter64Value(1);
        this.testSyntaxEquals(result, "1", "2");
        this.testOrderOperations(result, 1);
    }

    private SnmpValue counter64Value(int i) {
        return SnmpUtils.getValueFactory().getCounter64(BigInteger.valueOf(i));
    }

    @Test
    public void testErrorConditions() {
        SnmpValue result = this.int32Value(1);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("operator X is unknown"));
        try {
            this.monitor.meetsCriteria(result, "X", "123");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testErrorConditions2() {
        SnmpValue result = this.int32Value(1);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new NumberFormatException("For input string: \"abc\""));
        try {
            this.monitor.meetsCriteria(result, "<", "abc");
            Assert.fail((String)"expected an exception");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    private void testSyntaxEquals(SnmpValue result, String eqString, String neString) {
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, null, null));
        Assert.assertTrue((String)("result '" + result + "' should pass equal test with '" + eqString + "'"), (boolean)this.monitor.meetsCriteria(result, "=", eqString));
        Assert.assertFalse((String)("result '" + result + "' should fail equal test with '" + neString + "'"), (boolean)this.monitor.meetsCriteria(result, "=", neString));
        Assert.assertFalse((String)("result '" + result + "' should fail not equal test with '" + eqString + "'"), (boolean)this.monitor.meetsCriteria(result, "!=", eqString));
        Assert.assertTrue((String)("result '" + result + "' should pass not equal test with '" + neString + "'"), (boolean)this.monitor.meetsCriteria(result, "!=", neString));
    }

    private void testSyntaxMatches(SnmpValue result, String matchString, String noMatchString) {
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, "~", matchString));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, "~", noMatchString));
    }

    private void testOrderOperations(SnmpValue result, int value) {
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, "<", Integer.toString(value + 1)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, "<", Integer.toString(value)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, "<", Integer.toString(value - 1)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, "<=", Integer.toString(value + 1)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, "<=", Integer.toString(value)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, "<=", Integer.toString(value - 1)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, ">", Integer.toString(value + 1)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, ">", Integer.toString(value)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, ">", Integer.toString(value - 1)));
        Assert.assertFalse((boolean)this.monitor.meetsCriteria(result, ">=", Integer.toString(value + 1)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, ">=", Integer.toString(value)));
        Assert.assertTrue((boolean)this.monitor.meetsCriteria(result, ">=", Integer.toString(value - 1)));
    }

    SnmpValue octetString(String val) {
        return SnmpUtils.getValueFactory().getOctetString(val.getBytes());
    }

    SnmpValue nullValue() {
        return SnmpUtils.getValueFactory().getNull();
    }

    SnmpValue oid(String objectId) {
        return SnmpUtils.getValueFactory().getObjectId(SnmpObjId.get((String)objectId));
    }

    private SnmpValue ipAddr(String addr) throws UnknownHostException {
        return SnmpUtils.getValueFactory().getIpAddress(InetAddressUtils.addr((String)addr));
    }
}

