/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.monitors.SmtpMonitor;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
@JUnitConfigurationEnvironment
public class SmtpMonitorTest {
    private final SmtpMonitor m_monitor = new SmtpMonitor();
    private ServerSocket m_serverSocket = null;
    private Thread m_serverThread = null;
    private static final int TIMEOUT = 2000;

    @Before
    public void setUp() throws Exception {
        this.m_serverSocket = new ServerSocket();
        this.m_serverSocket.bind(null);
        System.err.println("m_serverSocket.port: " + this.m_serverSocket.getLocalPort());
    }

    @After
    public void tearDown() throws Exception {
        if (this.m_serverSocket != null && !this.m_serverSocket.isClosed()) {
            this.m_serverSocket.close();
        }
        if (this.m_serverThread != null) {
            this.m_serverThread.join(1500L);
        }
    }

    @Test
    public void testPoll() throws UnknownHostException, InterruptedException {
        this.m_serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SmtpMonitorTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = SmtpMonitorTest.this.m_serverSocket.accept();
                    System.out.println("S: 220 localhost.localdomain ESMTP bogon");
                    s.getOutputStream().write("220 localhost.localdomain ESMTP bogon\r\n".getBytes());
                    BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String command = r.readLine();
                    System.out.println("C: " + command);
                    if (command.startsWith("HELO ")) {
                        System.out.println("S: 250 Hello");
                        s.getOutputStream().write("250 Hello\r\n".getBytes());
                    }
                    command = r.readLine();
                    System.out.println("C: " + command);
                    if (command.equals("QUIT")) {
                        System.out.println("S: 250 Hello");
                        s.getOutputStream().write("221 See ya\r\n".getBytes());
                    }
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        this.m_serverThread.start();
        SmtpMonitor sm = new SmtpMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Node One", InetAddressUtils.addr((String)"127.0.0.1"), "SMTP");
        HashMap<String, Integer> parms = new HashMap<String, Integer>();
        parms.put("port", this.m_serverSocket.getLocalPort());
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollCase1() throws UnknownHostException, InterruptedException {
        this.m_serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SmtpMonitorTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = SmtpMonitorTest.this.m_serverSocket.accept();
                    System.out.println("S: 220-localhost.localdomain ESMTP bogon");
                    s.getOutputStream().write("220-localhost.localdomain ESMTP bogon\r\n".getBytes());
                    System.out.println("S: 220 send me mail now!");
                    s.getOutputStream().write("220 send me mail now!\r\n".getBytes());
                    BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String command = r.readLine();
                    System.out.println("C: " + command);
                    if (command.startsWith("HELO ")) {
                        System.out.println("S: 250 Hello");
                        s.getOutputStream().write("250 Hello\r\n".getBytes());
                    }
                    command = r.readLine();
                    System.out.println("C: " + command);
                    if (command.equals("QUIT")) {
                        System.out.println("S: 250 Hello");
                        s.getOutputStream().write("221 See ya\r\n".getBytes());
                    }
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        this.m_serverThread.start();
        SmtpMonitor sm = new SmtpMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Node One", InetAddressUtils.addr((String)"127.0.0.1"), "SMTP");
        HashMap<String, Integer> parms = new HashMap<String, Integer>();
        parms.put("port", this.m_serverSocket.getLocalPort());
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollCase2() throws UnknownHostException, InterruptedException {
        this.m_serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SmtpMonitorTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = SmtpMonitorTest.this.m_serverSocket.accept();
                    System.out.println("S: 220 localhost.localdomain ESMTP bogon");
                    s.getOutputStream().write("220 localhost.localdomain ESMTP bogon\r\n".getBytes());
                    BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String command = r.readLine();
                    System.out.println("C: " + command);
                    if (command.startsWith("HELO ")) {
                        System.out.println("S: 250-Hello");
                        s.getOutputStream().write("250-Hello\r\n".getBytes());
                        System.out.println("S: 250 send me mail now!");
                        s.getOutputStream().write("250 send me mail now!\r\n".getBytes());
                    }
                    command = r.readLine();
                    System.out.println("C: " + command);
                    if (command.equals("QUIT")) {
                        System.out.println("S: 250 Hello");
                        s.getOutputStream().write("221 See ya\r\n".getBytes());
                    }
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        this.m_serverThread.start();
        SmtpMonitor sm = new SmtpMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Node One", InetAddressUtils.addr((String)"127.0.0.1"), "SMTP");
        HashMap<String, Integer> parms = new HashMap<String, Integer>();
        parms.put("port", this.m_serverSocket.getLocalPort());
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollCase3() throws UnknownHostException, InterruptedException {
        this.m_serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SmtpMonitorTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = SmtpMonitorTest.this.m_serverSocket.accept();
                    System.out.println("S: 220 localhost.localdomain ESMTP bogon");
                    s.getOutputStream().write("220 localhost.localdomain ESMTP bogon\r\n".getBytes());
                    BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String command = r.readLine();
                    System.out.println("C: " + command);
                    if (command.startsWith("HELO ")) {
                        System.out.println("S: 250 Hello");
                        s.getOutputStream().write("250 Hello\r\n".getBytes());
                    }
                    command = r.readLine();
                    System.out.println("C: " + command);
                    if (command.equals("QUIT")) {
                        System.out.println("S: 221-Goodbye, friend.");
                        s.getOutputStream().write("221-Goodbye, friend.\r\n".getBytes());
                        System.out.println("S: 221 See ya");
                        s.getOutputStream().write("221 See ya\r\n".getBytes());
                    }
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        this.m_serverThread.start();
        SmtpMonitor sm = new SmtpMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Node One", InetAddressUtils.addr((String)"127.0.0.1"), "SMTP");
        HashMap<String, Integer> parms = new HashMap<String, Integer>();
        parms.put("port", this.m_serverSocket.getLocalPort());
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUp());
        Assert.assertFalse((boolean)ps.isDown());
    }

    @Test
    public void testPollSvrStatus554() throws UnknownHostException, InterruptedException {
        this.m_serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SmtpMonitorTest.this.m_serverSocket.setSoTimeout(1000);
                    Socket s = SmtpMonitorTest.this.m_serverSocket.accept();
                    System.out.println("S: 554 localhost.localdomain ESMTP bogon");
                    s.getOutputStream().write("554 localhost.localdomain ESMTP bogon\r\n".getBytes());
                    BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream()));
                    String command = r.readLine();
                    System.out.println("C: " + command);
                    if (command.equals("QUIT")) {
                        System.out.println("S: 221-Goodbye, friend.");
                        s.getOutputStream().write("221-Goodbye, friend.\r\n".getBytes());
                        System.out.println("S: 221 See ya");
                        s.getOutputStream().write("221 See ya\r\n".getBytes());
                    }
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
        });
        this.m_serverThread.start();
        SmtpMonitor sm = new SmtpMonitor();
        MockMonitoredService svc = new MockMonitoredService(1, "Node One", InetAddressUtils.addr((String)"127.0.0.1"), "SMTP");
        HashMap<String, Integer> parms = new HashMap<String, Integer>();
        parms.put("port", this.m_serverSocket.getLocalPort());
        PollStatus ps = sm.poll((MonitoredService)svc, parms);
        Assert.assertTrue((boolean)ps.isUnavailable());
        Assert.assertFalse((boolean)ps.isUp());
    }
}

