/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.ConcurrentSkipListMap;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.mock.MonitorTestUtils;
import org.opennms.netmgt.poller.monitors.SSLCertMonitor;
import org.opennms.netmgt.utils.DnsUtils;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
@JUnitConfigurationEnvironment
public class SSLCertMonitorTest {
    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
    }

    @Test
    @JUnitHttpServer(port=10342, https=true)
    public void testNMS4142() throws UnknownHostException {
        SSLCertMonitor monitor = new SSLCertMonitor();
        ConcurrentSkipListMap<String, String> parameters = new ConcurrentSkipListMap<String, String>();
        parameters.put("port", "10342");
        parameters.put("retry", "0");
        parameters.put("timeout", "500");
        parameters.put("verbose", "true");
        parameters.put("days", "5");
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)false), (String)"SSLCert");
        PollStatus status = monitor.poll((MonitoredService)svc, parameters);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertFalse((boolean)status.isAvailable());
    }

    @Test
    @Ignore
    @JUnitHttpServer(port=10342, https=true)
    public void testValidDateForCertificate() throws UnknownHostException {
        Calendar calExp = GregorianCalendar.getInstance();
        calExp.setTimeInMillis(1270941909000L);
        Calendar cal = GregorianCalendar.getInstance();
        EasyMock.expect((Object)GregorianCalendar.getInstance()).andReturn((Object)cal);
        EasyMock.expect((Object)GregorianCalendar.getInstance()).andReturn((Object)calExp);
        SSLCertMonitor monitor = new SSLCertMonitor();
        ConcurrentSkipListMap<String, String> parameters = new ConcurrentSkipListMap<String, String>();
        parameters.put("port", "10342");
        parameters.put("retry", "0");
        parameters.put("timeout", "500");
        parameters.put("verbose", "true");
        parameters.put("days", "5");
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"localhost", (InetAddress)DnsUtils.resolveHostname((String)"localhost", (boolean)false), (String)"SSLCert");
        PollStatus status = monitor.poll((MonitoredService)svc, parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }

    @Test
    @Ignore
    public void testInternetWebsite() throws UnknownHostException {
        SSLCertMonitor monitor = new SSLCertMonitor();
        ConcurrentSkipListMap<String, String> parameters = new ConcurrentSkipListMap<String, String>();
        parameters.put("port", "443");
        parameters.put("retry", "0");
        parameters.put("timeout", "500");
        parameters.put("verbose", "true");
        parameters.put("days", "5");
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)3, (String)"www.google.com", (InetAddress)DnsUtils.resolveHostname((String)"www.google.com", (boolean)false), (String)"SSLCert");
        PollStatus status = monitor.poll((MonitoredService)svc, parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }
}

