/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.test.http.annotations.Webapp;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.netmgt.poller.monitors.PageSequenceMonitor;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/opennms/emptyContext.xml"})
@JUnitConfigurationEnvironment
@JUnitHttpServer(port=10342)
public class PageSequenceMonitorTest {
    AbstractServiceMonitor m_monitor;
    Map<String, Object> m_params;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_monitor = new PageSequenceMonitor();
        this.m_monitor.initialize(Collections.emptyMap());
        this.m_params = new HashMap<String, Object>();
        this.m_params.put("timeout", "8000");
        this.m_params.put("retries", "1");
    }

    protected MonitoredService getHttpService(String hostname) throws Exception {
        return this.getHttpService(hostname, InetAddressUtils.addr((String)hostname));
    }

    protected MonitoredService getHttpService(String hostname, InetAddress inetAddress) throws Exception {
        MockMonitoredService svc = new MockMonitoredService(1, hostname, inetAddress, "HTTP");
        this.m_monitor.initialize((MonitoredService)svc);
        return svc;
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testSimple() throws Exception {
        this.setPageSequenceParam("localhost");
        PollStatus googleStatus = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + googleStatus + ": reason = " + googleStatus.getReason()), (boolean)googleStatus.isAvailable());
    }

    @Test
    public void testSimpleBogus() throws Exception {
        this.setPageSequenceParam(null);
        this.m_params.put("timeout", "500");
        this.m_params.put("retries", "0");
        PollStatus notLikely = this.m_monitor.poll(this.getHttpService("bogus", InetAddressUtils.addr((String)"1.1.1.1")), this.m_params);
        Assert.assertTrue((String)"should not be available", (boolean)notLikely.isUnavailable());
    }

    private void setPageSequenceParam(String virtualHost) {
        String virtualHostParam = virtualHost == null ? "" : "virtual-host=\"" + virtualHost + "\"";
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/index.html\" port=\"10342\" user-agent=\"Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\" successMatch=\"It was written by monkeys.\" " + virtualHostParam + "/>\n" + "</page-sequence>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="EBay tests stopped working, we REALLY need to make our own repeatable version of this test")
    public void testHttps() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page scheme=\"https\" host=\"scgi.ebay.com\" path=\"/ws/eBayISAPI.dll\" query=\"RegisterEnterInfo\" port=\"443\" user-agent=\"Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\" successMatch=\"ebaystatic.com/\"/>\n</page-sequence>\n");
        PollStatus googleStatus = this.m_monitor.poll(this.getHttpService("scgi.ebay.com"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + googleStatus + ": reason = " + googleStatus.getReason()), (boolean)googleStatus.isAvailable());
    }

    @Test
    @Ignore(value="EBay tests stopped working, we REALLY need to make our own repeatable version of this test")
    public void testHttpsWithHostValidation() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page scheme=\"https\" path=\"/ws/eBayISAPI.dll\" query=\"RegisterEnterInfo\" port=\"443\" user-agent=\"Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\" successMatch=\"ebaystatic.com/\" virtual-host=\"scgi.ebay.com\" disable-ssl-verification=\"false\"/>\n</page-sequence>\n");
        try {
            this.m_monitor.poll(this.getHttpService("scgi.ebay.com"), this.m_params);
            Assert.fail((String)"Expected SSL host mismatch error");
        }
        catch (Throwable e) {
            Assert.assertTrue((String)("Wrong exception caught: " + e.getClass().getName()), (boolean)(e instanceof AssertionError));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="EBay tests stopped working, we REALLY need to make our own repeatable version of this test")
    public void testHttpsWithoutHostValidation() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page scheme=\"https\" path=\"/ws/eBayISAPI.dll\" query=\"RegisterEnterInfo\" port=\"443\" user-agent=\"Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\" successMatch=\"ebaystatic.com/\" virtual-host=\"scgi.ebay.com\"/>\n</page-sequence>\n");
        PollStatus googleStatus = this.m_monitor.poll(this.getHttpService("scgi.ebay.com"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + googleStatus + ": reason = " + googleStatus.getReason()), (boolean)googleStatus.isAvailable());
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page scheme=\"https\" path=\"/ws/eBayISAPI.dll\" query=\"RegisterEnterInfo\" port=\"443\" user-agent=\"Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0)\" successMatch=\"ebaystatic.com/\" virtual-host=\"scgi.ebay.com\" disable-host-verification=\"true\"/>\n</page-sequence>\n");
        googleStatus = this.m_monitor.poll(this.getHttpService("scgi.ebay.com"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + googleStatus + ": reason = " + googleStatus.getReason()), (boolean)googleStatus.isAvailable());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testLogin() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page virtual-host=\"localhost\" path=\"/opennms/\" port=\"10342\" successMatch=\"Password\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" response-range=\"300-399\">\n    <parameter key=\"j_username\" value=\"demo\"/>\n    <parameter key=\"j_password\" value=\"demo\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/events.html\" port=\"10342\" successMatch=\"Event Queries\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_logout\" port=\"10342\" successMatch=\"Login with Username and Password\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    public void testVirtualHost() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page user-agent=\"Donald\" path=\"/\" port=\"80\" successMatch=\"Get the Network to Work\" virtual-host=\"www.opennms.com\"/>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("www.opennms.com"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    public void testVirtualHostBadBehaviorForWordpressPlugin() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/\" port=\"80\" successMatch=\"Get the Network to Work\" user-agent=\"Jakarta Commons-HttpClient/3.0.1\" virtual-host=\"www.opennms.com\"/>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("www.opennms.com"), this.m_params);
        Assert.assertTrue((String)("Expected unavailable but was " + status + ": reason = " + status.getReason()), (boolean)status.isDown());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testLoginDynamicCredentials() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" response-range=\"300-399\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/events.html\" port=\"10342\" successMatch=\"Event Queries\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_logout\" port=\"10342\" successMatch=\"Login with Username and Password\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testLoginDynamicCredentialsTwice() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&gt;Login (.)(.)(.)(.) Username and Password&lt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\"  response-range=\"300-399\" port=\"10342\" method=\"POST\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/spring_security_login\"  port=\"10342\" failureMatch=\"(?s)Log out\" failureMessage=\"Login should have Failed but did not\" successMatch=\"(?s)Your login attempt was not successful.*\">\n    <parameter key=\"login_error\" value=\"\"/>\n  </page>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\"  response-range=\"300-399\" port=\"10342\" method=\"POST\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/events.html\" port=\"10342\" successMatch=\"Event Queries\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_logout\" port=\"10342\" successMatch=\"Login with Username and Password\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testLoginDynamicCredentialsRedirectPost() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" failureMatch=\"(?s)Your login attempt was not successful.*Reason: ([^&lt;]*)\" failureMessage=\"Login in Failed: ${1}\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/events.html\" port=\"10342\" successMatch=\"Event Queries\" />\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_logout\" port=\"10342\" successMatch=\"Login with Username and Password\" />\n</page-sequence>\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.m_params.entrySet()) {
            params.put(entry.getKey(), entry.getValue());
        }
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testRedirectLocationMatch() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" response-range=\"300-399\" locationMatch=\"/opennms/\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testRedirectLocationDoesNotMatch() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"(?s)&lt;hea(.)&gt;&lt;titl(.)&gt;.*&lt;/for(.)&gt;&lt;/b(.)dy&gt;\">\n    <session-variable name=\"ltr1\" match-group=\"1\" />\n    <session-variable name=\"ltr2\" match-group=\"2\" />\n    <session-variable name=\"ltr3\" match-group=\"3\" />\n    <session-variable name=\"ltr4\" match-group=\"4\" />\n  </page>\n  <page virtual-host=\"localhost\" path=\"/opennms/j_spring_security_check\" port=\"10342\" method=\"POST\" response-range=\"300-399\" locationMatch=\"/opensadfnms/\">\n    <parameter key=\"j_username\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n    <parameter key=\"j_password\" value=\"${ltr1}${ltr2}${ltr3}${ltr4}\"/>\n  </page>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected down but was " + status + ": reason = " + status.getReason()), (boolean)status.isDown());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testDsNamePerPage() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page path=\"/opennms/\" ds-name=\"test1\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"&lt;title&gt;(.*?)&lt;/title&gt;\" />\n  <page path=\"/opennms/j_spring_security_check\" ds-name=\"test2\" port=\"10342\" virtual-host=\"localhost\" successMatch=\"&lt;title&gt;(.*?)&lt;/title&gt;\" />\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
        Assert.assertTrue((String)"Expected three DSes", (3 == status.getProperties().size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected a DS called 'test1' but did not find one", (boolean)status.getProperties().containsKey("test1"));
        Assert.assertTrue((String)"Expected a DS called 'test2' but did not find one", (boolean)status.getProperties().containsKey("test2"));
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testRequireIPv6() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page host=\"localhost\" path=\"/opennms/\" port=\"10342\" requireIPv6=\"true\"/>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }

    @Test
    @JUnitHttpServer(port=10342, webapps={@Webapp(context="/opennms", path="src/test/resources/loginTestWar")})
    public void testRequireIPv4() throws Exception {
        this.m_params.put("page-sequence", "<?xml version=\"1.0\"?><page-sequence>\n  <page host=\"localhost\" path=\"/opennms/\" port=\"10342\" requireIPv4=\"true\"/>\n</page-sequence>\n");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }
}

