/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.monitors.HostResourceSwRunMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml"})
@JUnitSnmpAgent(port=9161, host="127.0.0.1", resource="classpath:org/opennms/netmgt/snmp/snmpTestData1.properties")
public class HostResourceSWRunMonitorTest
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(HostResourceSWRunMonitorTest.class);
    static final int TEST_SNMP_PORT = 9161;
    static final String TEST_IP_ADDRESS = "127.0.0.1";
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;
    private boolean m_ignoreWarnings = false;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() throws Exception {
        this.m_ignoreWarnings = false;
        MockLogAppender.setupLogging();
        SnmpPeerFactory.setInstance((SnmpPeerFactory)this.m_snmpPeerFactory);
    }

    @After
    public void tearDown() throws Exception {
        if (!this.m_ignoreWarnings) {
            MockLogAppender.assertNoWarningsOrGreater();
        }
    }

    @Test
    public void testUnknownService() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("service-name", "this service does not exist!");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertFalse((boolean)status.isAvailable());
        this.log(status.getReason());
    }

    @Test
    public void testMonitorWithRegex() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }

    @Test
    public void testMonitorWithoutRegex() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("service-name", "eclipse");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }

    @Test
    public void testMinServices() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("min-services", "2");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }

    @Test
    public void testInvalidMinServices() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("min-services", "5");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertFalse((boolean)status.isAvailable());
        this.log(status.getReason());
    }

    @Test
    public void testMaxServices() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("max-services", "5");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }

    @Test
    public void testInvalidMaxServices() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("max-services", "3");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertFalse((boolean)status.isAvailable());
        this.log(status.getReason());
    }

    @Test
    public void testServicesRange() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("min-services", "2");
        parameters.put("max-services", "5");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }

    @Test
    public void testInvalidRange() throws Exception {
        this.m_ignoreWarnings = true;
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("min-services", "8");
        parameters.put("max-services", "5");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertFalse((boolean)status.isAvailable());
        this.log(status.getReason());
    }

    @Test
    public void testServicesRangeWithoutMatchAll() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("min-services", "1");
        parameters.put("max-services", "3");
        parameters.put("match-all", "false");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertTrue((boolean)status.isAvailable());
    }

    @Test
    public void testInvalidServicesRange() throws Exception {
        HostResourceSwRunMonitor monitor = new HostResourceSwRunMonitor();
        Map<String, Object> parameters = this.createBasicParams();
        parameters.put("min-services", "1");
        parameters.put("max-services", "3");
        PollStatus status = monitor.poll(this.createMonitor(), parameters);
        Assert.assertFalse((boolean)status.isAvailable());
        this.log(status.getReason());
    }

    private Map<String, Object> createBasicParams() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("port", this.m_snmpPeerFactory.getAgentConfig(InetAddressUtils.getInetAddress((String)TEST_IP_ADDRESS)).getPort());
        parameters.put("service-name", "~^(auto|sh).*");
        parameters.put("match-all", "true");
        return parameters;
    }

    private MonitoredService createMonitor() throws UnknownHostException {
        MockMonitoredService svc = new MockMonitoredService(1, "test-server", InetAddressUtils.getInetAddress((String)TEST_IP_ADDRESS), "SWRUN-TEST");
        return svc;
    }

    private void log(String message) {
        LOG.debug(message);
    }
}

