/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentSkipListMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.dns.annotations.DNSEntry;
import org.opennms.core.test.dns.annotations.DNSZone;
import org.opennms.core.test.dns.annotations.JUnitDNSServer;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.mock.MockMonitoredService;
import org.opennms.netmgt.poller.mock.MonitorTestUtils;
import org.opennms.netmgt.poller.monitors.DnsMonitor;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.test.context.ContextConfiguration;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/emptyContext.xml"})
@JUnitDNSServer(port=9153, zones={@DNSZone(name="example.com", entries={@DNSEntry(hostname="test", address="192.168.0.1")}), @DNSZone(name="ipv6.example.com", entries={@DNSEntry(hostname="ipv6test", address="2001:4860:8007::63", ipv6=true)})})
@JUnitConfigurationEnvironment
public class DnsMonitorTest {
    @Before
    public void setup() throws Exception {
        MockLogAppender.setupLogging((boolean)true);
    }

    @Test
    public void testIPV6Response() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        DnsMonitor monitor = new DnsMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)99, (InetAddress)InetAddressUtils.addr((String)"::1"), (String)"DNS");
        m.put("port", "9153");
        m.put("retry", "1");
        m.put("timeout", "1000");
        m.put("lookup", "ipv6.example.com");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
    }

    @Test
    public void testNotFound() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        DnsMonitor monitor = new DnsMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)99, (InetAddress)InetAddressUtils.addr((String)"127.0.0.1"), (String)"DNS");
        m.put("port", "9153");
        m.put("retry", "2");
        m.put("timeout", "5000");
        m.put("lookup", "bogus.example.com");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((String)"Expected service to be available", (long)1L, (long)status.getStatusCode());
    }

    @Test
    public void testNotFoundWithCustomRcode() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        DnsMonitor monitor = new DnsMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)99, (InetAddress)InetAddressUtils.addr((String)"127.0.0.1"), (String)"DNS");
        m.put("port", "9153");
        m.put("retry", "2");
        m.put("timeout", "5000");
        m.put("lookup", "bogus.example.com");
        m.put("fatal-response-codes", "3");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
    }

    @Test
    public void testUnrecoverable() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        DnsMonitor monitor = new DnsMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)99, (InetAddress)InetAddressUtils.addr((String)"192.168.1.120"), (String)"DNS");
        m.put("port", "9000");
        m.put("retry", "2");
        m.put("timeout", "500");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
    }

    @Test
    public void testDNSIPV4Response() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        DnsMonitor monitor = new DnsMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)99, (InetAddress)InetAddressUtils.addr((String)"127.0.0.1"), (String)"DNS");
        m.put("port", "9153");
        m.put("retry", "1");
        m.put("timeout", "3000");
        m.put("lookup", "example.com");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)1L, (long)status.getStatusCode());
    }

    @Test
    public void testTooFewAnswers() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        DnsMonitor monitor = new DnsMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)99, (InetAddress)InetAddressUtils.addr((String)"127.0.0.1"), (String)"DNS");
        m.put("port", "9153");
        m.put("retry", "1");
        m.put("timeout", "3000");
        m.put("lookup", "example.empty");
        m.put("min-answers", "1");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
    }

    @Test
    public void testTooManyAnswers() throws UnknownHostException {
        ConcurrentSkipListMap<String, String> m = new ConcurrentSkipListMap<String, String>();
        DnsMonitor monitor = new DnsMonitor();
        MockMonitoredService svc = MonitorTestUtils.getMonitoredService((int)99, (InetAddress)InetAddressUtils.addr((String)"127.0.0.1"), (String)"DNS");
        m.put("port", "9153");
        m.put("retry", "1");
        m.put("timeout", "3000");
        m.put("lookup", "example.com");
        m.put("max-answers", "0");
        PollStatus status = monitor.poll((MonitoredService)svc, m);
        MockUtil.println((String)("Reason: " + status.getReason()));
        Assert.assertEquals((long)2L, (long)status.getStatusCode());
    }

    @Test
    public void testDnsJavaResponse() throws IOException {
        Lookup l = new Lookup("example.com");
        SimpleResolver resolver = new SimpleResolver("127.0.0.1");
        resolver.setPort(9153);
        l.setResolver((Resolver)resolver);
        l.run();
        System.out.println("result: " + l.getResult());
        if (l.getResult() == 0) {
            System.out.println(l.getAnswers()[0].rdataToString());
        }
        Assert.assertTrue((l.getResult() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDnsJavaQuadARecord() throws IOException {
        Lookup l = new Lookup("ipv6.example.com", 28);
        SimpleResolver resolver = new SimpleResolver("::1");
        resolver.setPort(9153);
        l.setResolver((Resolver)resolver);
        l.run();
        System.out.println("result: " + l.getResult());
        if (l.getResult() == 0) {
            System.out.println(l.getAnswers()[0].rdataToString());
        }
        Assert.assertTrue((l.getResult() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDnsJavaWithDnsServer() throws TextParseException, UnknownHostException {
        Lookup l = new Lookup("example.com", 28);
        SimpleResolver resolver = new SimpleResolver("::1");
        resolver.setPort(9153);
        l.setResolver((Resolver)resolver);
        l.run();
        System.out.println("result: " + l.getResult());
        Record[] answers = l.getAnswers();
        Assert.assertEquals((long)answers.length, (long)1L);
        Record record = answers[0];
        System.err.println(record.getTTL());
        if (l.getResult() == 0) {
            System.out.println(l.getAnswers()[0].rdataToString());
        }
        Assert.assertTrue((l.getResult() == 0 ? 1 : 0) != 0);
    }

    @Test
    @JUnitDNSServer(port=9153, zones={})
    public void testNoAnswer() throws Exception {
        Lookup l = new Lookup("example.com", 28);
        SimpleResolver resolver = new SimpleResolver("::1");
        resolver.setPort(9153);
        l.setResolver((Resolver)resolver);
        l.run();
        System.out.println("result: " + l.getResult());
        Record[] answers = l.getAnswers();
        Assert.assertNotNull((Object)answers);
        Assert.assertEquals((long)answers.length, (long)1L);
        Record record = answers[0];
        System.err.println(record.getTTL());
        if (l.getResult() == 0) {
            System.out.println(l.getAnswers()[0].rdataToString());
        }
        Assert.assertTrue((l.getResult() == 0 ? 1 : 0) != 0);
    }
}

